/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.javadoc.hints.Access;
import org.netbeans.modules.javadoc.hints.Analyzer;
import org.netbeans.modules.javadoc.hints.JavadocGenerator;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public final class GenerateJavadocAction
extends TextAction {
    GenerateJavadocAction() {
        super("fix-javadoc-action");
    }

    public static GenerateJavadocAction create() {
        return new GenerateJavadocAction();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        Document document = jTextComponent.getDocument();
        if (!(document instanceof StyledDocument)) {
            return;
        }
        try {
            Descriptor descriptor = this.prepareGenerating(document, jTextComponent.getCaretPosition());
            if (descriptor != null) {
                this.generate(document, descriptor, jTextComponent);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private Descriptor prepareGenerating(final Document document, final int n) throws IOException {
        JavaSource javaSource = JavaSource.forDocument((Document)document);
        if (javaSource == null) {
            return null;
        }
        final Descriptor descriptor = new Descriptor();
        FileObject fileObject = (FileObject)javaSource.getFileObjects().iterator().next();
        SourceVersion sourceVersion = Analyzer.resolveSourceVersion(fileObject);
        final JavadocGenerator javadocGenerator = new JavadocGenerator(sourceVersion);
        javadocGenerator.updateSettings(fileObject);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws Exception {
                Element element;
                Object object;
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TokenHierarchy tokenHierarchy = compilationController.getTokenHierarchy();
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() || tokenSequence.token().id() != JavaTokenId.JAVADOC_COMMENT) {
                    return;
                }
                descriptor.caret = document.createPosition(n);
                int n3 = tokenSequence.offset();
                int n2 = tokenSequence.offset() + tokenSequence.token().length();
                while (tokenSequence.moveNext()) {
                    object = tokenSequence.token().id();
                    if (object == JavaTokenId.WHITESPACE || object == JavaTokenId.LINE_COMMENT || object == JavaTokenId.BLOCK_COMMENT) continue;
                    n2 = tokenSequence.offset();
                    ++n2;
                    break;
                }
                object = compilationController.getTreeUtilities().pathFor(n2);
                Tree tree = ((TreePath)object).getLeaf();
                Tree.Kind kind = tree.getKind();
                SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
                while (kind != Tree.Kind.CLASS && kind != Tree.Kind.METHOD && kind != Tree.Kind.VARIABLE && kind != Tree.Kind.COMPILATION_UNIT) {
                    if ((object = ((TreePath)object).getParentPath()) == null) {
                        tree = null;
                        kind = null;
                        break;
                    }
                    tree = ((TreePath)object).getLeaf();
                    kind = tree.getKind();
                }
                if (tree == null || sourcePositions.getStartPosition(compilationController.getCompilationUnit(), tree) < (long)n3) {
                    return;
                }
                if (kind != Tree.Kind.COMPILATION_UNIT && !Analyzer.hasErrors(tree) && Access.PRIVATE.isAccessible((CompilationInfo)compilationController, (TreePath)object, true) && (element = compilationController.getTrees().getElement((TreePath)object)) != null) {
                    descriptor.javadoc = javadocGenerator.generateComment(element, (CompilationInfo)compilationController);
                }
            }
        }, true);
        return descriptor.javadoc != null ? descriptor : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(final Document document, final Descriptor descriptor, final JTextComponent jTextComponent) throws BadLocationException {
        final Indent indent = Indent.get((Document)document);
        try {
            indent.lock();
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)document), (Runnable)new Runnable(){

                public void run() {
                    try {
                        int n = jTextComponent.getCaretPosition();
                        GenerateJavadocAction.this.generateJavadoc(document, descriptor, indent);
                        jTextComponent.setCaretPosition(n);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
    }

    private void generateJavadoc(Document document, Descriptor descriptor, Indent indent) throws BadLocationException {
        String string = descriptor.javadoc.substring("/**\n".length(), descriptor.javadoc.length() - "\n*/\n".length());
        if (string.length() == 0) {
            return;
        }
        Position position = descriptor.caret;
        int n = position.getOffset();
        document.insertString(n, string, null);
        if (n != position.getOffset()) {
            indent.reindent(n + 1, position.getOffset());
        }
    }

    private static final class Descriptor {
        String javadoc;
        Position caret;

        private Descriptor() {
        }
    }
}

