/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DescriptorRegistryListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.palette.PaletteItemDataNode;
import org.netbeans.modules.vmd.palette.PaletteKit;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PaletteMap
implements ActiveDocumentSupport.Listener,
DescriptorRegistryListener,
PropertyChangeListener {
    private static final PaletteMap INSTANCE = new PaletteMap();
    private final WeakHashMap<String, WeakReference<PaletteKit>> kitMap = new WeakHashMap();
    private String activeProjectID;
    private DescriptorRegistry registeredRegistry;
    private final AtomicBoolean requiresPaletteUpdate = new AtomicBoolean(false);
    private final Set<String> registeredProjects = new HashSet<String>();
    private static RequestProcessor updateRP = new RequestProcessor("Update paletteKit");

    private PaletteMap() {
        ActiveDocumentSupport.getDefault().addActiveDocumentListener((ActiveDocumentSupport.Listener)this);
    }

    public static PaletteMap getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeDocumentChanged(DesignDocument designDocument, DesignDocument designDocument2) {
        boolean bl;
        String string;
        if (designDocument2 == null) {
            return;
        }
        DescriptorRegistry descriptorRegistry = designDocument2.getDescriptorRegistry();
        if (this.registeredRegistry != descriptorRegistry) {
            if (this.registeredRegistry != null) {
                this.registeredRegistry.removeRegistryListener((DescriptorRegistryListener)this);
            }
            this.registeredRegistry = descriptorRegistry;
            if (this.registeredRegistry != null) {
                this.registeredRegistry.addRegistryListener((DescriptorRegistryListener)this);
            }
        }
        PaletteMap paletteMap = this;
        synchronized (paletteMap) {
            string = this.activeProjectID;
            this.activeProjectID = designDocument2.getDocumentInterface().getProjectID();
        }
        boolean bl2 = bl = !this.activeProjectID.equals(string);
        if (bl) {
            this.registerClassPathListener(designDocument2);
        }
        this.updatePalette(designDocument2, bl);
    }

    public void activeComponentsChanged(Collection<DesignComponent> collection) {
    }

    public void descriptorRegistryUpdated() {
        this.updatePalette(ActiveDocumentSupport.getDefault().getActiveDocument(), false);
    }

    private void updatePalette(DesignDocument designDocument, boolean bl) {
        if (bl) {
            for (WeakReference<PaletteKit> object2 : this.kitMap.values()) {
                PaletteKit paletteKit = (PaletteKit)object2.get();
                if (paletteKit == null) continue;
                paletteKit.clearNodesStateCache();
            }
        }
        if (designDocument == null) {
            return;
        }
        WeakReference<PaletteKit> weakReference = this.kitMap.get(designDocument.getDocumentInterface().getProjectType());
        if (weakReference == null) {
            return;
        }
        PaletteKit paletteKit = (PaletteKit)weakReference.get();
        if (paletteKit == null) {
            return;
        }
        paletteKit.setActiveDocument(designDocument);
        if (bl) {
            this.scheduleUpdateAfteCPScanned(designDocument, paletteKit);
        } else {
            paletteKit.init();
        }
    }

    public synchronized PaletteKit getPaletteKitForProjectType(String string) {
        PaletteKit paletteKit;
        WeakReference<PaletteKit> weakReference = this.kitMap.get(string);
        PaletteKit paletteKit2 = paletteKit = weakReference != null ? (PaletteKit)weakReference.get() : null;
        if (paletteKit == null) {
            paletteKit = new PaletteKit(string);
            this.kitMap.put(string, new WeakReference<PaletteKit>(paletteKit));
        }
        return paletteKit;
    }

    void checkValidity(String string, Lookup lookup) {
        PaletteKit paletteKit;
        WeakReference<PaletteKit> weakReference = this.kitMap.get(string);
        PaletteKit paletteKit2 = paletteKit = weakReference != null ? (PaletteKit)weakReference.get() : null;
        if (paletteKit == null) {
            PaletteItemDataNode paletteItemDataNode = (PaletteItemDataNode)((Object)lookup.lookup(PaletteItemDataNode.class));
            if (paletteItemDataNode != null) {
                paletteItemDataNode.setNeedCheck(false);
                paletteItemDataNode.setValid(true);
            }
        } else {
            paletteKit.checkValidity(lookup);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.schedulePaletteUpdate();
    }

    private void scheduleUpdateAfteCPScanned(DesignDocument designDocument, final PaletteKit paletteKit) {
        Project project = org.netbeans.modules.vmd.api.io.ProjectUtils.getProject((DesignDocument)designDocument);
        final ClasspathInfo classpathInfo = this.getClasspathInfo(project);
        if (classpathInfo == null) {
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UpdateTask
        implements Runnable,
        Task<CompilationController> {
            UpdateTask() {
            }

            @Override
            public void run() {
                try {
                    JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]).runWhenScanFinished((Task)this, true);
                }
                catch (IOException iOException) {
                    Debug.warning((Object[])new Object[]{iOException});
                }
            }

            public void run(CompilationController compilationController) throws Exception {
                paletteKit.init();
            }
        }
        updateRP.post((Runnable)new UpdateTask());
    }

    private void registerClassPathListener(DesignDocument designDocument) {
        Project project = org.netbeans.modules.vmd.api.io.ProjectUtils.getProject((DesignDocument)designDocument);
        ClasspathInfo classpathInfo = this.getClasspathInfo(project);
        if (classpathInfo == null) {
            return;
        }
        String string = designDocument.getDocumentInterface().getProjectID();
        if (!this.registeredProjects.contains(string)) {
            ListenerCancellableTask listenerCancellableTask = new ListenerCancellableTask(classpathInfo);
            try {
                JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]).runUserActionTask((Task)listenerCancellableTask, true);
                this.registeredProjects.add(string);
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException});
            }
        }
    }

    private ClasspathInfo getClasspathInfo(Project project) {
        if (project == null) {
            return null;
        }
        SourceGroup sourceGroup = this.getSourceGroup(project);
        if (sourceGroup == null) {
            return null;
        }
        FileObject fileObject = sourceGroup.getRootFolder();
        return ClasspathInfo.create((FileObject)fileObject);
    }

    private SourceGroup getSourceGroup(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray == null || sourceGroupArray.length < 1) {
            return null;
        }
        return sourceGroupArray[0];
    }

    private void schedulePaletteUpdate() {
        if (this.requiresPaletteUpdate.getAndSet(true)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                while (PaletteMap.this.requiresPaletteUpdate.getAndSet(false)) {
                    for (WeakReference weakReference : PaletteMap.this.kitMap.values()) {
                        PaletteKit paletteKit = (PaletteKit)weakReference.get();
                        if (paletteKit == null) continue;
                        paletteKit.clearNodesStateCache();
                        paletteKit.refreshPaletteController();
                    }
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ListenerCancellableTask
    implements Task<CompilationController> {
        private ClasspathInfo info;

        public ListenerCancellableTask(ClasspathInfo classpathInfo) {
            this.info = classpathInfo;
        }

        public void run(CompilationController compilationController) throws Exception {
            ClassPath classPath = this.info.getClassPath(ClasspathInfo.PathKind.BOOT);
            PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)PaletteMap.this, (Object)classPath);
            classPath.addPropertyChangeListener(propertyChangeListener);
        }
    }
}

