/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.web.debug.Context;
import org.netbeans.modules.web.debug.breakpoints.JspLineBreakpoint;

public class JspBreakpointAnnotationListener
extends DebuggerManagerAdapter {
    private HashMap breakpointToAnnotation = new HashMap();
    private boolean listen = true;

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (!this.listen) {
            return;
        }
        if (!(string.equals("condition") || string.equals("url") || string.equals("lineNumber") || string.equals("enabled"))) {
            return;
        }
        JspLineBreakpoint jspLineBreakpoint = (JspLineBreakpoint)((Object)propertyChangeEvent.getSource());
        this.annotate(jspLineBreakpoint);
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof JspLineBreakpoint) {
            ((JspLineBreakpoint)breakpoint).addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotate((JspLineBreakpoint)breakpoint);
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof JspLineBreakpoint) {
            ((JspLineBreakpoint)breakpoint).removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.removeAnnotation((JspLineBreakpoint)breakpoint);
        }
    }

    public JspLineBreakpoint findBreakpoint(String string, int n) {
        for (JspLineBreakpoint jspLineBreakpoint : this.breakpointToAnnotation.keySet()) {
            Object v;
            int n2;
            if (!jspLineBreakpoint.getURL().equals(string) || (n2 = Context.getLineNumber(v = this.breakpointToAnnotation.get((Object)jspLineBreakpoint), null)) != n) continue;
            return jspLineBreakpoint;
        }
        return null;
    }

    private void annotate(JspLineBreakpoint jspLineBreakpoint) {
        Object object = this.breakpointToAnnotation.get((Object)jspLineBreakpoint);
        if (object != null) {
            Context.removeAnnotation(object);
        }
        if (jspLineBreakpoint.isHidden()) {
            return;
        }
        object = Context.annotate(jspLineBreakpoint);
        if (object == null) {
            return;
        }
        this.breakpointToAnnotation.put(jspLineBreakpoint, object);
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object object2 = null;
        if (debuggerEngine != null) {
            object2 = debuggerEngine.lookupFirst(null, JPDADebugger.class);
        }
        this.update(jspLineBreakpoint, object2);
    }

    public void updateJspLineBreakpoints() {
        for (JspLineBreakpoint jspLineBreakpoint : this.breakpointToAnnotation.keySet()) {
            this.update(jspLineBreakpoint, null);
        }
    }

    private void update(JspLineBreakpoint jspLineBreakpoint, Object object) {
        Object v = this.breakpointToAnnotation.get((Object)jspLineBreakpoint);
        if (v == null) {
            return;
        }
        int n = Context.getLineNumber(v, object);
        this.listen = false;
        jspLineBreakpoint.setLineNumber(n);
        this.listen = true;
    }

    private void removeAnnotation(JspLineBreakpoint jspLineBreakpoint) {
        Object v = this.breakpointToAnnotation.remove((Object)jspLineBreakpoint);
        if (v != null) {
            Context.removeAnnotation(v);
        }
    }
}

