/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.groovy.refactoring.JavaIdentifiers;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringUtil {
    private static final String JAVA_MIME_TYPE = "text/x-java";

    private RefactoringUtil() {
    }

    public static Problem addToEnd(Problem problem, Problem problem2) {
        if (problem2 == null) {
            return problem;
        }
        if (problem == null) {
            return problem2;
        }
        Problem problem3 = problem2;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem);
        return problem3;
    }

    public static boolean isJavaFile(FileObject fileObject) {
        return JAVA_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static String renameClass(String string, String string2) {
        Parameters.notEmpty((CharSequence)"originalFullyQualifiedName", (CharSequence)string);
        Parameters.notEmpty((CharSequence)"newName", (CharSequence)string2);
        int n = string.lastIndexOf(46);
        return n <= 0 ? string2 : string.substring(0, n + 1) + string2;
    }

    public static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        if (OpenProjects.getDefault().isProjectOpen(project)) {
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                if (fileObject == sourceGroupArray[i].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void collectChildren(FileObject fileObject, List<FileObject> list) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (RefactoringUtil.isJavaFile(fileObject2)) {
                list.add(fileObject2);
                continue;
            }
            if (!fileObject2.isFolder()) continue;
            RefactoringUtil.collectChildren(fileObject2, list);
        }
    }

    public static boolean isPackage(RenameRefactoring renameRefactoring) {
        return renameRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null;
    }

    public static String constructNewName(FileObject fileObject, RenameRefactoring renameRefactoring) {
        String string = JavaIdentifiers.getQualifiedName(fileObject);
        if (RefactoringUtil.isPackage(renameRefactoring)) {
            return renameRefactoring.getNewName() + "." + JavaIdentifiers.unqualify(string);
        }
        FileObject fileObject2 = (FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class);
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
        FileObject fileObject3 = classPath.findOwnerRoot(fileObject2);
        String string2 = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2.getParent()).replace('/', '.');
        String string3 = RefactoringUtil.buildName(string2, fileObject2.getName());
        String string4 = RefactoringUtil.buildName(string2, renameRefactoring.getNewName());
        int n = string.lastIndexOf(string3) + string3.length();
        return string4 + string.substring(n, string.length());
    }

    private static String buildName(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        return string + "." + string2;
    }

    public static String getPackageName(URL uRL) {
        File file = null;
        try {
            file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + uRL);
        }
        String string = "";
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(string)) {
                    return RefactoringUtil.getPackageName(fileObject);
                }
                String string2 = RefactoringUtil.getPackageName(fileObject);
                return string2 + ("".equals(string2) ? "" : ".") + string;
            }
            if (!"".equals(string)) {
                string = "." + string;
            }
            string = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1)) + string;
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + uRL);
    }

    private static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    public static List<String> getRefactoredClasses(AbstractRefactoring abstractRefactoring) {
        TreePathHandle treePathHandle;
        Collection collection;
        HashSet<TreePathHandle> hashSet = new HashSet<TreePathHandle>();
        hashSet.addAll(abstractRefactoring.getRefactoringSource().lookupAll(TreePathHandle.class));
        if (hashSet.isEmpty()) {
            collection = abstractRefactoring.getRefactoringSource().lookupAll(FileObject.class);
            for (final TreePathHandle treePathHandle2 : collection) {
                treePathHandle = RefactoringUtil.resolveHandle((FileObject)treePathHandle2);
                if (treePathHandle == null) continue;
                hashSet.add(treePathHandle);
            }
        }
        collection = new ArrayList();
        for (final TreePathHandle treePathHandle2 : hashSet) {
            treePathHandle = JavaSource.forFileObject((FileObject)treePathHandle2.getFileObject());
            try {
                treePathHandle.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        Element element = treePathHandle2.resolveElement((CompilationInfo)compilationController);
                        collection.add(((Object)element.asType()).toString());
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return collection;
    }

    private static TreePathHandle resolveHandle(FileObject fileObject) {
        final TreePathHandle[] treePathHandleArray = new TreePathHandle[1];
        if (!RefactoringUtil.isJavaFile(fileObject)) {
            return null;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                    if (compilationUnitTree.getTypeDecls().isEmpty()) {
                        return;
                    }
                    treePathHandleArray[0] = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, compilationUnitTree.getTypeDecls().get(0)), (CompilationInfo)compilationController);
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return treePathHandleArray[0];
    }
}

