/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import org.netbeans.modules.vmd.midpnb.screen.display.TextRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;

class SVGListCellRenderer
extends TextRenderer {
    private float myX;
    private float myY;
    private float myHeight;
    private float myTextWidth = -1.0f;
    Document myDocument;
    SVGLocatableElement myBounds;
    SVGLocatableElement myContent;

    SVGListCellRenderer(Document document, float f, SVGLocatableElement sVGLocatableElement, SVGLocatableElement sVGLocatableElement2, SVGLocatableElement sVGLocatableElement3) {
        super(sVGLocatableElement);
        this.myDocument = document;
        this.myHeight = f;
        this.myBounds = sVGLocatableElement2;
        this.myContent = sVGLocatableElement3;
        this.initEmpiricalLetterWidth(sVGLocatableElement);
    }

    public void clearContent() {
        Element element = this.getContentElement().getFirstElementChild();
        while (element != null) {
            String string;
            Element element2 = null;
            if (element instanceof SVGElement) {
                element2 = ((SVGElement)element).getNextElementSibling();
            }
            if (!"text".equals(element.getLocalName())) {
                this.getContentElement().removeChild((Node)element);
            } else if (element instanceof SVGElement && !"none".equals(string = ((SVGElement)element).getTrait("display"))) {
                Element element3 = element;
                this.getContentElement().removeChild((Node)element3);
            }
            element = element2;
        }
    }

    public SVGLocatableElement getCellRendererComponent(Object object, int n) {
        SVGLocatableElement sVGLocatableElement = this.getHiddenTextElement();
        if (sVGLocatableElement == null) {
            throw new IllegalArgumentException("List argument doesn't contain hidden text for access to fontcharacteristics. Unable render any value.");
        }
        this.myX = sVGLocatableElement.getFloatTrait("x");
        this.myY = sVGLocatableElement.getFloatTrait("y");
        if (this.getBoundsElement().getBBox() != null && sVGLocatableElement.getBBox() != null && this.myTextWidth == -1.0f) {
            this.myTextWidth = this.getBoundsElement().getBBox().getWidth() + 0.5f - (sVGLocatableElement.getBBox().getX() - this.getBoundsElement().getBBox().getX()) * 2.0f;
        }
        SVGLocatableElement sVGLocatableElement2 = (SVGLocatableElement)this.myDocument.createElementNS("http://www.w3.org/2000/svg", "text");
        sVGLocatableElement2.setFloatTrait("x", this.myX);
        sVGLocatableElement2.setFloatTrait("y", this.myY + (float)n * this.myHeight);
        sVGLocatableElement2.setFloatTrait("font-size", sVGLocatableElement.getFloatTrait("font-size"));
        sVGLocatableElement2.setTrait("font-family", sVGLocatableElement.getTrait("font-family"));
        sVGLocatableElement2.setTrait("visibility", "inherit");
        if (object == null) {
            sVGLocatableElement2.setTrait("#text", "");
        } else if (this.myTextWidth == -1.0f) {
            sVGLocatableElement2.setTrait("#text", object.toString());
        } else {
            String string = this.truncateToShownText(object.toString(), this.myTextWidth);
            sVGLocatableElement2.setTrait("#text", string);
        }
        this.getContentElement().appendChild((Node)sVGLocatableElement2);
        return sVGLocatableElement2;
    }

    SVGLocatableElement getBoundsElement() {
        return this.myBounds;
    }

    SVGLocatableElement getContentElement() {
        return this.myContent;
    }
}

