/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListElementEventSourceCD;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGListPropertyCustomEditor
extends JPanel {
    private static final String NEW_LINE = "\n";
    private static final String CARET_RET = "\r";
    private JLabel myLabel;
    private JScrollPane myScrollPane;
    private JTextArea myTextArea;

    public SVGListPropertyCustomEditor() {
        this.initComponents();
    }

    private void initComponents() {
        this.myLabel = new JLabel();
        this.myScrollPane = new JScrollPane();
        this.myTextArea = new JTextArea();
        this.myLabel.setLabelFor(this.myTextArea);
        Mnemonics.setLocalizedText((JLabel)this.myLabel, (String)NbBundle.getMessage(SVGListPropertyCustomEditor.class, (String)"LBL_DefaultListDescription"));
        this.myTextArea.setColumns(20);
        this.myTextArea.setRows(5);
        this.myScrollPane.setViewportView(this.myTextArea);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.myLabel, -1, 394, Short.MAX_VALUE).add(2, (Component)this.myScrollPane, -1, 394, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.myLabel, -2, 28, -2).addPreferredGap(0).add((Component)this.myScrollPane, -1, 180, Short.MAX_VALUE).addContainerGap()));
    }

    void cleanUp() {
    }

    void removeElemnts() {
        this.myTextArea.setText(null);
        this.myTextArea.removeAll();
    }

    void setValue(PropertyValue propertyValue) {
        this.myTextArea.setText(null);
        this.myTextArea.removeAll();
        List list = propertyValue.getArray();
        if (list == null || !list.iterator().hasNext()) {
            return;
        }
        if (((PropertyValue)list.iterator().next()).getType() != SVGListElementEventSourceCD.TYPEID) {
            int n = 0;
            for (PropertyValue propertyValue2 : list) {
                String string = propertyValue2.getPrimitiveValue().toString();
                this.myTextArea.append(string);
                if (++n == list.size()) continue;
                this.myTextArea.append(NEW_LINE);
            }
        } else {
            int n = 0;
            for (PropertyValue propertyValue3 : list) {
                String string = (String)propertyValue3.getComponent().readProperty("name").getPrimitiveValue();
                this.myTextArea.append(string);
                if (++n == list.size()) continue;
                this.myTextArea.append(NEW_LINE);
            }
        }
    }

    List<String> getValue() {
        String string = this.myTextArea.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList;
    }
}

