/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.introduce.ErrorLabel;
import org.netbeans.modules.ruby.hints.introduce.IntroduceVariablePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroduceMethodPanel
extends JPanel {
    private JButton btnOk;
    private Set<String> takenNames;
    private ButtonGroup accessGroup;
    private JLabel errorLabel;
    private ButtonGroup initilizeIn;
    private JLabel lblName;
    private JTextField name;
    private String methodNameTest;

    public IntroduceMethodPanel(String string, Set<String> set) {
        this.takenNames = set;
        this.initComponents();
        this.name.setText(string);
        if (string != null && string.trim().length() > 0) {
            this.name.setCaretPosition(string.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(string.length());
        }
    }

    public void setOkButton(JButton jButton) {
        this.btnOk = jButton;
        this.btnOk.setEnabled(((ErrorLabel)this.errorLabel).isInputTextValid());
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            public String validate(String string) {
                if (null == string || string.length() == 0) {
                    return "";
                }
                if (!RubyUtils.isValidRubyMethodName((String)string)) {
                    return IntroduceMethodPanel.this.getDefaultErrorMessage(string);
                }
                if (IntroduceMethodPanel.this.takenNames.contains(string)) {
                    return NbBundle.getMessage(IntroduceVariablePanel.class, (String)"MethodAlreadyExists", (Object)string);
                }
                return null;
            }
        };
        final ErrorLabel errorLabel = new ErrorLabel(this.name.getDocument(), validator);
        errorLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IntroduceMethodPanel.this.btnOk.setEnabled(errorLabel.isInputTextValid());
            }
        });
        return errorLabel;
    }

    String getDefaultErrorMessage(String string) {
        return NbBundle.getMessage(IntroduceMethodPanel.class, (String)"NotValidIdentifier", (Object)string);
    }

    private void initComponents() {
        this.initilizeIn = new ButtonGroup();
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.errorLabel = this.createErrorLabel();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceMethodPanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblName).add(29, 29, 29).add((Component)this.name, -1, 425, Short.MAX_VALUE)).add((Component)this.errorLabel, -1, 494, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.name, -2, -1, -2).add((Component)this.lblName)).addPreferredGap(0, 61, Short.MAX_VALUE).add((Component)this.errorLabel).addContainerGap()));
        this.name.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AN_IntrMethod_Name"));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Dialog"));
    }

    public String getMethodName() {
        if (this.methodNameTest != null) {
            return this.methodNameTest;
        }
        return this.name.getText();
    }

    void setMethodName(String string) {
        this.methodNameTest = string;
    }
}

