/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.nodes.DBElementNodeFactory;
import org.netbeans.modules.dbschema.nodes.DefaultDBFactory;
import org.netbeans.modules.dbschema.nodes.SchemaElementFilter;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class SchemaChildren
extends Children.Keys {
    protected static HashMap propToFilter = new HashMap();
    protected SchemaElement element;
    protected SchemaElementFilter filter;
    protected DBElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private DBElementListener propL;
    protected Collection[] cpl;
    private boolean nodesInited = false;

    public SchemaChildren(SchemaElement schemaElement) {
        this(DefaultDBFactory.READ_ONLY, schemaElement);
    }

    public SchemaChildren(DBElementNodeFactory dBElementNodeFactory, SchemaElement schemaElement) {
        this.element = schemaElement;
        this.factory = dBElementNodeFactory;
        this.filter = null;
    }

    public Class getFilterClass() {
        return SchemaElementFilter.class;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object object) {
        if (!(object instanceof SchemaElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (SchemaElementFilter)object;
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    protected void addNotify() {
        this.refreshAllKeys();
        if (this.wPropL == null) {
            this.propL = new DBElementListener();
            this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
        } else {
            this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
        }
        this.element.addPropertyChangeListener(this.wPropL);
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof TableElement) {
            return new Node[]{this.factory.createTableNode((TableElement)object)};
        }
        return new Node[0];
    }

    protected void refreshAllKeys() {
        this.cpl = new Collection[this.getOrder().length];
        this.refreshKeys(1);
    }

    protected void refreshKeys(int n) {
        int[] nArray = this.getOrder();
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & n) != 0 || this.cpl[i] == null) {
                this.cpl[i] = this.getKeysOfType(nArray[i]);
                linkedList.addAll(this.cpl[i]);
                continue;
            }
            linkedList.addAll(this.cpl[i]);
        }
        this.setKeys(linkedList);
    }

    protected Collection getKeysOfType(int n) {
        LinkedList linkedList = new LinkedList();
        if ((n & 1) != 0) {
            this.filterModifiers(this.element.getTables(), linkedList);
        }
        return linkedList;
    }

    private void filterModifiers(DBElement[] dBElementArray, Collection collection) {
        int n = dBElementArray.length;
        for (int i = 0; i < n; ++i) {
            collection.add(dBElementArray[i]);
        }
    }

    protected int[] getOrder() {
        return this.filter == null || this.filter.getOrder() == null ? SchemaElementFilter.DEFAULT_ORDER : this.filter.getOrder();
    }

    static {
        propToFilter.put("tables", new Integer(1));
        propToFilter.put("columns", new Integer(4));
        propToFilter.put("indexes", new Integer(8));
        propToFilter.put("keys", new Integer(16));
    }

    private final class DBElementListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Integer n = (Integer)propToFilter.get(propertyChangeEvent.getPropertyName());
            if (n != null) {
                SchemaChildren.this.refreshKeys(n);
            }
        }
    }
}

