/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.netbeans.modules.groovy.support.options.SupportOptionsPanelController;
import org.netbeans.modules.groovy.support.spi.GroovyOptionsSubpanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SupportPanel
extends JPanel {
    private final SupportOptionsPanelController controller;
    private final Collection<GroovyOptionsSubpanel> subpanels;
    private JButton chooseDocButton;
    private JLabel docLabel;
    private JTextField groovyDocTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel linkLabel;
    private JPanel subpanelWrapper;

    SupportPanel(SupportOptionsPanelController supportOptionsPanelController, @NonNull Collection<? extends GroovyOptionsSubpanel> collection) {
        this.controller = supportOptionsPanelController;
        this.subpanels = new ArrayList<GroovyOptionsSubpanel>(collection);
        this.initComponents();
        int n = 1;
        for (GroovyOptionsSubpanel groovyOptionsSubpanel : this.subpanels) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 8, 0);
            this.subpanelWrapper.add(groovyOptionsSubpanel.getComponent(), gridBagConstraints);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.subpanelWrapper.add((Component)new JLabel(), gridBagConstraints);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.linkLabel = new JLabel();
        this.docLabel = new JLabel();
        this.groovyDocTextField = new JTextField();
        this.chooseDocButton = new JButton();
        this.subpanelWrapper = new JPanel();
        this.jLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.linkLabel, (String)"<html><a href=\"http://groovy.codehaus.org\">http://groovy.codehaus.org</a></html>");
        this.linkLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SupportPanel.this.linkLabelMousePressed(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                SupportPanel.this.linkLabelMouseExited(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                SupportPanel.this.linkLabelMouseEntered(mouseEvent);
            }
        });
        this.docLabel.setLabelFor(this.groovyDocTextField);
        Mnemonics.setLocalizedText((JLabel)this.docLabel, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.docLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chooseDocButton, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseDocButton.text"));
        this.chooseDocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SupportPanel.this.chooseDocButtonActionPerformed(actionEvent);
            }
        });
        this.subpanelWrapper.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.jLabel1.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.linkLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addContainerGap()).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.groovyDocTextField, -1, 450, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.chooseDocButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.docLabel).addContainerGap()).add((Component)this.subpanelWrapper, -1, 545, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2, -2, 16, -2).add((Component)this.linkLabel)).addPreferredGap(0).add((Component)this.jLabel1).add(18, 18, 18).add((Component)this.docLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.chooseDocButton).add((Component)this.groovyDocTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.subpanelWrapper, -1, 69, Short.MAX_VALUE)));
        this.groovyDocTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.groovyDocTextField.accessibleName"));
        this.groovyDocTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.groovyDocTextField.accessibleDescription"));
        this.chooseDocButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseDocButton.accessibleName"));
        this.chooseDocButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseDocButton.accessibleDescription"));
    }

    private void linkLabelMousePressed(MouseEvent mouseEvent) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://groovy.codehaus.org"));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
    }

    private void linkLabelMouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void linkLabelMouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void chooseDocButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.groovyDocTextField.getText());
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(SupportPanel.class, (String)"LBL_Select_Directory"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!new File(new File(file, "groovy-jdk"), "index.html").isFile()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SupportPanel.class, (String)"LBL_Not_groovy_doc"), 2));
                return;
            }
            this.groovyDocTextField.setText(file.getAbsolutePath());
        }
    }

    void load() {
        GroovySettings groovySettings = GroovySettings.getInstance();
        String string = groovySettings.getGroovyDoc();
        if (string == null) {
            string = "";
        }
        this.groovyDocTextField.setText(string);
        for (GroovyOptionsSubpanel groovyOptionsSubpanel : this.subpanels) {
            groovyOptionsSubpanel.load();
        }
    }

    void store() {
        GroovySettings groovySettings = GroovySettings.getInstance();
        groovySettings.setGroovyDoc(this.groovyDocTextField.getText().trim());
        for (GroovyOptionsSubpanel groovyOptionsSubpanel : this.subpanels) {
            groovyOptionsSubpanel.store();
        }
    }

    boolean valid() {
        String string = this.groovyDocTextField.getText().trim();
        if ("".equals(string)) {
            return false;
        }
        for (GroovyOptionsSubpanel groovyOptionsSubpanel : this.subpanels) {
            if (groovyOptionsSubpanel.valid()) continue;
            return false;
        }
        return true;
    }
}

