/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class J2SESources
implements Sources,
PropertyChangeListener,
ChangeListener {
    private static final String BUILD_DIR_PROP = "${build.dir}";
    private static final String DIST_DIR_PROP = "${dist.dir}";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private boolean dirty;
    private final Map<String, SourceGroup[]> cachedGroups = new ConcurrentHashMap<String, SourceGroup[]>();
    private long eventId;
    private Sources delegate;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private SourceGroupModifierImplementation sgmi;
    private final FireAction fireTask = new FireAction();

    J2SESources(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.project = project;
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = sourceRoots2;
        this.sourceRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.testRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.delegate = this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String string) {
        SourceGroup[] sourceGroupArray = this.cachedGroups.get(string);
        if (sourceGroupArray != null) {
            return sourceGroupArray;
        }
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceGroup[] run() {
                SourceGroup[] sourceGroupArray = J2SESources.this;
                synchronized (J2SESources.this) {
                    Object object;
                    if (J2SESources.this.dirty) {
                        J2SESources.this.delegate.removeChangeListener((ChangeListener)J2SESources.this);
                        J2SESources.this.delegate = J2SESources.this.initSources();
                        J2SESources.this.delegate.addChangeListener((ChangeListener)J2SESources.this);
                        J2SESources.this.dirty = false;
                    }
                    Sources sources = J2SESources.this.delegate;
                    long l = ++J2SESources.this.eventId;
                    // ** MonitorExit[var4_1] (shouldn't be in output)
                    sourceGroupArray = sources.getSourceGroups(string);
                    if (string.equals("generic") && (object = J2SESources.this.getSharedLibraryFolderLocation()) != null) {
                        SourceGroup[] sourceGroupArray2 = new SourceGroup[sourceGroupArray.length + 1];
                        System.arraycopy(sourceGroupArray, 0, sourceGroupArray2, 0, sourceGroupArray.length);
                        sourceGroupArray2[sourceGroupArray2.length - 1] = GenericSources.group(null, (FileObject)object, (String)"sharedlibraries", (String)NbBundle.getMessage(J2SESources.class, (String)"LibrarySourceGroup_DisplayName"), null, null);
                        sourceGroupArray = sourceGroupArray2;
                    }
                    object = J2SESources.this;
                    synchronized (object) {
                        if (l == J2SESources.this.eventId) {
                            J2SESources.this.cachedGroups.put(string, sourceGroupArray);
                        }
                    }
                    return sourceGroupArray;
                }
            }
        });
    }

    private FileObject getSharedLibraryFolderLocation() {
        String string = this.helper.getLibrariesLocation();
        if (string != null) {
            FileObject fileObject;
            String string2 = this.evaluator.evaluate(string);
            File file = null;
            if (string2 != null) {
                file = this.helper.resolveFile(string2);
            }
            if ((fileObject = FileUtil.toFileObject(file)) != null) {
                FileObject fileObject2 = fileObject.getParent();
                return fileObject2;
            }
        }
        return null;
    }

    SourceGroupModifierImplementation getSourceGroupModifierImplementation() {
        return this.sgmi;
    }

    private Sources initSources() {
        SourcesHelper sourcesHelper = new SourcesHelper(this.project, this.helper, this.evaluator);
        this.register(sourcesHelper, this.sourceRoots, "main");
        this.register(sourcesHelper, this.testRoots, "test");
        sourcesHelper.addNonSourceRoot(BUILD_DIR_PROP);
        sourcesHelper.addNonSourceRoot(DIST_DIR_PROP);
        sourcesHelper.registerExternalRoots(0, false);
        this.sgmi = sourcesHelper.createSourceGroupModifierImplementation();
        return sourcesHelper.createSources();
    }

    private void register(SourcesHelper sourcesHelper, SourceRoots sourceRoots, String string) {
        String[] stringArray = sourceRoots.getRootProperties();
        String[] stringArray2 = sourceRoots.getRootNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = sourceRoots.getRootDisplayName(stringArray2[i], string2);
            String string4 = "${" + string2 + "}";
            String string5 = "${includes}";
            String string6 = "${excludes}";
            sourcesHelper.sourceRoot(string4).includes(string5).excludes(string6).hint(string).displayName(string3).add().type("java").add();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        J2SESources j2SESources = this;
        synchronized (j2SESources) {
            this.cachedGroups.clear();
            this.dirty = true;
        }
        ProjectManager.mutex().postReadRequest((Runnable)this.fireTask.activate());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (SourceRoots.PROP_ROOTS.equals(string) || "build.dir".equals(string) || "dist.dir".equals(string)) {
            this.fireChange();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }

    private class FireAction
    implements Runnable {
        private AtomicBoolean fire = new AtomicBoolean();

        private FireAction() {
        }

        public void run() {
            if (this.fire.getAndSet(false)) {
                J2SESources.this.changeSupport.fireChange();
            }
        }

        FireAction activate() {
            this.fire.set(true);
            return this;
        }
    }
}

