/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.AbbrevsMIMEProcessor;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.FontsColorsMIMEProcessor;
import org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor;
import org.netbeans.modules.editor.options.MIMEProcessor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileSystem;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class MIMEOptionFile {
    private static final Logger LOG = Logger.getLogger(MIMEOptionFile.class.getName());
    protected BaseOptions base;
    protected MIMEProcessor processor;
    protected Document dom;
    protected Map properties;
    private boolean loaded = false;
    private boolean wasSaved = false;
    private ModuleInfo editorMI;
    private final FileChangeListener fileListener = new FileChangeAdapter(){

        public void fileChanged(FileEvent fileEvent) {
            if (!(MIMEOptionFile.this.processor instanceof AbbrevsMIMEProcessor || MIMEOptionFile.this.processor instanceof FontsColorsMIMEProcessor || MIMEOptionFile.this.processor instanceof KeyBindingsMIMEProcessor)) {
                MIMEOptionFile.this.reloadSettings();
            }
        }
    };
    private final PropertyChangeListener moduleListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"enabled".endsWith(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (!(propertyChangeEvent.getSource() instanceof ModuleInfo)) {
                return;
            }
            if ((ModuleInfo)propertyChangeEvent.getSource() != null && !((ModuleInfo)propertyChangeEvent.getSource()).isEnabled()) {
                MIMEOptionFile.this.editorUninstalled();
            }
        }
    };
    private final ErrorCatcher ERROR_CATCHER = new ErrorCatcher();

    public MIMEOptionFile(BaseOptions baseOptions, Object object) {
        this.base = baseOptions;
        this.processor = (MIMEProcessor)object;
        try {
            this.properties = new HashMap();
            this.dom = this.processor.getXMLDataObject().getDocument();
            this.processor.getXMLDataObject().getPrimaryFile().addFileChangeListener(this.fileListener);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addEditorModuleListener();
    }

    private void addEditorModuleListener() {
        Lookup.Template template = new Lookup.Template(ModuleInfo.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection collection = result.allInstances();
        for (ModuleInfo moduleInfo : collection) {
            if (!"org.netbeans.modules.editor".equals(moduleInfo.getCodeNameBase())) continue;
            moduleInfo.addPropertyChangeListener(this.moduleListener);
            this.editorMI = moduleInfo;
            break;
        }
    }

    private void editorUninstalled() {
        this.processor.getXMLDataObject().getPrimaryFile().removeFileChangeListener(this.fileListener);
        try {
            this.processor.getXMLDataObject().setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            LOG.log(Level.INFO, null, propertyVetoException);
        }
        this.editorMI.removePropertyChangeListener(this.moduleListener);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSettings() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (this.wasSaved) {
                this.wasSaved = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Document document = this.dom;
            this.setLoaded(false);
            try {
                String string = this.processor.getXMLDataObject().getPrimaryFile().getURL().toExternalForm();
                this.dom = XMLUtil.parse((InputSource)new InputSource(string), (boolean)true, (boolean)false, (ErrorHandler)this.ERROR_CATCHER, (EntityResolver)EntityCatalog.getDefault());
                this.loadSettings();
            }
            catch (SAXException sAXException) {
                this.dom = document;
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                this.dom = document;
                iOException.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveSettings(Document document) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            try {
                FileLock fileLock = this.processor.getXMLDataObject().getPrimaryFile().lock();
                try {
                    OutputStream outputStream = this.processor.getXMLDataObject().getPrimaryFile().getOutputStream(fileLock);
                    try {
                        this.wasSaved = true;
                        XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
                        outputStream.flush();
                    }
                    catch (IOException iOException) {
                        this.wasSaved = false;
                        LOG.log(Level.WARNING, null, iOException);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract void loadSettings(boolean var1);

    protected void loadSettings() {
        this.loadSettings(true);
    }

    protected abstract void updateSettings(Map var1);

    public Map getAllProperties() {
        if (!this.isLoaded()) {
            this.loadSettings(false);
        }
        return this.properties;
    }

    final void setAllProperties(final Map map) {
        try {
            FileSystem fileSystem = this.processor.getXMLDataObject().getPrimaryFile().getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    MIMEOptionFile.this.updateSettings(map);
                }
            });
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Can't save settings by " + this.processor, iOException);
        }
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            System.err.println("Error level:" + string);
            System.err.println("Line number:" + sAXParseException.getLineNumber());
            System.err.println("Column number:" + sAXParseException.getColumnNumber());
            System.err.println("Public ID:" + sAXParseException.getPublicId());
            System.err.println("System ID:" + sAXParseException.getSystemId());
            System.err.println("Error message:" + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            this.message("ERROR", sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) {
            this.message("WARNING", sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) {
            this.message("FATAL", sAXParseException);
        }
    }
}

