/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.exceptions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.exceptions.ExceptionsSettings;
import org.netbeans.modules.uihandler.Installer;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ReporterResultTopComponent
extends TopComponent
implements HyperlinkListener {
    private static ReporterResultTopComponent instance;
    private static final Logger LOG;
    private static boolean showUpload;
    private static final String ICON_PATH = "org/netbeans/modules/exceptions/reporter.png";
    private static final String PREFERRED_ID = "ReporterResultTopComponent";
    private JEditorPane dataDisplayer;
    private JButton jButton1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    private ReporterResultTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"CTL_ReporterResultTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"HINT_ReporterResultTopComponent"));
        this.dataDisplayer.addHyperlinkListener(this);
        this.dataDisplayer.setContentType("text/html");
        Image image = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
        this.setIcon(image);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.dataDisplayer = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.dataDisplayer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.dataDisplayer.setEditable(false);
        this.jScrollPane1.setViewportView(this.dataDisplayer);
        this.add(this.jScrollPane1, "Center");
        this.jPanel1.setPreferredSize(new Dimension(320, 35));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ReporterResultTopComponent.class, (String)"ReporterResultTopComponent.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReporterResultTopComponent.this.jButton1ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jButton1).addContainerGap(208, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jButton1, -1, 29, Short.MAX_VALUE).addContainerGap()));
        this.add(this.jPanel1, "First");
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.showMyIssues(true);
    }

    public static synchronized ReporterResultTopComponent getDefault() {
        if (instance == null) {
            instance = new ReporterResultTopComponent();
        }
        return instance;
    }

    public static synchronized ReporterResultTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(ReporterResultTopComponent.class.getName()).warning("Cannot find ReporterResultTopComponent component. It will not be located properly in the window system.");
            return ReporterResultTopComponent.getDefault();
        }
        if (topComponent instanceof ReporterResultTopComponent) {
            return (ReporterResultTopComponent)topComponent;
        }
        Logger.getLogger(ReporterResultTopComponent.class.getName()).warning("There seem to be multiple components with the 'ReporterResultTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ReporterResultTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        if (showUpload) {
            return;
        }
        this.showMyIssues(false);
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public static void showUploadDone(final URL uRL) {
        if (EventQueue.isDispatchThread()) {
            try {
                ReporterResultTopComponent.findInstance().showUploadDoneImpl(uRL);
            }
            catch (IOException iOException) {
                ReporterResultTopComponent.handleIOException(uRL, iOException);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        ReporterResultTopComponent.findInstance().showUploadDoneImpl(uRL);
                    }
                    catch (IOException iOException) {
                        ReporterResultTopComponent.handleIOException(uRL, iOException);
                    }
                }
            });
        }
    }

    private void showUploadDoneImpl(URL uRL) throws IOException {
        assert (EventQueue.isDispatchThread());
        showUpload = true;
        this.open();
        showUpload = false;
        this.loadPage(uRL, true);
    }

    private void showMyIssues(boolean bl) {
        String string = null;
        String string2 = new ExceptionsSettings().getUserName();
        if (string2 != null && !"".equals(string2)) {
            string = NbBundle.getMessage(ReporterResultTopComponent.class, (String)"userNameURL") + string2;
        } else {
            String string3 = Installer.findIdentity();
            if (string3 != null) {
                string = NbBundle.getMessage(ReporterResultTopComponent.class, (String)"userIdURL") + string3;
            }
        }
        if (string == null) {
            return;
        }
        try {
            this.loadPage(new URL(string), bl);
        }
        catch (MalformedURLException malformedURLException) {
            ReporterResultTopComponent.handleIOException(string, (IOException)malformedURLException);
        }
    }

    private void loadPage(URL uRL, boolean bl) {
        assert (EventQueue.isDispatchThread());
        try {
            this.dataDisplayer.setPage(ReporterResultTopComponent.getLoadingPageURL(uRL));
        }
        catch (IOException iOException) {
            ReporterResultTopComponent.handleIOException(uRL, iOException);
        }
        RequestProcessor.getDefault().post((Runnable)new PageUploader(uRL, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL uploadURL(URL uRL) throws IOException {
        assert (!EventQueue.isDispatchThread());
        File file = File.createTempFile("loading", ".html");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setReadTimeout(200000);
            uRLConnection.setDoOutput(false);
            uRLConnection.setDoInput(true);
            uRLConnection.setRequestProperty("User-Agent", "NetBeans");
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            fileOutputStream.close();
        }
        return file.toURI().toURL();
    }

    private static void handleIOException(URL uRL, IOException iOException) {
        ReporterResultTopComponent.handleIOException(uRL.toString(), iOException);
    }

    private static void handleIOException(final String string, IOException iOException) {
        LOG.log(Level.INFO, "URL Loading failed", iOException);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                instance.dataDisplayer.setText(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"no_data_found", (Object)string));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL getLoadingPageURL(URL uRL) throws IOException {
        File file = File.createTempFile("loading", ".html");
        file.deleteOnExit();
        FileWriter fileWriter = new FileWriter(file);
        try {
            fileWriter.write("<html><head><title></title></head><body>");
            fileWriter.write(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"LoadingMessage"));
            fileWriter.write("<a href=\"" + uRL.toString() + "\">" + uRL + "</a>");
            fileWriter.write("</body></html>");
        }
        finally {
            fileWriter.close();
        }
        return file.toURI().toURL();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(hyperlinkEvent.getURL());
        }
    }

    static {
        LOG = Logger.getLogger(ReporterResultTopComponent.class.getName());
        showUpload = false;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ReporterResultTopComponent.getDefault();
        }
    }

    private class PageUploader
    implements Runnable {
        private URL localData = null;
        private final URL url;
        private final boolean show;

        private PageUploader(URL uRL, boolean bl) {
            this.url = uRL;
            this.show = bl;
        }

        public void run() {
            try {
                if (EventQueue.isDispatchThread()) {
                    if (this.show) {
                        ReporterResultTopComponent.this.requestVisible();
                    }
                    ReporterResultTopComponent.this.dataDisplayer.setPage(this.localData);
                } else {
                    LOG.fine("Loading: " + this.url);
                    this.localData = ReporterResultTopComponent.uploadURL(this.url);
                    EventQueue.invokeLater(this);
                }
            }
            catch (IOException iOException) {
                ReporterResultTopComponent.handleIOException(this.url, iOException);
            }
        }
    }
}

