/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.dom;

import java.lang.ref.WeakReference;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.text.dom.XMLSyntaxSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyntaxElement {
    protected XMLSyntaxSupport support;
    private WeakReference<Token> first;
    private WeakReference<SyntaxElement> previous;
    private WeakReference<SyntaxElement> next;
    protected int offset;
    protected int length;

    SyntaxElement(XMLSyntaxSupport xMLSyntaxSupport, Token<XMLTokenId> token, int n, int n2) {
        this.support = xMLSyntaxSupport;
        this.offset = n;
        this.length = n2 - n;
        this.first = new WeakReference<Token<XMLTokenId>>(token);
    }

    protected Token first() {
        Token token = (Token)this.first.get();
        if (token != null) {
            return token;
        }
        try {
            Token token2 = this.support.getNextToken(this.offset);
            this.first = new WeakReference<Token>(token2);
            return token2;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    void setNext(SyntaxElement syntaxElement) {
        this.next = new WeakReference<SyntaxElement>(syntaxElement);
    }

    void setPrevious(SyntaxElement syntaxElement) {
        this.previous = new WeakReference<SyntaxElement>(syntaxElement);
    }

    public SyntaxElement getPrevious() {
        SyntaxElement syntaxElement;
        SyntaxElement syntaxElement2 = syntaxElement = this.previous == null ? null : (SyntaxElement)this.previous.get();
        if (syntaxElement != null) {
            return syntaxElement;
        }
        try {
            if (this.offset == 0) {
                return null;
            }
            SyntaxElement syntaxElement3 = this.support.getElementChain(this.getElementOffset() - 1);
            if (syntaxElement3 != null) {
                this.setPrevious(syntaxElement3);
                syntaxElement3.setNext(this);
                if (syntaxElement3.offset == this.offset) {
                    return null;
                }
            }
            return syntaxElement3;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public SyntaxElement getNext() {
        SyntaxElement syntaxElement;
        SyntaxElement syntaxElement2 = syntaxElement = this.next == null ? null : (SyntaxElement)this.next.get();
        if (syntaxElement != null) {
            return syntaxElement;
        }
        try {
            SyntaxElement syntaxElement3 = this.support.getElementChain(this.offset + this.length);
            if (syntaxElement3 != null) {
                this.setNext(syntaxElement3);
                syntaxElement3.setPrevious(this);
                if (syntaxElement3.offset == this.offset) {
                    return null;
                }
            }
            return syntaxElement3;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String toString() {
        String string = "?";
        return "SyntaxElement [offset=" + this.offset + "; length=" + this.length + " ;type = " + this.getClass().getName() + "; content:" + string + "]";
    }

    public int hashCode() {
        return super.hashCode() ^ this.offset ^ this.length;
    }

    public boolean equals(Object object) {
        return object instanceof SyntaxElement && ((SyntaxElement)object).offset == this.offset;
    }

    public static class Error
    extends SyntaxElement {
        public Error(XMLSyntaxSupport xMLSyntaxSupport, Token token, int n, int n2) {
            super(xMLSyntaxSupport, (Token<XMLTokenId>)token, n, n2);
        }

        public String toString() {
            return "Error" + super.toString();
        }
    }
}

