/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine.command;

import java.io.File;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateCommand;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateInformation;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateLine;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.commandLine.ListenerProvider;
import org.netbeans.lib.cvsclient.commandLine.command.CommandProvider;
import org.netbeans.lib.cvsclient.event.CVSAdapter;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;

public class locbundlecheck
extends CVSAdapter
implements CommandProvider {
    private PrintStream out;
    private PrintStream err;
    private int realEnd = 0;
    private HashMap originalBundles;
    private HashMap localizedBundles;
    private String local;
    private String workDir;

    public locbundlecheck() {
    }

    public String getName() {
        return "locbundlecheck";
    }

    public String[] getSynonyms() {
        return new String[]{"lbch", "lbcheck"};
    }

    public String getUsage() {
        return ResourceBundle.getBundle(CommandProvider.class.getPackage().getName() + ".Bundle").getString("locbundlecheck.usage");
    }

    public void printShortDescription(PrintStream printStream) {
        String string = ResourceBundle.getBundle(CommandProvider.class.getPackage().getName() + ".Bundle").getString("locbundlecheck.shortDescription");
        printStream.print(string);
    }

    public void printLongDescription(PrintStream printStream) {
        String string = ResourceBundle.getBundle(CommandProvider.class.getPackage().getName() + ".Bundle").getString("locbundlecheck.longDescription");
        printStream.println(string);
    }

    public Command createCommand(String[] stringArray, int n, GlobalOptions globalOptions, String string) {
        int n2;
        LocBundleAnnotateCommand locBundleAnnotateCommand = new LocBundleAnnotateCommand();
        String string2 = locBundleAnnotateCommand.getOptString();
        GetOpt getOpt = new GetOpt(stringArray, string2 + "i:");
        int n3 = -1;
        getOpt.optIndexSet(n);
        boolean bl = false;
        String string3 = null;
        while (true) {
            n3 = getOpt.getopt();
            if (n3 == -1) break;
            if (n3 == 105) {
                string3 = getOpt.optArgGet();
                locBundleAnnotateCommand.setLocalization(string3);
                continue;
            }
            n2 = locBundleAnnotateCommand.setCVSCommand((char)n3, getOpt.optArgGet()) ? 1 : 0;
            if (n2 != 0) continue;
            bl = true;
        }
        if (bl || string3 == null) {
            throw new IllegalArgumentException(this.getUsage());
        }
        n2 = getOpt.optIndexGet();
        if (n2 < stringArray.length) {
            ArrayList arrayList = new ArrayList();
            if (string == null) {
                string = System.getProperty("user.dir");
            }
            locBundleAnnotateCommand.setWorkDir(string);
            File file = new File(string);
            for (int i = n2; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2.exists() && file2.isDirectory()) {
                    locbundlecheck.addFilesInDir(arrayList, file2, string3);
                    continue;
                }
                if (file2.exists() && file2.getName().endsWith(".properties")) {
                    locbundlecheck.addFiles(arrayList, file2, string3);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if (arrayList.size() > 0) {
                File[] fileArray = new File[arrayList.size()];
                fileArray = arrayList.toArray(fileArray);
                locBundleAnnotateCommand.setFiles(fileArray);
            } else {
                throw new IllegalArgumentException(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.no_file_spec"));
            }
        }
        return locBundleAnnotateCommand;
    }

    private static void addFiles(Collection collection, File file, String string) {
        String string2 = file.getAbsolutePath();
        String string3 = string2.substring(0, string2.length() - ".properties".length()) + "_" + string + ".properties";
        File file2 = new File(string3);
        collection.add(file);
        if (file2.exists()) {
            collection.add(file2);
        }
    }

    private static void addFilesInDir(Collection collection, File file, String string) {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].exists() && fileArray[i].isDirectory()) {
                    locbundlecheck.addFilesInDir(collection, fileArray[i], string);
                    continue;
                }
                if (!fileArray[i].exists() || !"Bundle.properties".equals(fileArray[i].getName())) continue;
                locbundlecheck.addFiles(collection, fileArray[i], string);
            }
        }
    }

    locbundlecheck(PrintStream printStream, PrintStream printStream2, String string, String string2) {
        this.out = printStream;
        this.err = printStream2;
        this.originalBundles = new HashMap();
        this.localizedBundles = new HashMap();
        this.local = string;
        this.workDir = string2;
    }

    public void fileInfoGenerated(FileInfoEvent fileInfoEvent) {
        FileInfoContainer fileInfoContainer = fileInfoEvent.getInfoContainer();
        if (fileInfoContainer.getFile().getName().indexOf("_" + this.local) >= 0) {
            this.localizedBundles.put(fileInfoContainer.getFile().getAbsolutePath(), fileInfoContainer);
        } else {
            this.originalBundles.put(fileInfoContainer.getFile().getAbsolutePath(), fileInfoContainer);
        }
        if (this.realEnd == 2) {
            this.generateOutput();
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.realEnd == 0) {
            this.realEnd = 1;
            return;
        }
        this.realEnd = 2;
    }

    private void generateOutput() {
        Object object;
        Iterator iterator = this.originalBundles.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            int n = ((String)object).lastIndexOf(".");
            if (n < 0) {
                throw new IllegalStateException(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.illegal_state"));
            }
            String string = ((String)object).substring(0, n) + "_" + this.local + ((String)object).substring(n);
            AnnotateInformation annotateInformation = (AnnotateInformation)this.originalBundles.get(object);
            AnnotateInformation annotateInformation2 = (AnnotateInformation)this.localizedBundles.get(string);
            if (annotateInformation2 == null) {
                this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.noLocalizedFile"), object));
                continue;
            }
            this.localizedBundles.remove(string);
            HashMap hashMap = this.createPropMap(annotateInformation);
            HashMap hashMap2 = this.createPropMap(annotateInformation2);
            Object object2 = object;
            if (((String)object).startsWith(this.workDir) && (((String)(object2 = ((String)object).substring(this.workDir.length()))).startsWith("/") || ((String)object2).startsWith("\\"))) {
                object2 = ((String)object2).substring(1);
            }
            this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.File"), object2));
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                AnnotateLine annotateLine = (AnnotateLine)hashMap.get(string2);
                AnnotateLine annotateLine2 = (AnnotateLine)hashMap2.get(string2);
                if (annotateLine2 == null) {
                    this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.propMissing"), string2));
                    continue;
                }
                if (annotateLine.getDate().compareTo(annotateLine2.getDate()) <= 0) continue;
                this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.prop_updated"), string2));
            }
        }
        if (this.localizedBundles.size() > 0) {
            object = this.localizedBundles.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.prop_removed"), string));
            }
        }
    }

    private HashMap createPropMap(AnnotateInformation annotateInformation) {
        HashMap<String, AnnotateLine> hashMap = new HashMap<String, AnnotateLine>();
        AnnotateLine annotateLine = annotateInformation.getFirstLine();
        while (annotateLine != null) {
            String string = annotateLine.getContent();
            if (string.startsWith("#")) {
                annotateLine = annotateInformation.getNextLine();
                continue;
            }
            int n = string.indexOf(61);
            if (n > 0) {
                String string2 = string.substring(0, n);
                hashMap.put(string2, annotateLine);
            }
            annotateLine = annotateInformation.getNextLine();
        }
        return hashMap;
    }

    private static class LocBundleAnnotateCommand
    extends AnnotateCommand
    implements ListenerProvider {
        private String loc;
        private String workDir;

        private LocBundleAnnotateCommand() {
        }

        public CVSListener createCVSListener(PrintStream printStream, PrintStream printStream2) {
            return new locbundlecheck(printStream, printStream2, this.loc, this.workDir);
        }

        public void setLocalization(String string) {
            this.loc = string;
        }

        public void setWorkDir(String string) {
            this.workDir = string;
        }
    }
}

