/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.util.BugLog;

public class LogInformation
extends FileInfoContainer {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private File file;
    private String repositoryFilename;
    private String headRevision;
    private String branch;
    private String accessList;
    private String keywordSubstitution;
    private String totalRevisions;
    private String selectedRevisions;
    private String description;
    private String locks;
    private final List revisions = new ArrayList();
    private final List symbolicNames = new ArrayList();

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getRepositoryFilename() {
        return this.repositoryFilename;
    }

    public void setRepositoryFilename(String string) {
        this.repositoryFilename = string;
    }

    public String getHeadRevision() {
        return this.headRevision;
    }

    public void setHeadRevision(String string) {
        this.headRevision = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public String getAccessList() {
        return this.accessList;
    }

    public void setAccessList(String string) {
        this.accessList = string;
    }

    public String getKeywordSubstitution() {
        return this.keywordSubstitution;
    }

    public void setKeywordSubstitution(String string) {
        this.keywordSubstitution = string;
    }

    public String getTotalRevisions() {
        return this.totalRevisions;
    }

    public void setTotalRevisions(String string) {
        this.totalRevisions = string;
    }

    public String getSelectedRevisions() {
        return this.selectedRevisions;
    }

    public void setSelectedRevisions(String string) {
        this.selectedRevisions = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getLocks() {
        return this.locks;
    }

    public void setLocks(String string) {
        this.locks = string;
    }

    public void addRevision(Revision revision) {
        this.revisions.add(revision);
    }

    public List getRevisionList() {
        return this.revisions;
    }

    public Revision getRevision(String string) {
        Iterator iterator = this.revisions.iterator();
        while (iterator.hasNext()) {
            Revision revision = (Revision)iterator.next();
            if (!revision.getNumber().equals(string)) continue;
            return revision;
        }
        return null;
    }

    public void addSymbolicName(String string, String string2) {
        SymName symName = new SymName();
        symName.setName(string);
        symName.setRevision(string2);
        this.symbolicNames.add(symName);
    }

    public List getAllSymbolicNames() {
        return this.symbolicNames;
    }

    public List getSymNamesForRevision(String string) {
        Iterator iterator = this.symbolicNames.iterator();
        LinkedList<SymName> linkedList = new LinkedList<SymName>();
        while (iterator.hasNext()) {
            SymName symName = (SymName)iterator.next();
            if (!symName.getRevision().equals(string)) continue;
            linkedList.add(symName);
        }
        return linkedList;
    }

    public SymName getSymName(String string) {
        Iterator iterator = this.symbolicNames.iterator();
        while (iterator.hasNext()) {
            SymName symName = (SymName)iterator.next();
            if (!symName.getName().equals(string)) continue;
            return symName;
        }
        return null;
    }

    public Revision createNewRevision(String string) {
        Revision revision = new Revision();
        revision.setNumber(string);
        return revision;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("\nFile: " + (this.file != null ? this.file.getAbsolutePath() : "null"));
        stringBuffer.append("\nRepositoryFile: " + this.repositoryFilename);
        stringBuffer.append("\nHead revision: " + this.headRevision);
        return stringBuffer.toString();
    }

    public class Revision {
        private String number;
        private Date date;
        private String dateString;
        private String author;
        private String state;
        private String lines;
        private String commitID;
        private String message;
        private String branches;

        public LogInformation getLogInfoHeader() {
            return LogInformation.this;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String string) {
            this.number = string;
        }

        public Date getDate() {
            return this.date;
        }

        public String getDateString() {
            return this.dateString;
        }

        public void setDateString(String string) {
            this.dateString = string;
            if (string == null) {
                this.date = null;
                return;
            }
            try {
                string = string.replace('/', '-') + " +0000";
                this.date = DATE_FORMAT.parse(string);
            }
            catch (Exception exception) {
                BugLog.getInstance().bug("Couldn't parse date " + string);
            }
        }

        public void setDate(Date date, String string) {
            this.dateString = string;
            this.date = date;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String string) {
            this.author = string;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String string) {
            this.state = string;
        }

        public String getLines() {
            return this.lines;
        }

        public void setLines(String string) {
            this.lines = string;
        }

        public String getCommitID() {
            return this.commitID;
        }

        public void setCommitID(String string) {
            this.commitID = string;
        }

        public int getAddedLines() {
            if (this.lines != null) {
                int n = this.lines.indexOf(43);
                int n2 = this.lines.indexOf(32);
                if (n >= 0 && n2 > n) {
                    String string = this.lines.substring(n + 1, n2);
                    try {
                        int n3 = Integer.parseInt(string);
                        return n3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return 0;
        }

        public int getRemovedLines() {
            int n;
            if (this.lines != null && (n = this.lines.indexOf(45)) >= 0) {
                String string = this.lines.substring(n + 1);
                try {
                    int n2 = Integer.parseInt(string);
                    return n2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String string) {
            this.message = string;
        }

        public String getBranches() {
            return this.branches;
        }

        public void setBranches(String string) {
            this.branches = string;
        }
    }

    public class SymName {
        private String name;
        private String revision;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setRevision(String string) {
            this.revision = string;
        }

        public String getRevision() {
            return this.revision;
        }

        public final boolean isBranch() {
            boolean bl = false;
            String[] stringArray = this.revision.split("\\.");
            if (stringArray.length > 2 && stringArray.length % 2 == 0) {
                String string = stringArray[stringArray.length - 2];
                bl = "0".equals(string);
            }
            return bl;
        }
    }
}

