/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;

public class WrapperUtils {
    private static void parseWrappers(BufferedReader bufferedReader, Map map) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            SimpleStringPattern simpleStringPattern = new SimpleStringPattern(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (!string2.equals("-k")) continue;
                int n = string3.indexOf(39);
                int n2 = string3.lastIndexOf(39);
                if (n >= 0 && n2 >= 0) {
                    string3 = string3.substring(n + 1, n2);
                }
                KeywordSubstitutionOptions keywordSubstitutionOptions = KeywordSubstitutionOptions.findKeywordSubstOption(string3);
                if (map.containsKey(simpleStringPattern)) continue;
                map.put(simpleStringPattern, keywordSubstitutionOptions);
            }
        }
    }

    public static void readWrappersFromFile(File file, Map map) throws IOException, FileNotFoundException {
        WrapperUtils.parseWrappers(new BufferedReader(new FileReader(file)), map);
    }

    private static void readWrappersFromProperty(String string, Map map) throws IOException {
        String string2 = System.getenv(string);
        if (string2 != null) {
            WrapperUtils.parseWrappers(new BufferedReader(new StringReader(string2)), map);
        }
        if ((string2 = System.getProperty("Env-CVSWRAPPERS")) != null) {
            WrapperUtils.parseWrappers(new BufferedReader(new StringReader(string2)), map);
        }
    }

    public static Map mergeWrapperMap(ClientServices clientServices) throws CommandException {
        String string = null;
        HashMap hashMap = new HashMap(clientServices.getWrappersMap());
        try {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, "./cvswrappers");
            string = CommandException.getLocalMessage("WrapperUtils.clientDotWrapper.text");
            if (file2.exists()) {
                WrapperUtils.readWrappersFromFile(file2, hashMap);
            }
            string = CommandException.getLocalMessage("WrapperUtils.environmentWrapper.text");
            WrapperUtils.readWrappersFromProperty("CVSWRAPPERS", hashMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string};
            String string2 = CommandException.getLocalMessage("WrapperUtils.wrapperError.text", objectArray);
            throw new CommandException(exception, string2);
        }
        return hashMap;
    }
}

