/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.BinaryBuilder;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.PipedFileInformation;
import org.netbeans.lib.cvsclient.command.TemporaryFileCreator;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class PipedFilesBuilder
implements Builder,
BinaryBuilder {
    private static final String ERR_START = "=======";
    private static final String ERR_CHECK = "Checking out ";
    private static final String ERR_RCS = "RCS:  ";
    private static final String ERR_VERS = "VERS: ";
    private static final String EXAM_DIR = ": Updating";
    private static final byte[] lineSeparator = System.getProperty("line.separator").getBytes();
    private PipedFileInformation fileInformation;
    private EventManager eventManager;
    private String fileDirectory;
    private BuildableCommand command;
    private TemporaryFileCreator tempFileCreator;

    public PipedFilesBuilder(EventManager eventManager, BuildableCommand buildableCommand, TemporaryFileCreator temporaryFileCreator) {
        this.eventManager = eventManager;
        this.command = buildableCommand;
        this.tempFileCreator = temporaryFileCreator;
    }

    public void outputDone() {
        if (this.fileInformation == null) {
            return;
        }
        try {
            this.fileInformation.closeTempFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.fileInformation));
        this.fileInformation = null;
    }

    public void parseBytes(byte[] byArray, int n) {
        if (this.fileInformation == null) {
            try {
                this.fileInformation = new PipedFileInformation(File.createTempFile("checkout", null));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            this.fileInformation.addToTempFile(byArray, n);
        }
        catch (IOException iOException) {
            this.outputDone();
        }
    }

    public void parseLine(String string, boolean bl) {
        if (bl) {
            if (string.indexOf(EXAM_DIR) >= 0) {
                this.fileDirectory = string.substring(string.indexOf(EXAM_DIR) + EXAM_DIR.length()).trim();
            } else if (string.startsWith(ERR_CHECK)) {
                this.processFile(string);
            } else if (string.startsWith(ERR_RCS)) {
                if (this.fileInformation != null) {
                    String string2 = string.substring(ERR_RCS.length()).trim();
                    this.fileInformation.setRepositoryFileName(string2);
                }
            } else if (string.startsWith(ERR_VERS) && this.fileInformation != null) {
                String string3 = string.substring(ERR_RCS.length()).trim();
                this.fileInformation.setRepositoryRevision(string3);
            }
        } else {
            if (this.fileInformation == null) {
                try {
                    this.fileInformation = new PipedFileInformation(File.createTempFile("checkout", null));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (this.fileInformation != null) {
                try {
                    this.fileInformation.addToTempFile(string.getBytes("ISO-8859-1"));
                    this.fileInformation.addToTempFile(lineSeparator);
                }
                catch (IOException iOException) {
                    this.outputDone();
                }
            }
        }
    }

    private void processFile(String string) {
        this.outputDone();
        String string2 = string.substring(ERR_CHECK.length());
        try {
            File file = this.tempFileCreator.createTempFile(string2);
            this.fileInformation = new PipedFileInformation(file);
        }
        catch (IOException iOException) {
            this.fileInformation = null;
            return;
        }
        this.fileInformation.setFile(this.createFile(string2));
    }

    private File createFile(String string) {
        File file = new File(this.command.getLocalDirectory(), string);
        return file;
    }

    public void parseEnhancedMessage(String string, Object object) {
    }
}

