/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfNameLookupTable;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfNameLookupTableSection
extends ElfSection {
    ArrayList<DwarfNameLookupTable> tables = null;

    public DwarfNameLookupTableSection(DwarfReader dwarfReader, int n) {
        super(dwarfReader, n);
    }

    public ArrayList<DwarfNameLookupTable> getNameLookupTables() {
        if (this.tables == null) {
            try {
                this.tables = this.readNameLookupTables();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.tables;
    }

    private ArrayList<DwarfNameLookupTable> readNameLookupTables() throws IOException {
        ArrayList<DwarfNameLookupTable> arrayList = new ArrayList<DwarfNameLookupTable>();
        long l = this.reader.getFilePointer();
        this.reader.seek(this.header.getSectionOffset());
        DwarfDebugInfoSection dwarfDebugInfoSection = (DwarfDebugInfoSection)this.reader.getSection(".debug_info");
        long l2 = this.header.getSectionSize();
        while (l2 > 0L) {
            long l3;
            DwarfNameLookupTable dwarfNameLookupTable = new DwarfNameLookupTable();
            dwarfNameLookupTable.unit_length = this.reader.readDWlen();
            l2 -= dwarfNameLookupTable.unit_length + 4L;
            dwarfNameLookupTable.version = this.reader.readShort();
            dwarfNameLookupTable.debug_info_offset = this.reader.read3264();
            dwarfNameLookupTable.debug_info_length = this.reader.read3264();
            CompilationUnit compilationUnit = dwarfDebugInfoSection.getCompilationUnit(dwarfNameLookupTable.debug_info_offset);
            if (compilationUnit == null) continue;
            while ((l3 = this.reader.read3264()) != 0L) {
                dwarfNameLookupTable.addEntry(l3, this.reader.readString());
            }
            arrayList.add(dwarfNameLookupTable);
        }
        this.reader.seek(l);
        return arrayList;
    }

    @Override
    public void dump(PrintStream printStream) {
        super.dump(printStream);
        for (DwarfNameLookupTable dwarfNameLookupTable : this.tables) {
            dwarfNameLookupTable.dump(printStream);
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.dump(printStream);
        return byteArrayOutputStream.toString();
    }

    public DwarfNameLookupTable getNameLookupTableFor(long l) {
        for (DwarfNameLookupTable dwarfNameLookupTable : this.getNameLookupTables()) {
            if (dwarfNameLookupTable.debug_info_offset != l) continue;
            return dwarfNameLookupTable;
        }
        return null;
    }
}

