/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.modules.kenai.RestResponse;
import org.netbeans.modules.kenai.api.Kenai;
import sun.misc.BASE64Encoder;

public class RestConnection {
    public static final int TIMEOUT = 30000;
    private HttpsURLConnection conn;
    private String date;

    public RestConnection(String string) {
        this(string, null, null);
    }

    public RestConnection(String string, String[][] stringArray) {
        this(string, null, stringArray);
    }

    public RestConnection(String string, String[][] stringArray, String[][] stringArray2) {
        String string2 = System.getProperty("netbeans.t9y.kenai.testUrl");
        if (string2 == null || string2.length() <= 0) {
            try {
                Object object;
                String string3 = string;
                if (stringArray != null && stringArray.length > 0) {
                    string3 = this.replaceTemplateParameters(string, stringArray);
                }
                URL uRL = new URL(this.encodeUrl(string3, stringArray2));
                this.conn = (HttpsURLConnection)uRL.openConnection();
                TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    }

                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                }};
                SSLContext sSLContext = null;
                sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(null, trustManagerArray, null);
                this.conn.setSSLSocketFactory(sSLContext.getSocketFactory());
                this.conn.setDoInput(true);
                this.conn.setDoOutput(true);
                this.conn.setUseCaches(false);
                this.conn.setDefaultUseCaches(false);
                this.conn.setAllowUserInteraction(true);
                this.conn.setConnectTimeout(30000);
                PasswordAuthentication passwordAuthentication = Kenai.getDefault().getPasswordAuthentication();
                if (!(passwordAuthentication == null || passwordAuthentication.getUserName() == null || stringArray2 != null && stringArray2[0][0].equals("username"))) {
                    assert (passwordAuthentication.getPassword() != null);
                    object = passwordAuthentication.getUserName() + ":" + String.valueOf(passwordAuthentication.getPassword());
                    String string4 = new BASE64Encoder().encode(((String)object).getBytes());
                    this.conn.setRequestProperty("Authorization", "Basic " + string4);
                }
                object = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
                this.date = ((DateFormat)object).format(new Date());
                this.conn.setRequestProperty("Date", this.date);
            }
            catch (Exception exception) {
                Logger.getLogger(RestConnection.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    public String getDate() {
        return this.date;
    }

    public RestResponse get() throws IOException {
        return this.get(null);
    }

    public RestResponse get(String[][] stringArray) throws IOException {
        String string = System.getProperty("netbeans.t9y.kenai.testUrl");
        if (string != null && string.length() > 0) {
            return new RestResponse();
        }
        this.conn.setRequestMethod("GET");
        return this.connect(stringArray, null);
    }

    public RestResponse head() throws IOException {
        return this.get(null);
    }

    public RestResponse head(String[][] stringArray) throws IOException {
        this.conn.setRequestMethod("HEAD");
        return this.connect(stringArray, null);
    }

    public RestResponse put(String[][] stringArray) throws IOException {
        return this.put(stringArray, (InputStream)null);
    }

    public RestResponse put(String[][] stringArray, String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        if (string != null) {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        return this.put(stringArray, byteArrayInputStream);
    }

    public RestResponse put(String[][] stringArray, InputStream inputStream) throws IOException {
        this.conn.setRequestMethod("PUT");
        return this.connect(stringArray, inputStream);
    }

    public RestResponse post(String[][] stringArray) throws IOException {
        return this.post(stringArray, (InputStream)null);
    }

    public RestResponse post(String[][] stringArray, String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        if (string != null) {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        return this.post(stringArray, byteArrayInputStream);
    }

    public RestResponse post(String[][] stringArray, InputStream inputStream) throws IOException {
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("Content-Type", "application/json");
        return this.connect(stringArray, inputStream);
    }

    public RestResponse post(String[][] stringArray, String[][] stringArray2) throws IOException {
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("Content-Type", "application/json");
        String string = this.encodeParams(stringArray2);
        return this.connect(stringArray, new ByteArrayInputStream(string.getBytes("UTF-8")));
    }

    public RestResponse delete(String[][] stringArray) throws IOException {
        this.conn.setRequestMethod("DELETE");
        return this.connect(stringArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestResponse connect(String[][] stringArray, InputStream inputStream) throws IOException {
        RestResponse restResponse = new RestResponse();
        try {
            Closeable closeable;
            this.setHeaders(stringArray);
            String string = this.conn.getRequestMethod();
            byte[] byArray = new byte[1024];
            int n = 0;
            if ((string.equals("PUT") || string.equals("POST")) && inputStream != null) {
                this.conn.setDoOutput(true);
                closeable = this.conn.getOutputStream();
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)closeable).write(byArray, 0, n);
                }
                ((OutputStream)closeable).flush();
            }
            restResponse.setResponseCode(this.conn.getResponseCode());
            restResponse.setResponseMessage(this.conn.getResponseMessage());
            restResponse.setContentType(this.conn.getContentType());
            restResponse.setContentEncoding(this.conn.getContentEncoding());
            restResponse.setLastModified(this.conn.getLastModified());
            try {
                closeable = this.conn.getInputStream();
                while ((n = ((InputStream)closeable).read(byArray)) != -1) {
                    restResponse.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                while ((n = this.conn.getErrorStream().read(byArray)) != -1) {
                    restResponse.write(byArray, 0, n);
                }
            }
            return restResponse;
        }
        catch (Exception exception) {
            String string = "Cannot connect to : " + this.conn.getURL().getHost() + ", caused by " + exception.getMessage();
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.conn.getErrorStream()));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append('\n');
                }
                string = stringBuffer.toString();
                return string;
            }
            finally {
                throw new IOException(string);
            }
        }
    }

    private String replaceTemplateParameters(String string, String[][] stringArray) {
        String string2 = string;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i][0];
                String string4 = stringArray[i][1];
                if (string4 == null) {
                    string4 = "";
                }
                string2 = string2.replace(string3, string4);
            }
        }
        return string2;
    }

    private String encodeUrl(String string, String[][] stringArray) {
        String string2 = this.encodeParams(stringArray);
        if (string2.length() > 0) {
            string2 = "?" + string2;
        }
        return string + string2;
    }

    private String encodeParams(String[][] stringArray) {
        String string = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i][0];
                String string3 = stringArray[i][1];
                if (string3 == null) continue;
                try {
                    string = string + string2 + "=" + URLEncoder.encode(string3, "UTF-8") + "&";
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Logger.getLogger(RestConnection.class.getName()).log(Level.SEVERE, null, unsupportedEncodingException);
                }
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private void setHeaders(String[][] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.conn.setRequestProperty(stringArray[i][0], stringArray[i][1]);
            }
        }
    }

    static {
        System.setProperty("http.agent", System.getProperty("user.name") + " (from NetBeans IDE)");
    }
}

