/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.commons.patterns.Filter;
import org.codeviation.commons.utils.ArrayUtil;
import org.codeviation.pojson.FileNameFactory;
import org.codeviation.pojson.PojsonFormater;
import org.codeviation.pojson.StoreInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PojsonSave<T> {
    private static int DEFAULT_STRING_BUFFER_SIZE = 2048;
    private Class<T> clazz;
    private Filter<String> fieldFilter;
    private String indentation = "    ";
    private int indentLevel = 0;
    private Factory<StoreInfo, Class> sif;

    public PojsonSave() {
        this.clazz = null;
        this.sif = new StoreInfoFactory();
    }

    private PojsonSave(Class<T> clazz) {
        this.clazz = clazz;
        this.sif = new StoreInfoFactory();
    }

    public static PojsonSave<?> create() {
        return new PojsonSave();
    }

    public static <T> PojsonSave<T> create(Class<T> clazz) {
        return new PojsonSave<T>(clazz);
    }

    public void setFieldFilter(Filter<String> filter) {
        this.fieldFilter = filter;
    }

    public void setIndentation(String string) {
        this.indentation = string;
    }

    public void setIndentLevel(int n) {
        this.indentLevel = n;
    }

    public void save(Writer writer, T t) throws IOException {
        PojsonFormater pojsonFormater = new PojsonFormater(this.sif, this.getIndentation(), writer);
        pojsonFormater.write(t, this.getIndentLevel());
    }

    public void save(Writer writer, T[] TArray) throws IOException {
        PojsonFormater pojsonFormater = new PojsonFormater(this.sif, this.getIndentation(), writer);
        pojsonFormater.write(TArray, this.getIndentLevel());
    }

    public void save(Writer writer, T t, T ... TArray) throws IOException {
        PojsonFormater pojsonFormater = new PojsonFormater(this.sif, this.indentation, writer);
        pojsonFormater.write(ArrayUtil.union(new Object[]{t}, TArray), this.getIndentLevel());
    }

    public void save(Writer writer, Iterable<T> iterable) throws IOException {
        PojsonFormater pojsonFormater = new PojsonFormater(this.sif, this.indentation, writer);
        pojsonFormater.write(iterable, this.getIndentLevel());
    }

    public String asString(T t) {
        StringWriter stringWriter = new StringWriter(DEFAULT_STRING_BUFFER_SIZE);
        try {
            this.save((Writer)stringWriter, t);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public String asString(T t, T ... TArray) {
        StringWriter stringWriter = new StringWriter(DEFAULT_STRING_BUFFER_SIZE);
        try {
            this.save(stringWriter, t, TArray);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public String asString(T[] TArray) {
        StringWriter stringWriter = new StringWriter(DEFAULT_STRING_BUFFER_SIZE);
        try {
            this.save((Writer)stringWriter, TArray);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public String asString(Iterable<T> iterable) {
        StringWriter stringWriter = new StringWriter(DEFAULT_STRING_BUFFER_SIZE);
        try {
            this.save((Writer)stringWriter, iterable);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    String getFileName(T t) {
        Class<Object> clazz = this.clazz == null ? t.getClass() : this.clazz;
        StoreInfo storeInfo = this.sif.create(clazz);
        FileNameFactory fileNameFactory = new FileNameFactory(clazz, storeInfo.getFields());
        return fileNameFactory.create((Object)t);
    }

    private String getIndentation() {
        return this.indentation;
    }

    private int getIndentLevel() {
        return this.indentLevel;
    }

    private Filter<String> getFieldFilter() {
        return this.fieldFilter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StoreInfoFactory
    implements Factory<StoreInfo, Class> {
        private StoreInfoFactory() {
        }

        @Override
        public StoreInfo create(Class clazz) {
            return new StoreInfo(clazz);
        }
    }
}

