/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.codeviation.commons.reflect.ClassUtils;

class JsonUtils {
    private JsonUtils() {
    }

    public static String toJsonString(Object object) {
        if (object == null || object instanceof Void) {
            return "null";
        }
        if (object instanceof Enum) {
            return JsonUtils.quote(object.toString());
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Character) {
            return JsonUtils.quote(object.toString());
        }
        if (object instanceof String) {
            return JsonUtils.quote((String)object);
        }
        if (object instanceof Date) {
            return JsonUtils.numberToString(((Date)object).getTime());
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
            return JsonUtils.numberToString(object);
        }
        throw new IllegalArgumentException("Cant store object " + object + " in field ");
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        stringBuffer.append('\"');
        block9: for (int i = 0; i < n; ++i) {
            char c2 = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block9;
                }
                case '/': {
                    if (c2 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String string2 = "000" + Integer.toHexString(c);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4));
                        continue block9;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static String numberToString(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Number must not be null");
        }
        JsonUtils.testValidity(object);
        return JsonUtils.trimNumber(object.toString());
    }

    public static String trimNumber(String string) {
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    static void testValidity(Object object) {
        if (object != null) {
            if (object instanceof Double) {
                if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                    throw new IllegalArgumentException("JSON does not allow non-finite numbers");
                }
            } else if (object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN())) {
                throw new IllegalArgumentException("JSON does not allow non-finite numbers.");
            }
        }
    }

    static Iterator getIterator(Object object) {
        if (object.getClass().isArray()) {
            return new ReflectiveArrayIterator(object);
        }
        if (object instanceof Iterable) {
            return ((Iterable)object).iterator();
        }
        return null;
    }

    public static Object fromJSON(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        if (ClassUtils.isSuperclass(object.getClass(), clazz)) {
            return object;
        }
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, (String)object);
        }
        if (clazz.isArray()) {
            List list = (List)object;
            Object object2 = Array.newInstance(clazz.getComponentType(), list.size());
            int n = 0;
            for (Object e : list) {
                Array.set(object2, n++, JsonUtils.fromJSON(clazz.getComponentType(), e));
            }
            return object2;
        }
        if (clazz.isPrimitive()) {
            clazz = ClassUtils.primitive2Object(clazz);
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (Byte.class.equals((Object)clazz)) {
                return new Byte(number.byteValue());
            }
            if (Short.class.equals((Object)clazz)) {
                return new Short(number.shortValue());
            }
            if (Integer.class.equals((Object)clazz)) {
                return new Integer(number.intValue());
            }
            if (Long.class.equals((Object)clazz)) {
                return new Long(number.longValue());
            }
            if (Float.class.equals((Object)clazz)) {
                return new Float(number.floatValue());
            }
            if (Date.class.equals((Object)clazz) || ClassUtils.isSuperclass(clazz, Date.class)) {
                return new Date(number.longValue());
            }
            return new Double(number.doubleValue());
        }
        if (Character.class.equals((Object)clazz)) {
            return Character.valueOf(((String)object).charAt(0));
        }
        throw new ClassCastException(object.getClass() + " into " + clazz);
    }

    private static class ReflectiveArrayIterator
    implements Iterator {
        private Object a;
        private int len;
        private int ci = 0;

        ReflectiveArrayIterator(Object object) {
            this.a = object;
            this.len = Array.getLength(object);
        }

        public boolean hasNext() {
            return this.ci < this.len;
        }

        public Object next() {
            ++this.ci;
            return Array.get(this.a, this.ci - 1);
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

