/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.util.Iterator;
import org.codeviation.commons.patterns.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterators {
    private Iterators() {
    }

    public static <T, P> Iterator<T> translating(Iterator<P> iterator, Factory<T, P> factory) {
        return new TranslatingIterator<T, P>(iterator, factory);
    }

    public static <T, P> Iterator<T> translating(Iterable<P> iterable, Factory<T, P> factory) {
        return new TranslatingIterator<T, P>(iterable.iterator(), factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TranslatingIterator<T, P>
    implements Iterator<T> {
        private Iterator<P> iterator;
        private Factory<T, P> factory;

        public TranslatingIterator(Iterator<P> iterator, Factory<T, P> factory) {
            this.iterator = iterator;
            this.factory = factory;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.factory.create(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

