/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.navigation.ClassMemberPanelUI;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementScanningTask
extends ParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(ElementScanningTask.class.getName());
    private final ClassMemberPanelUI ui;
    private boolean canceled;

    public ElementScanningTask(ClassMemberPanelUI classMemberPanelUI) {
        assert (classMemberPanelUI != null);
        this.ui = classMemberPanelUI;
    }

    public void run(ParserResult parserResult, SchedulerEvent schedulerEvent) {
        this.resume();
        final FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        final int[] nArray = new int[]{0};
        final ArrayList arrayList = new ArrayList();
        try {
            ParserManager.parse(Collections.singleton(parserResult.getSnapshot().getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Object object;
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType());
                    if (language != null && (object = language.getStructure()) != null) {
                        long l = System.currentTimeMillis();
                        Parser.Result result = resultIterator.getParserResult();
                        if (result instanceof ParserResult) {
                            List<? extends StructureItem> list = object.scan((ParserResult)result);
                            long l2 = System.currentTimeMillis();
                            Logger.getLogger("TIMER").log(Level.FINE, "Structure (" + language.getMimeType() + ")", new Object[]{fileObject, l2 - l});
                            if (list.size() > 0) {
                                nArray[0] = nArray[0] + 1;
                            }
                            arrayList.add(new MimetypeRootNode(language, list, resultIterator.getSnapshot().getMimePath()));
                        }
                    }
                    for (Embedding embedding : resultIterator.getEmbeddings()) {
                        this.run(resultIterator.getResultIterator(embedding));
                    }
                }
            });
        }
        catch (ParseException parseException) {
            LOG.log(Level.WARNING, null, parseException);
        }
        HashMap hashMap = new HashMap();
        for (Object object : arrayList) {
            Object object2 = ((MimetypeRootNode)object).getMimePath();
            String string = object2.getMimeType(object2.size() - 1);
            MimetypeRootNode mimetypeRootNode = (MimetypeRootNode)hashMap.get(string);
            if (mimetypeRootNode != null) {
                MimePath mimePath = mimetypeRootNode.getMimePath();
                if (object2.size() >= mimePath.size()) continue;
                hashMap.put(string, object);
                continue;
            }
            hashMap.put(string, object);
        }
        arrayList.clear();
        arrayList.addAll(hashMap.values());
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, new Comparator<MimetypeRootNode>(){

                @Override
                public int compare(MimetypeRootNode mimetypeRootNode, MimetypeRootNode mimetypeRootNode2) {
                    return mimetypeRootNode.getSortText().compareTo(mimetypeRootNode2.getSortText());
                }
            });
        }
        ArrayList arrayList2 = new ArrayList();
        if (nArray[0] > 1) {
            for (Object object2 : arrayList) {
                arrayList2.add(object2);
            }
        } else {
            for (Object object2 : arrayList) {
                arrayList2.addAll(((MimetypeRootNode)object2).getNestedItems());
            }
        }
        if (!this.isCancelled()) {
            this.ui.refresh(new RootStructureItem(arrayList2), fileObject);
        }
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.SELECTED_NODES_SENSITIVE_TASK_SCHEDULER;
    }

    public synchronized void cancel() {
        this.canceled = true;
    }

    public synchronized void resume() {
        this.canceled = false;
    }

    public synchronized boolean isCancelled() {
        return this.canceled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MimetypeRootNode
    implements StructureItem {
        private static final String CSS_MIMETYPE = "text/x-css";
        private static final String CSS_SORT_TEXT = "2";
        private static final String JAVASCRIPT_MIMETYPE = "text/javascript";
        private static final String RUBY_MIMETYPE = "text/x-ruby";
        private static final String YAML_MIMETYPE = "text/x-yaml";
        private static final String JAVASCRIPT_SORT_TEXT = "1";
        private static final String HTML_MIMETYPE = "text/html";
        private static final String HTML_SORT_TEXT = "3";
        private static final String YAML_SORT_TEXT = "4";
        private static final String RUBY_SORT_TEXT = "5";
        private static final String OTHER_SORT_TEXT = "9";
        Language language;
        private List<? extends StructureItem> items;
        long from;
        long to;
        private MimePath mimePath;

        private MimetypeRootNode(Language language, List<? extends StructureItem> list, MimePath mimePath) {
            this.language = language;
            this.items = list;
            this.from = list.size() > 0 ? list.get(0).getPosition() : 0L;
            this.to = list.size() > 0 ? list.get(list.size() - 1).getEndPosition() : 0L;
            this.mimePath = mimePath;
        }

        public MimePath getMimePath() {
            return this.mimePath;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof MimetypeRootNode)) {
                return false;
            }
            MimetypeRootNode mimetypeRootNode = (MimetypeRootNode)object;
            return this.language.equals(mimetypeRootNode.language);
        }

        @Override
        public int hashCode() {
            int n = 3;
            n = 97 * n + (this.language != null ? this.language.hashCode() : 0);
            return n;
        }

        @Override
        public String getName() {
            return this.language.getDisplayName();
        }

        @Override
        public String getSortText() {
            if (this.language.getMimeType().equals(CSS_MIMETYPE)) {
                return CSS_SORT_TEXT;
            }
            if (this.language.getMimeType().equals(JAVASCRIPT_MIMETYPE)) {
                return JAVASCRIPT_SORT_TEXT;
            }
            if (this.language.getMimeType().equals(HTML_MIMETYPE)) {
                return HTML_SORT_TEXT;
            }
            if (this.language.getMimeType().equals(YAML_MIMETYPE)) {
                return YAML_SORT_TEXT;
            }
            if (this.language.getMimeType().equals(RUBY_MIMETYPE)) {
                return RUBY_SORT_TEXT;
            }
            return OTHER_SORT_TEXT + this.getName();
        }

        @Override
        public String getHtml(HtmlFormatter htmlFormatter) {
            return this.getName();
        }

        @Override
        public ElementHandle getElementHandle() {
            return null;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public List<? extends StructureItem> getNestedItems() {
            return this.items;
        }

        @Override
        public long getPosition() {
            return this.from;
        }

        @Override
        public long getEndPosition() {
            return this.to;
        }

        @Override
        public ImageIcon getCustomIcon() {
            String string = this.language.getIconBase();
            return string == null ? null : new ImageIcon(ImageUtilities.loadImage((String)string));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RootStructureItem
    implements StructureItem {
        private final List<? extends StructureItem> items;

        public RootStructureItem(List<? extends StructureItem> list) {
            this.items = list;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getHtml(HtmlFormatter htmlFormatter) {
            return null;
        }

        @Override
        public ElementHandle getElementHandle() {
            throw new UnsupportedOperationException("Not supported on the Root Node.");
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public List<? extends StructureItem> getNestedItems() {
            return this.items;
        }

        @Override
        public long getPosition() {
            return 0L;
        }

        @Override
        public long getEndPosition() {
            return Long.MAX_VALUE;
        }

        @Override
        public ImageIcon getCustomIcon() {
            return null;
        }

        @Override
        public String getSortText() {
            return null;
        }
    }
}

