/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreatePersistenceUnit;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTemporalAnnotationHint
implements Fix {
    private FileObject fileObject;
    private ElementHandle<Element> elementHandle;

    public CreateTemporalAnnotationHint(FileObject fileObject, ElementHandle<Element> elementHandle) {
        this.elementHandle = elementHandle;
        this.fileObject = fileObject;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                Element element = CreateTemporalAnnotationHint.this.elementHandle.resolve((CompilationInfo)workingCopy);
                if (element != null) {
                    Tree tree = workingCopy.getTrees().getTree(element);
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    ModifiersTree modifiersTree = null;
                    if (tree.getKind() == Tree.Kind.VARIABLE) {
                        modifiersTree = ((VariableTree)tree).getModifiers();
                    } else if (tree.getKind() == Tree.Kind.METHOD) {
                        modifiersTree = ((MethodTree)tree).getModifiers();
                    } else {
                        throw new IllegalStateException();
                    }
                    TypeElement typeElement = workingCopy.getElements().getTypeElement("javax.persistence.Temporal");
                    ExpressionTree expressionTree = treeMaker.QualIdent((Element)typeElement);
                    AnnotationTree annotationTree = treeMaker.Annotation((Tree)expressionTree, Collections.singletonList(treeMaker.Identifier((CharSequence)"javax.persistence.TemporalType.DATE")));
                    ArrayList<? extends AnnotationTree> arrayList = new ArrayList<AnnotationTree>();
                    arrayList.addAll(modifiersTree.getAnnotations());
                    arrayList.add(annotationTree);
                    ModifiersTree modifiersTree2 = treeMaker.Modifiers(modifiersTree, arrayList);
                    workingCopy.rewrite((Tree)modifiersTree, (Tree)modifiersTree2);
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)cancellableTask).commit();
        }
        catch (IOException iOException) {
            JPAProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return null;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getText() {
        return NbBundle.getMessage(CreatePersistenceUnit.class, (String)"LBL_CreateTemporalAnnotationHint");
    }
}

