/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDefaultConstructor
implements Fix {
    private FileObject fileObject;
    private ElementHandle<TypeElement> classHandle;

    public CreateDefaultConstructor(FileObject fileObject, ElementHandle<TypeElement> elementHandle) {
        this.classHandle = elementHandle;
        this.fileObject = fileObject;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement typeElement = (TypeElement)CreateDefaultConstructor.this.classHandle.resolve((CompilationInfo)workingCopy);
                if (typeElement != null) {
                    ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC));
                    MethodTree methodTree = treeMaker.Constructor(modifiersTree, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{}");
                    ClassTree classTree2 = treeMaker.insertClassMember(classTree, CreateDefaultConstructor.this.getPositionToInsert(classTree), (Tree)methodTree);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)cancellableTask).commit();
        }
        catch (IOException iOException) {
            JPAProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return null;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getText() {
        return NbBundle.getMessage(CreateDefaultConstructor.class, (String)"LBL_CreateDefaultConstructor", (Object)Utilities.getShortClassName(this.classHandle.getQualifiedName()));
    }

    private int getPositionToInsert(ClassTree classTree) {
        int n = classTree.getMembers().size();
        for (int i = 0; i < n; ++i) {
            if (classTree.getMembers().get(i).getKind() != Tree.Kind.METHOD) continue;
            return i;
        }
        return n;
    }
}

