/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.jpa.model.JPAHelper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.JPARulesEngine;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.IdClass;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JPAProblemFinder {
    private boolean cancelled = false;
    private FileObject file = null;
    private Object cancellationLock = new Object();
    private JPAProblemContext context = null;
    private List<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
    public static final Logger LOG = Logger.getLogger(JPAProblemFinder.class.getName());
    private static final String PERSISTENCE_SCOPES_LISTENER = "jpa.verification.scopes_listener";
    private static final Object singleInstanceLock = new Object();
    private static JPAProblemFinder runningInstance = null;
    private static boolean usgLogged;

    public JPAProblemFinder(FileObject fileObject) {
        assert (fileObject != null);
        this.file = fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final CompilationInfo compilationInfo) throws Exception {
        if (!"text/x-java".equals(this.file.getMIMEType())) {
            return;
        }
        if (runningInstance != null) {
            runningInstance.cancel();
        }
        Object object = singleInstanceLock;
        synchronized (object) {
            runningInstance = this;
            this.cancelled = false;
            this.problemsFound.clear();
            this.createPersistenceScopesListener(this.file, compilationInfo.getDocument());
            MetadataModel<EntityMappingsMetadata> metadataModel = ModelUtils.getModel(this.file);
            if (metadataModel == null) {
                return;
            }
            metadataModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run(EntityMappingsMetadata entityMappingsMetadata) {
                    for (Tree tree : compilationInfo.getCompilationUnit().getTypeDecls()) {
                        if (JPAProblemFinder.this.isCancelled()) break;
                        if (tree.getKind() != Tree.Kind.CLASS) continue;
                        TreePath treePath = compilationInfo.getTrees().getPath(compilationInfo.getCompilationUnit(), tree);
                        TypeElement typeElement = (TypeElement)compilationInfo.getTrees().getElement(treePath);
                        JPAProblemFinder.this.processClass(compilationInfo, entityMappingsMetadata, typeElement);
                        for (TypeElement typeElement2 : ElementFilter.typesIn(typeElement.getEnclosedElements())) {
                            JPAProblemFinder.this.processClass(compilationInfo, entityMappingsMetadata, typeElement2);
                        }
                        Object object = JPAProblemFinder.this.cancellationLock;
                        synchronized (object) {
                            JPAProblemFinder.this.context = null;
                        }
                    }
                    return null;
                }
            });
            HintsController.setErrors((FileObject)this.file, (String)"JPA Verification", this.problemsFound);
            runningInstance = null;
        }
    }

    private void processClass(CompilationInfo compilationInfo, EntityMappingsMetadata entityMappingsMetadata, TypeElement typeElement) {
        long l = Calendar.getInstance().getTimeInMillis();
        this.context = this.findProblemContext(compilationInfo, typeElement, entityMappingsMetadata, false);
        JPARulesEngine jPARulesEngine = new JPARulesEngine();
        jPARulesEngine.visitTypeAsClass(typeElement, this.context);
        this.problemsFound.addAll(jPARulesEngine.getProblemsFound());
        this.problemsFound.addAll(this.processIdClass(compilationInfo, typeElement, entityMappingsMetadata, this.context.getModelElement()));
        if (LOG.isLoggable(Level.FINE)) {
            long l2 = Calendar.getInstance().getTimeInMillis() - l;
            LOG.log(Level.FINE, "processed class {0} in {1} ms", new Object[]{typeElement.getSimpleName(), l2});
        }
    }

    private List<ErrorDescription> processIdClass(CompilationInfo compilationInfo, TypeElement typeElement, EntityMappingsMetadata entityMappingsMetadata, Object object) {
        TypeElement typeElement2;
        String string;
        IdClass idClass = null;
        if (object instanceof Entity) {
            idClass = ((Entity)object).getIdClass();
        } else if (object instanceof MappedSuperclass) {
            idClass = ((MappedSuperclass)object).getIdClass();
        }
        if (idClass != null && (string = idClass.getClass2()) != null && (typeElement2 = compilationInfo.getElements().getTypeElement(string)) != null) {
            JPAProblemContext jPAProblemContext = this.findProblemContext(compilationInfo, typeElement2, entityMappingsMetadata, true);
            AnnotationMirror annotationMirror = Utilities.findAnnotation(typeElement, "javax.persistence.IdClass");
            Tree tree = annotationMirror != null ? compilationInfo.getTrees().getTree(typeElement, annotationMirror) : compilationInfo.getTrees().getTree(typeElement);
            jPAProblemContext.setElementToAnnotate(tree);
            JPARulesEngine jPARulesEngine = new JPARulesEngine();
            jPARulesEngine.visitTypeAsClass(typeElement2, jPAProblemContext);
            return jPARulesEngine.getProblemsFound();
        }
        return Collections.emptyList();
    }

    private JPAProblemContext findProblemContext(CompilationInfo compilationInfo, TypeElement typeElement, EntityMappingsMetadata entityMappingsMetadata, boolean bl) {
        JPAProblemContext jPAProblemContext = new JPAProblemContext();
        jPAProblemContext.setMetaData(entityMappingsMetadata);
        jPAProblemContext.setJavaClass(typeElement);
        if (!bl) {
            Entity entity = ModelUtils.getEntity(entityMappingsMetadata, typeElement);
            if (entity != null) {
                jPAProblemContext.setEntity(true);
            } else {
                entity = ModelUtils.getEmbeddable(entityMappingsMetadata, typeElement);
                if (entity != null) {
                    jPAProblemContext.setEmbeddable(true);
                } else {
                    entity = ModelUtils.getMappedSuperclass(entityMappingsMetadata, typeElement);
                    if (entity != null) {
                        jPAProblemContext.setMappedSuperClass(true);
                    }
                }
            }
            jPAProblemContext.setModelElement(entity);
        }
        jPAProblemContext.setIdClass(bl);
        jPAProblemContext.setFileObject(this.file);
        jPAProblemContext.setCompilationInfo(compilationInfo);
        if (jPAProblemContext.isJPAClass()) {
            jPAProblemContext.setAccessType(JPAHelper.findAccessType(typeElement, jPAProblemContext.getModelElement()));
            if (!usgLogged) {
                usgLogged = true;
                PersistenceUtils.logUsage(JPAProblemFinder.class, (String)"USG_PERSISTENCE_DETECTED", (Object[])new String[]{"CLASS"});
            }
        }
        return jPAProblemContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        LOG.fine("Cancelling JPAProblemFinder task");
        this.cancelled = true;
        Object object = this.cancellationLock;
        synchronized (object) {
            if (this.context != null) {
                this.context.setCancelled(true);
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<? extends ErrorDescription> getProblemsFound() {
        return this.problemsFound;
    }

    private void createPersistenceScopesListener(FileObject fileObject, Document document) {
        PersistenceScopes persistenceScopes;
        if (document == null) {
            return;
        }
        LOG.fine("Creating PersistenceScopesListener on " + fileObject.getName());
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (persistenceScopes = PersistenceScopes.getPersistenceScopes((Project)project)) != null) {
            Object object;
            PersistenceScopesListener persistenceScopesListener = (PersistenceScopesListener)document.getProperty(PERSISTENCE_SCOPES_LISTENER);
            if (persistenceScopesListener == null) {
                persistenceScopesListener = new PersistenceScopesListener(fileObject);
                object = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)persistenceScopesListener, null);
                persistenceScopes.addPropertyChangeListener((PropertyChangeListener)object);
                document.putProperty(PERSISTENCE_SCOPES_LISTENER, persistenceScopesListener);
            }
            object = new ArrayList();
            for (PersistenceScope persistenceScope : persistenceScopes.getPersistenceScopes()) {
                FileObject fileObject2 = persistenceScope.getPersistenceXml();
                PersistenceXMLListener persistenceXMLListener = new PersistenceXMLListener(fileObject);
                FileChangeListener fileChangeListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)persistenceXMLListener), null);
                fileObject2.addFileChangeListener(fileChangeListener);
                ((ArrayList)object).add(persistenceXMLListener);
                LOG.fine("Added PersistenceXMLListener to " + fileObject2.getName());
            }
            persistenceScopesListener.setPXMLListeners((List<PersistenceXMLListener>)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProblemFinderCompControl
    extends JPAProblemFinder
    implements CancellableTask<CompilationController> {
        public ProblemFinderCompControl(FileObject fileObject) {
            super(fileObject);
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            super.run((CompilationInfo)compilationController);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProblemFinderCompInfo
    extends JPAProblemFinder
    implements CancellableTask<CompilationInfo> {
        public ProblemFinderCompInfo(FileObject fileObject) {
            super(fileObject);
        }
    }

    private class PersistenceXMLListener
    extends RescanTrigger
    implements FileChangeListener {
        PersistenceXMLListener(FileObject fileObject) {
            super(fileObject);
        }

        public void fileChanged(FileEvent fileEvent) {
            LOG.fine("Received a change event from persistence.xml");
            this.rescan();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PersistenceScopesListener
    extends RescanTrigger
    implements PropertyChangeListener {
        List<PersistenceXMLListener> pxmlListeners;

        PersistenceScopesListener(FileObject fileObject) {
            super(fileObject);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            LOG.fine("Received a change event from PersistenceScopes");
            this.rescan();
        }

        void setPXMLListeners(List<PersistenceXMLListener> list) {
            this.pxmlListeners = list;
        }
    }

    private abstract class RescanTrigger {
        private FileObject file;

        RescanTrigger(FileObject fileObject) {
            this.file = fileObject;
        }

        void rescan() {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new ProblemFinderCompControl(this.file), true);
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINE, iOException.getMessage(), iOException);
                }
            }
        }
    }
}

