/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.layout;

import java.util.Date;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Widget;

public class ConnectionWrapperLayout
implements Layout {
    private ConnectionWidget connectionWidget;
    private Layout connectionWidgetLayout;
    private LabelWidget label;
    private static final Logger LOGGER = Logger.getLogger(ConnectionWrapperLayout.class.toString());

    public ConnectionWrapperLayout(ConnectionWidget connectionWidget, LabelWidget labelWidget) {
        this.connectionWidget = connectionWidget;
        this.connectionWidgetLayout = connectionWidget.getLayout();
        this.label = labelWidget;
    }

    public void layout(Widget widget) {
        this.connectionWidgetLayout.layout(widget);
        ConnectionWrapperLayout.resetLabelConstraint(this.connectionWidget, this.label);
    }

    public boolean requiresJustification(Widget widget) {
        return this.connectionWidgetLayout.requiresJustification(widget);
    }

    public void justify(Widget widget) {
        this.connectionWidgetLayout.justify(widget);
    }

    private static final void resetLabelConstraint(ConnectionWidget connectionWidget, LabelWidget labelWidget) {
        assert (connectionWidget != null);
        if (labelWidget != null) {
            connectionWidget.removeConstraint((Widget)labelWidget);
            connectionWidget.removeChild((Widget)labelWidget);
            Anchor anchor = connectionWidget.getSourceAnchor();
            Anchor.Entry entry = connectionWidget.getSourceAnchorEntry();
            assert (anchor != null);
            assert (entry != null);
            if (anchor != null && entry != null) {
                EnumSet enumSet = anchor.compute(entry).getDirections();
                if (enumSet.contains(Anchor.Direction.TOP)) {
                    labelWidget.setOrientation(LabelWidget.Orientation.ROTATE_90);
                    connectionWidget.setConstraint((Widget)labelWidget, LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT, 10);
                } else if (enumSet.contains(Anchor.Direction.BOTTOM)) {
                    labelWidget.setOrientation(LabelWidget.Orientation.ROTATE_90);
                    connectionWidget.setConstraint((Widget)labelWidget, LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_RIGHT, 10);
                } else if (enumSet.contains(Anchor.Direction.RIGHT)) {
                    connectionWidget.setConstraint((Widget)labelWidget, LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT, 10);
                    labelWidget.setOrientation(LabelWidget.Orientation.NORMAL);
                } else {
                    connectionWidget.setConstraint((Widget)labelWidget, LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_LEFT, 10);
                    labelWidget.setOrientation(LabelWidget.Orientation.NORMAL);
                }
            } else {
                LogRecord logRecord = new LogRecord(Level.FINE, "Problems Reseting Label Constraint");
                logRecord.setSourceClassName("ConnectionWrapperLayout");
                logRecord.setSourceMethodName("resetLabelConstraint");
                logRecord.setParameters(new Object[]{connectionWidget, labelWidget, new Date()});
                LOGGER.log(logRecord);
                connectionWidget.setConstraint((Widget)labelWidget, LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_LEFT, 10);
                labelWidget.setOrientation(LabelWidget.Orientation.NORMAL);
            }
            connectionWidget.addChild((Widget)labelWidget);
        }
    }
}

