/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.templates;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.rubyproject.templates.NewRubyFileWizardIterator;
import org.netbeans.modules.ruby.rubyproject.templates.RubyTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyTargetChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private static final String FOLDER_TO_DELETE = "folderToDelete";
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private RubyTargetChooserPanelGUI gui;
    private final WizardDescriptor.Panel<WizardDescriptor> bottomPanel;
    private WizardDescriptor wizard;
    private final Project project;
    private final SourceGroup[] folders;
    private final NewRubyFileWizardIterator.Type type;

    public RubyTargetChooserPanel(Project project, SourceGroup[] sourceGroupArray, WizardDescriptor.Panel<WizardDescriptor> panel, NewRubyFileWizardIterator.Type type) {
        this.project = project;
        this.folders = sourceGroupArray;
        this.bottomPanel = panel;
        this.type = type;
        if (panel != null) {
            panel.addChangeListener((ChangeListener)this);
        }
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new RubyTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.type);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx helpCtx;
        if (this.bottomPanel != null && (helpCtx = this.bottomPanel.getHelp()) != null) {
            return helpCtx;
        }
        return null;
    }

    public boolean isValid() {
        String string;
        if (this.gui == null || this.gui.getTargetName() == null) {
            this.setErrorMessage(null);
            return false;
        }
        this.setLocalizedErrorMessage(null);
        if (this.type == NewRubyFileWizardIterator.Type.SPEC) {
            if (this.gui.getClassName() == null || !RubyUtils.isValidConstantName((String)this.gui.getClassName())) {
                this.setErrorMessage("ERR_RubyTargetChooser_InvalidClass");
                return false;
            }
            string = RubyUtils.getIdentifierWarning((String)this.gui.getClassName(), (int)0);
            if (string != null) {
                this.setLocalizedErrorMessage(string);
            }
        } else if (this.type == NewRubyFileWizardIterator.Type.CLASS || this.type == NewRubyFileWizardIterator.Type.MODULE || this.type == NewRubyFileWizardIterator.Type.TEST) {
            String string2;
            Object object2;
            if (this.type == NewRubyFileWizardIterator.Type.CLASS || this.type == NewRubyFileWizardIterator.Type.TEST) {
                if (this.gui.getClassName() == null || !RubyUtils.isValidConstantName((String)this.gui.getClassName())) {
                    this.setErrorMessage("ERR_RubyTargetChooser_InvalidClass");
                    return false;
                }
                string = RubyUtils.getIdentifierWarning((String)this.gui.getClassName(), (int)0);
                if (string != null) {
                    this.setLocalizedErrorMessage(string);
                }
                if ((object2 = this.gui.getExtends()) != null && ((String)object2).length() > 0) {
                    String[] object;
                    String[] stringArray = object = ((String)object2).split("::");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        string2 = stringArray[i];
                        if (!RubyUtils.isValidConstantName((String)string2)) {
                            this.setErrorMessage("ERR_RubyTargetChooser_InvalidSuperclass");
                            return false;
                        }
                        string = RubyUtils.getIdentifierWarning((String)string2, (int)0);
                        if (string == null) continue;
                        this.setLocalizedErrorMessage(string);
                    }
                }
            }
            if (this.type == NewRubyFileWizardIterator.Type.MODULE) {
                if (this.gui.getClassName() == null || !RubyUtils.isValidConstantName((String)this.gui.getClassName())) {
                    this.setErrorMessage("ERR_RubyTargetChooser_InvalidModule");
                    return false;
                }
                string = RubyUtils.getIdentifierWarning((String)this.gui.getClassName(), (int)0);
                if (string != null) {
                    this.setLocalizedErrorMessage(string);
                }
            }
            if ((string = this.gui.getModuleName()) != null && string.length() > 0) {
                for (Object object : object2 = string.split("::")) {
                    if (!RubyUtils.isValidConstantName((String)object)) {
                        this.setErrorMessage("ERR_RubyTargetChooser_InvalidInModule");
                        return false;
                    }
                    string2 = RubyUtils.getIdentifierWarning((String)object, (int)0);
                    if (string2 == null) continue;
                    this.setLocalizedErrorMessage(string2);
                }
            }
        }
        if (!RubyTargetChooserPanel.isValidFileName(this.gui.getTargetName())) {
            this.setErrorMessage("ERR_RubyTargetChooser_InvalidFilename");
            return false;
        }
        string = Templates.getTemplate((WizardDescriptor)this.wizard);
        boolean bl = true;
        String string3 = RubyTargetChooserPanel.canUseFileName(this.gui.getTargetFolder(), this.gui.getTargetName(), string.getExt());
        if (this.gui != null && string3 != null) {
            this.setLocalizedErrorMessage(string3);
        }
        if (string3 != null) {
            bl = false;
        }
        if (bl && this.bottomPanel != null && !this.bottomPanel.isValid()) {
            return false;
        }
        return bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        Object object;
        this.wizard = wizardDescriptor;
        if (this.gui != null) {
            object = Templates.getTargetFolder((WizardDescriptor)this.wizard);
            this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), (FileObject)object);
        }
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings((Object)wizardDescriptor);
        }
        if (this.gui != null && (object = this.gui.getClientProperty("NewFileWizard_Title")) != null) {
            this.wizard.putProperty("NewFileWizard_Title", object);
        }
    }

    private String pathToSpecHelper(WizardDescriptor wizardDescriptor) {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("spec/spec_helper.rb");
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = this.getTargetFolderFromGUI(wizardDescriptor);
        if (!FileUtil.isParentOf((FileObject)fileObject.getParent(), (FileObject)fileObject2) && !fileObject.getParent().equals(fileObject2)) {
            return null;
        }
        String string = "/";
        FileObject fileObject3 = fileObject2;
        while (!fileObject3.equals(fileObject.getParent())) {
            string = string + "../";
            fileObject3 = fileObject3.getParent();
        }
        return "File.expand_path(File.dirname(__FILE__) + '" + string + fileObject.getName() + "')";
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        Object object = wizardDescriptor.getValue();
        if (WizardDescriptor.PREVIOUS_OPTION.equals(object) || WizardDescriptor.CANCEL_OPTION.equals(object) || WizardDescriptor.CLOSED_OPTION.equals(object)) {
            return;
        }
        if (this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings((Object)wizardDescriptor);
            }
            Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)this.getTargetFolderFromGUI(wizardDescriptor));
            Templates.setTargetName((WizardDescriptor)wizardDescriptor, (String)this.gui.getTargetName());
            if (this.type == NewRubyFileWizardIterator.Type.SPEC) {
                this.wizard.putProperty("classname", (Object)this.gui.getClassName());
                String string = RubyUtils.camelToUnderlinedName((String)this.gui.getClassName());
                String string2 = this.pathToSpecHelper(this.wizard);
                if (string2 == null) {
                    string2 = "'" + string + "'";
                }
                this.wizard.putProperty("classfile", (Object)string);
                this.wizard.putProperty("file_to_require", (Object)string2);
                this.wizard.putProperty("classfield", (Object)string);
            } else if (this.type == NewRubyFileWizardIterator.Type.CLASS || this.type == NewRubyFileWizardIterator.Type.TEST) {
                this.wizard.putProperty("class", (Object)this.gui.getClassName());
                String string = RubyUtils.camelToUnderlinedName((String)this.gui.getClassName());
                if (string.startsWith("test_")) {
                    string = string.substring("test_".length());
                } else if (string.endsWith("_test")) {
                    string = string.substring(0, string.length() - "_test".length());
                }
                this.wizard.putProperty("classfile", (Object)string);
                this.wizard.putProperty("module", (Object)this.gui.getModuleName());
                this.wizard.putProperty("extend", (Object)this.gui.getExtends());
            } else if (this.type == NewRubyFileWizardIterator.Type.MODULE) {
                this.wizard.putProperty("module", (Object)this.gui.getClassName());
                this.wizard.putProperty("outermodules", (Object)this.gui.getModuleName());
            }
        }
        wizardDescriptor.putProperty("NewFileWizard_Title", null);
        if (WizardDescriptor.FINISH_OPTION.equals(object)) {
            this.wizard.putProperty(FOLDER_TO_DELETE, null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }

    private void setErrorMessage(String string) {
        if (string == null) {
            this.setLocalizedErrorMessage("");
        } else {
            this.setLocalizedErrorMessage(NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)string));
        }
    }

    private void setLocalizedErrorMessage(String string) {
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    private FileObject getTargetFolderFromGUI(WizardDescriptor wizardDescriptor) {
        assert (this.gui != null);
        File file = new File(this.gui.getTargetFolder());
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            try {
                fileObject = FileUtil.createFolder((File)file);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return fileObject;
    }

    static boolean isValidPackageName(String string) {
        if (string.length() > 0 && string.charAt(0) == '.') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidTypeIdentifier(String string) {
        return Utilities.isJavaIdentifier((String)string);
    }

    static boolean isValidFileName(String string) {
        return string != null && string.length() != 0;
    }

    public static String canUseFileName(String string, String string2, String string3) {
        StringBuffer stringBuffer;
        String string4 = string2;
        if (string2 != null) {
            string2 = string2.replace('.', '/');
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            stringBuffer.append('.');
            stringBuffer.append(string3);
            string2 = stringBuffer.toString();
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string4);
            stringBuffer.append('.');
            stringBuffer.append(string3);
            string4 = stringBuffer.toString();
        }
        if (string == null) {
            return NbBundle.getMessage(RubyTargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        stringBuffer = FileUtil.toFileObject((File)new File(string));
        if (stringBuffer == null) {
            return NbBundle.getMessage(RubyTargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!stringBuffer.canWrite()) {
            return NbBundle.getMessage(RubyTargetChooserPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (RubyTargetChooserPanel.existFileName((FileObject)stringBuffer, "/" + string2)) {
            return NbBundle.getMessage(RubyTargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)string4);
        }
        return null;
    }

    private static boolean existFileName(FileObject fileObject, String string) {
        boolean bl = false;
        File file = FileUtil.toFile((FileObject)fileObject);
        bl = file.exists() ? new File(file, string).exists() : fileObject.getFileObject(string) != null;
        return bl;
    }
}

