/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.Dialog;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.RubyBaseActionProvider;
import org.netbeans.modules.ruby.rubyproject.RunFilePanel;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RunFileActionProvider
implements ActionProvider {
    private static final Map<File, RunFileArgs> ARGS_FOR_FILE = new HashMap<File, RunFileArgs>();

    public String[] getSupportedActions() {
        return new String[]{"run.single", "debug.single"};
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        boolean bl = "debug.single".equals(string);
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
            if (file == null) continue;
            RubyBaseActionProvider.saveFile(dataObject.getPrimaryFile());
            this.runFile(file, bl);
        }
    }

    static RunFileArgs getRunArgs(File file) {
        return ARGS_FOR_FILE.get(file);
    }

    static RunFileArgs showDialog(RunFileArgs runFileArgs, File file, boolean bl, boolean bl2) {
        Object[] objectArray = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
        RunFilePanel runFilePanel = new RunFilePanel(runFileArgs, bl2);
        String string = bl ? "DebugFile" : "RunFile";
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)runFilePanel, NbBundle.getMessage(RunFileActionProvider.class, (String)string, (Object)file.getName()), true, objectArray, DialogDescriptor.OK_OPTION, 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            RunFileArgs runFileArgs2 = runFilePanel.getArgs();
            ARGS_FOR_FILE.put(file, runFileArgs2);
            return runFileArgs2;
        }
        return null;
    }

    private void runFile(File file, boolean bl) {
        RunFileArgs runFileArgs;
        RunFileArgs runFileArgs2 = ARGS_FOR_FILE.get(file);
        if (runFileArgs2 != null && !runFileArgs2.displayDialog) {
            this.doRun(file, runFileArgs2, bl);
            return;
        }
        if (runFileArgs2 == null) {
            runFileArgs2 = new RunFileArgs(null, null, null, null, file.getParent(), true);
        }
        if ((runFileArgs = RunFileActionProvider.showDialog(runFileArgs2, file, bl, true)) == null) {
            return;
        }
        this.doRun(file, runFileArgs, bl);
    }

    private void doRun(File file, RunFileArgs runFileArgs, boolean bl) {
        File file2 = new File(runFileArgs.getWorkDir());
        RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(runFileArgs.getPlatform(), file.getName(), file2);
        if (runFileArgs.getRunArgs() != null) {
            rubyExecutionDescriptor.additionalArgs(Utilities.parseParameters((String)runFileArgs.getRunArgs()));
        }
        rubyExecutionDescriptor.jvmArguments(runFileArgs.getJvmArgs());
        rubyExecutionDescriptor.initialArgs(runFileArgs.getRubyOpts());
        rubyExecutionDescriptor.debug(bl);
        rubyExecutionDescriptor.script(file.getAbsolutePath());
        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor);
        if (rubyProcessCreator.isAbleToCreateProcess()) {
            ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)file.getName()).run();
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        Project project = (Project)lookup.lookup(Project.class);
        if (project != null) {
            return false;
        }
        Collection collection = lookup.lookupAll(DataObject.class);
        if (collection.isEmpty()) {
            return false;
        }
        for (DataObject dataObject : collection) {
            if (dataObject.getPrimaryFile().getMIMEType().equals("text/x-ruby")) continue;
            return false;
        }
        return true;
    }

    static final class RunFileArgs {
        private final RubyPlatform platform;
        private final String runArgs;
        private final String jvmArgs;
        private final String rubyOpts;
        private final String workDir;
        private final boolean displayDialog;

        public RunFileArgs(RubyPlatform rubyPlatform, String string, String string2, String string3, String string4, boolean bl) {
            this.platform = rubyPlatform;
            this.runArgs = string;
            this.jvmArgs = string2;
            this.rubyOpts = string3;
            this.workDir = string4;
            this.displayDialog = bl;
        }

        public String getJvmArgs() {
            return this.jvmArgs;
        }

        public RubyPlatform getPlatform() {
            return this.platform;
        }

        public String getRunArgs() {
            return this.runArgs;
        }

        public boolean displayDialog() {
            return this.displayDialog;
        }

        public String getRubyOpts() {
            return this.rubyOpts;
        }

        public String getWorkDir() {
            return this.workDir;
        }
    }
}

