/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.debug.CommentNode;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentsNode
extends AbstractNode
implements OffsetProvider {
    private List<Comment> comments;

    public CommentsNode(String string, List<Comment> list) {
        super((Children)new ChildrenImpl(list));
        this.comments = list;
        this.setDisplayName(string);
    }

    @Override
    public int getStart() {
        int n = Integer.MAX_VALUE;
        for (Comment comment : this.comments) {
            if (n <= comment.pos()) continue;
            n = comment.pos();
        }
        return n == Integer.MAX_VALUE ? -1 : n;
    }

    @Override
    public int getEnd() {
        int n = -1;
        for (Comment comment : this.comments) {
            if (n >= comment.endPos()) continue;
            n = comment.endPos();
        }
        return n;
    }

    @Override
    public int getPreferredPosition() {
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChildrenImpl
    extends Children.Keys {
        private List<Comment> comments;

        public ChildrenImpl(List<Comment> list) {
            this.comments = list;
        }

        public void addNotify() {
            this.setKeys(this.comments);
        }

        public void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        protected Node[] createNodes(Object object) {
            return new Node[]{new CommentNode((Comment)object)};
        }
    }
}

