/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.settings;

import java.beans.PropertyEditorManager;
import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.builds.ErrorExpression;
import org.netbeans.modules.cnd.builds.ErrorExpressionEditor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class MakeSettings
extends SharedClassObject {
    static final long serialVersionUID = 1276277545941336641L;
    public static final String PROP_DEFAULT_BUILD_DIR = "defaultBuildDirectory";
    public static final String PROP_DEFAULT_MAKE_COMMAND = "defaultMakeCommand";
    public static final String PROP_ERROR_EXPRESSION = "errorExpression";
    public static final String PROP_EXECUTOR = "executor";
    public static final String PROP_REUSE_OUTPUT = "reuseOutput";
    public static final String PROP_SAVE_ALL = "saveAll";
    public static final ErrorExpression SUN_COMPILERS = new ErrorExpression(MakeSettings.getString("LBL_SunErrorName"), MakeSettings.getString("CTL_SunErrorRE"), 1, 2, -1, 3);
    public static final ErrorExpression GNU_COMPILERS = new ErrorExpression(MakeSettings.getString("LBL_GnuErrorName"), MakeSettings.getString("CTL_GnuErrorRE"), 1, 2, -1, 3);
    private static ResourceBundle bundle;

    protected void initialize() {
        super.initialize();
        this.registerPropertyEditors();
        this.setDefaultMakeCommand(MakeSettings.getString("DEFAULT_MAKE_COMMAND_VALUE"));
        this.setReuseOutput(false);
        this.setSaveAll(true);
        if (System.getProperty("os.name", "").toLowerCase().indexOf("sunos") >= 0) {
            this.setErrorExpression(SUN_COMPILERS);
        } else {
            this.setErrorExpression(GNU_COMPILERS);
        }
    }

    public String displayName() {
        return MakeSettings.getString("OPTION_MAKE_SETTINGS_NAME");
    }

    public static MakeSettings getDefault() {
        return (MakeSettings)MakeSettings.findObject(MakeSettings.class, (boolean)true);
    }

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(MakeSettings.class);
        }
        return bundle.getString(string);
    }

    private void registerPropertyEditors() {
        String[] stringArray = PropertyEditorManager.getEditorSearchPath();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = "org.netbeans.modules.cnd.builds";
        PropertyEditorManager.setEditorSearchPath(stringArray2);
        PropertyEditorManager.registerEditor(ErrorExpression.class, ErrorExpressionEditor.class);
    }

    public String getDefaultBuildDirectory() {
        String string = (String)this.getProperty(PROP_DEFAULT_BUILD_DIR);
        if (string == null) {
            return ".";
        }
        return string;
    }

    public void setDefaultBuildDirectory(String string) {
        if (!string.startsWith(File.separator)) {
            String string2 = this.getDefaultBuildDirectory();
            if (!string2.equals(string)) {
                this.putProperty(PROP_DEFAULT_BUILD_DIR, string, true);
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeSettings.getString("MSG_RelBuildPath")));
        }
    }

    public String getDefaultMakeCommand() {
        return (String)this.getProperty(PROP_DEFAULT_MAKE_COMMAND);
    }

    public void setDefaultMakeCommand(String string) {
        this.putProperty(PROP_DEFAULT_MAKE_COMMAND, string);
    }

    public ErrorExpression getErrorExpression() {
        return (ErrorExpression)this.getProperty(PROP_ERROR_EXPRESSION);
    }

    public void setErrorExpression(ErrorExpression errorExpression) {
        this.putProperty(PROP_ERROR_EXPRESSION, errorExpression);
    }

    public boolean getReuseOutput() {
        return (Boolean)this.getProperty(PROP_REUSE_OUTPUT);
    }

    public void setReuseOutput(boolean bl) {
        this.putProperty(PROP_REUSE_OUTPUT, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public boolean getSaveAll() {
        return (Boolean)this.getProperty(PROP_SAVE_ALL);
    }

    public void setSaveAll(boolean bl) {
        this.putProperty(PROP_SAVE_ALL, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_opt_building_make");
    }
}

