/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.util.ArrayList;
import org.netbeans.modules.cnd.makewizard.CompilerFlags;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.OptionSource;
import org.netbeans.modules.cnd.makewizard.StdLibFlags;
import org.netbeans.modules.cnd.utils.MIMESupport;

public final class TargetData {
    private int targetType;
    private String name;
    private String outputDirectory;
    private int key;
    private String[] sourcesList;
    private String[] includesList;
    private StdLibFlags stdLibFlags;
    private String[] userLibsList;
    private String targetName;
    private String dependsOn;
    private String subdirectory;
    private String makeFlags;
    private ArrayList actions;
    private boolean compilable;
    private boolean complex;
    private boolean haveCppFiles;
    private boolean haveCFiles;
    private boolean haveFortranFiles;
    private boolean haveXdFiles;
    private boolean haveAssemblyFiles;
    public static final int SIMPLE_EXECUTABLE = 1;
    public static final int SIMPLE_ARCHIVE = 2;
    public static final int SIMPLE_SHAREDLIB = 3;
    public static final int COMPLEX_EXECUTABLE = 5;
    public static final int COMPLEX_ARCHIVE = 6;
    public static final int COMPLEX_SHAREDLIB = 7;
    public static final int COMPLEX_MAKE_TARGET = 8;
    public static final int COMPLEX_CUSTOM_TARGET = 9;
    private String indent = new String("");

    public TargetData(int n, String string, String string2, int n2) {
        this.targetType = n;
        this.name = string;
        this.outputDirectory = string2;
        this.key = n2;
        this.sourcesList = null;
        this.includesList = null;
        this.stdLibFlags = new StdLibFlags();
        this.userLibsList = null;
        this.targetName = null;
        this.dependsOn = null;
        this.subdirectory = null;
        this.makeFlags = null;
        this.actions = null;
        this.compilable = false;
        this.haveCppFiles = false;
        this.haveCFiles = false;
        this.haveFortranFiles = false;
        this.haveXdFiles = false;
        this.haveAssemblyFiles = false;
        this.compilable = n != 8 && n != 9;
        this.complex = n != 1 && n != 2 && n != 3;
    }

    public TargetData(TargetData targetData) {
        int n;
        this.targetType = targetData.targetType;
        this.name = new String(targetData.name);
        this.outputDirectory = new String(targetData.outputDirectory);
        this.key = targetData.key;
        this.sourcesList = null;
        this.targetName = targetData.targetName;
        this.dependsOn = targetData.dependsOn;
        this.subdirectory = targetData.subdirectory;
        this.makeFlags = targetData.makeFlags;
        this.actions = targetData.actions;
        this.compilable = targetData.compilable;
        this.complex = targetData.complex;
        this.haveCppFiles = false;
        this.haveCFiles = false;
        this.haveFortranFiles = false;
        this.haveXdFiles = false;
        this.haveAssemblyFiles = false;
        if (this.includesList != null) {
            this.includesList = new String[targetData.includesList.length];
            for (n = 0; n < this.includesList.length; ++n) {
                this.includesList[n] = targetData.includesList[n];
            }
        }
        if (this.stdLibFlags != null) {
            this.stdLibFlags = new StdLibFlags(targetData.stdLibFlags);
        }
        if (this.userLibsList != null) {
            this.userLibsList = new String[targetData.userLibsList.length];
            for (n = 0; n < this.userLibsList.length; ++n) {
                this.userLibsList[n] = targetData.userLibsList[n];
            }
        }
    }

    public int getTargetType() {
        return this.targetType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getKey() {
        return this.key;
    }

    public String[] getSourcesList() {
        return this.sourcesList;
    }

    public void setSourcesList(String[] stringArray) {
        this.sourcesList = stringArray;
        this.haveCppFiles = false;
        this.haveCFiles = false;
        this.haveFortranFiles = false;
        this.haveXdFiles = false;
        this.haveAssemblyFiles = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!this.haveCppFiles && this.isCppFile(stringArray[i])) {
                this.haveCppFiles = true;
            }
            if (!this.haveCFiles && this.isCFile(stringArray[i])) {
                this.haveCFiles = true;
            }
            if (!this.haveFortranFiles && this.isFortranFile(stringArray[i])) {
                this.haveFortranFiles = true;
            }
            if (!this.haveXdFiles && this.isXdFile(stringArray[i])) {
                this.haveXdFiles = true;
            }
            if (this.haveAssemblyFiles || !this.isAssemblyFile(stringArray[i])) continue;
            this.haveAssemblyFiles = true;
        }
    }

    public boolean isComplete() {
        if (this.targetType == 8 && (this.targetName != null || this.dependsOn != null || this.subdirectory != null || this.makeFlags != null)) {
            return true;
        }
        if (this.targetType == 9 && this.actions != null && this.actions.size() > 0) {
            return true;
        }
        return this.sourcesList != null && this.sourcesList.length > 0;
    }

    public String[] getIncludesList() {
        return this.includesList;
    }

    public void setIncludesList(String[] stringArray) {
        this.includesList = stringArray;
    }

    public String[] getUserLibsList() {
        return this.userLibsList;
    }

    public void setUserLibsList(String[] stringArray) {
        this.userLibsList = stringArray;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String string) {
        String string2 = MakefileWizard.getMakefileWizard().getMakefileData().getBaseDirectory();
        this.outputDirectory = string.startsWith(string2) && string.length() > string2.length() ? string.substring(string2.length() + 1) : string;
    }

    public StdLibFlags getStdLibFlags() {
        return this.stdLibFlags;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String string) {
        this.targetName = string;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String string) {
        this.dependsOn = string;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public void setSubdirectory(String string) {
        this.subdirectory = string;
    }

    public String getMakeFlags() {
        return this.makeFlags;
    }

    public void setMakeFlags(String string) {
        this.makeFlags = string;
    }

    public ArrayList getActions() {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        return this.actions;
    }

    public void setActions(ArrayList arrayList) {
        this.actions = arrayList;
    }

    public boolean isConvertable(int n) {
        return this.targetType == 1 && n == 5 || this.targetType == 2 && n == 6 || this.targetType == 3 && n == 7 || this.targetType == 5 && n == 1 || this.targetType == 6 && n == 2 || this.targetType == 7 && n == 3;
    }

    public void convert() {
        CompilerFlags compilerFlags = MakefileWizard.getMakefileWizard().getMakefileData().getCompilerFlags();
        switch (this.targetType) {
            case 1: {
                this.targetType = 5;
                break;
            }
            case 2: {
                this.targetType = 6;
                break;
            }
            case 3: {
                this.targetType = 7;
            }
        }
        if (compilerFlags.isSimpleDebug()) {
            compilerFlags.setOptionSource(OptionSource.DEVELOPMENT);
            compilerFlags.setDevelDebug(true);
        } else if (compilerFlags.isSimpleOptimize()) {
            compilerFlags.setOptionSource(OptionSource.FINAL);
            compilerFlags.setFinalOptimize(true);
        }
    }

    public void convert(int n) {
        CompilerFlags compilerFlags = MakefileWizard.getMakefileWizard().getMakefileData().getCompilerFlags();
        this.targetType = n;
        if (compilerFlags.getOptionSource() == OptionSource.FINAL) {
            compilerFlags.setSimpleOptimize(compilerFlags.isFinalOptimize());
        } else {
            compilerFlags.setSimpleDebug(true);
            compilerFlags.setSimpleOptimize(!compilerFlags.isDevelDebug());
        }
    }

    public boolean isExecutable() {
        return this.targetType == 1 || this.targetType == 5;
    }

    public boolean isArchive() {
        return this.targetType == 2 || this.targetType == 6;
    }

    public boolean isSharedLib() {
        return this.targetType == 3 || this.targetType == 7;
    }

    public boolean isMakeTarget() {
        return this.targetType == 8;
    }

    public boolean isCustomTarget() {
        return this.targetType == 9;
    }

    public boolean isCppFile(String string) {
        return "text/x-c++".equals(MIMESupport.getKnownMIMETypeByExtension((String)string));
    }

    public boolean isCFile(String string) {
        return "text/x-c".equals(MIMESupport.getKnownMIMETypeByExtension((String)string));
    }

    public boolean isHdrFile(String string) {
        return "text/x-h".equals(MIMESupport.getKnownMIMETypeByExtension((String)string));
    }

    public boolean isFortranFile(String string) {
        return "text/x-fortran".equals(MIMESupport.getKnownMIMETypeByExtension((String)string));
    }

    public boolean isXdFile(String string) {
        return string.endsWith(".xd");
    }

    public boolean isAssemblyFile(String string) {
        return "text/x-asm".equals(MIMESupport.getKnownMIMETypeByExtension((String)string));
    }

    public boolean isComplex() {
        return this.complex;
    }

    public boolean isLinked() {
        return this.targetType == 1 || this.targetType == 5 || this.targetType == 3 || this.targetType == 7;
    }

    public boolean isCompilable() {
        return this.compilable;
    }

    public boolean containsCppFiles() {
        return this.haveCppFiles;
    }

    public boolean containsCFiles() {
        return this.haveCFiles;
    }

    public boolean containsFortranFiles() {
        return this.haveFortranFiles;
    }

    public boolean containsXdFiles() {
        return this.haveXdFiles;
    }

    public boolean containsAssemblyFiles() {
        return this.haveAssemblyFiles;
    }

    public void dump() {
        int n;
        this.println("    name            = \"" + this.name + "\"");
        this.println("    type            = " + (this.targetType == 1 ? "SIMPLE_EXECUTABLE" : (this.targetType == 2 ? "SIMPLE_ARCHIVE" : (this.targetType == 3 ? "SIMPLE_SHAREDLIB" : (this.targetType == 5 ? "COMPLEX_EXECUTABLE" : (this.targetType == 6 ? "COMPLEX_ARCHIVE" : (this.targetType == 7 ? "COMPLEX_SHAREDLIB" : (this.targetType == 8 ? "COMPLEX_MAKE_TARGET" : (this.targetType == 9 ? "COMPLEX_CUSTOM_TARGET" : "Unknown")))))))));
        this.println("    key             = " + this.key);
        this.println("    outputDirectory = \"" + this.outputDirectory + "\"");
        if (this.sourcesList == null || this.sourcesList.length == 0) {
            this.println("    sourcesList     = {}");
        } else {
            this.println("    sourcesList     = {");
            for (n = 0; n < this.sourcesList.length; ++n) {
                this.println("        \"" + this.sourcesList[n] + "\"");
            }
            this.println("    }");
        }
        if (this.includesList == null || this.includesList.length == 0) {
            this.println("    includesList    = {}");
        } else {
            this.println("    includesList    = {");
            for (n = 0; n < this.includesList.length; ++n) {
                this.println("        \"" + this.includesList[n] + "\"");
            }
            this.println("    }");
        }
        this.stdLibFlags.dump();
        if (this.userLibsList == null || this.userLibsList.length == 0) {
            this.println("    userLibsList    = {}");
        } else {
            this.println("    userLibsList    = {");
            for (n = 0; n < this.userLibsList.length; ++n) {
                this.println("        \"" + this.userLibsList[n] + "\"");
            }
            this.println("    }");
        }
        this.println("    targetName      = \"" + this.targetName + "\"");
        this.println("    dependsOn       = \"" + this.dependsOn + "\"");
        this.println("    subdirectory    = \"" + this.subdirectory + "\"");
        this.println("    makeFlags       = \"" + this.makeFlags + "\"");
        if (this.actions == null || this.actions.size() == 0) {
            this.println("    actions         = {}");
        } else {
            this.println("    actions         = {");
            for (n = 0; n < this.actions.size(); ++n) {
                this.println("        " + this.actions.get(n).toString());
            }
            this.println("    }");
        }
    }

    public void dump(String string) {
        this.setIndent(string);
        this.dump();
    }

    private void println(String string) {
        System.out.println(this.indent + string);
    }

    private void setIndent(String string) {
        this.indent = string;
    }
}

