/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.utils.FortranParser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.CompilerFlags;
import org.netbeans.modules.cnd.makewizard.MakefileData;
import org.netbeans.modules.cnd.makewizard.StdLibFlags;
import org.netbeans.modules.cnd.makewizard.TargetData;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class MakefileGenerator {
    private MakefileData md;
    private File fmakefile;
    private BufferedWriter out;
    private MakeVarName var;
    private boolean status;
    private boolean doComplex;
    private boolean doC;
    private boolean doCpp;
    private boolean doFortran;
    private boolean doXd;
    private boolean doAssembly;
    private StringBuffer buf;
    private ResourceBundle bundle;
    private static final int OK = 0;
    private static final int BAD = 1;
    private static final String LINE1 = new String("## -*- Makefile -*-");
    private static final String BLANKCOMMENT = new String("##");
    private static final String LINE_PREFIX = new String("## ");
    private static final String SUFFIX_LIST = new String(".o .c .c~ .cc .cc~ .y .y~ .l .l~ .s .s~ .sh .sh~ .S .S~ .ln .h .h~ .f .f~ .F .F~ .p .p~ .r .r~ .f90 .f90~ .ftn .ftn~ .cps .cps~ .C .C~ .Y .Y~ .L .L~ .java .java~ .class");

    public MakefileGenerator(MakefileData makefileData) {
        this.md = makefileData;
        this.bundle = null;
        this.out = null;
        this.doComplex = false;
        this.doCpp = false;
        this.doC = false;
        this.doFortran = false;
        this.doXd = false;
        this.doAssembly = false;
        this.buf = new StringBuffer(1024);
        this.var = new MakeVarName();
    }

    public boolean generate() {
        this.status = false;
        if (this.initialize()) {
            try {
                this.prolog();
                this.compilerSetup();
                this.generateTargetDirectories();
                this.defaultTarget();
                List<TargetData> list = this.md.getTargetList();
                for (int i = 0; i < list.size(); ++i) {
                    this.generateTarget(list.get(i));
                }
                this.finale();
            }
            catch (MakefileGenerationException makefileGenerationException) {
                return false;
            }
            catch (IOException iOException) {
                if (IpeUtils.IfdefDiagnostics) {
                    System.out.println("Failure in Makefile Generation");
                }
                this.fmakefile.delete();
                String string = this.getString("MSG_MakefileOutputError");
                String string2 = this.getString("TITLE_MakefileOutputError");
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, string2, 2, 0, new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION);
                Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
                return !object.equals(NotifyDescriptor.OK_OPTION);
            }
        }
        return this.status;
    }

    private boolean initialize() {
        String string;
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(MakefileGenerator.class);
        }
        String string2 = this.getString("DLG_ErrorDialogTitle");
        this.checkTargetFlags();
        if (this.validateOrCreateCwd() != 0 || this.validateOrCreateMakefileDir() != 0) {
            return false;
        }
        if (this.fmakefile.exists() && this.fmakefile.length() > 0L) {
            if (this.fmakefile.canRead()) {
                string = null;
                if (!MakefileGenerator.generatedMakefile(this.fmakefile)) {
                    string = MessageFormat.format(this.getString("MSG_NonGeneratedMakefile"), this.md.getMakefileName());
                }
            } else {
                string = MessageFormat.format(this.getString("MSG_CannotReadMakefile"), this.md.getMakefileName());
            }
            if (string != null) {
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, string2, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                DialogDisplayer.getDefault().notify(notifyDescriptor);
                return false;
            }
        }
        if (this.targetIsIncomplete()) {
            string = MessageFormat.format(this.getString("MSG_TargetIsIncomplete"), this.md.getMakefileName());
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, string2, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
            return false;
        }
        try {
            this.out = new BufferedWriter(new FileWriter(this.fmakefile));
        }
        catch (IOException iOException) {
            string = MessageFormat.format(this.getString("MSG_CannotCreateMakefile"), this.md.getMakefileName());
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, string2, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
            return false;
        }
        return true;
    }

    private void compilerSetup() throws IOException {
        if (this.out != null && (this.doC || this.doXd || this.doCpp || this.doFortran || this.doAssembly)) {
            String string;
            String string2 = this.getString("MFG_CompilerFlags");
            this.out.write(string2, 0, string2.length());
            if (this.doC || this.doXd || this.doAssembly) {
                this.buf.delete(0, this.buf.length());
                this.appendToolsetDepMacro("CC", this.md.getCCompilerSun(), this.md.getCCompilerGNU());
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doCpp || this.doXd) {
                this.buf.delete(0, this.buf.length());
                this.appendMacro("CCC", this.md.getCppCompiler(this.md.getToolset()));
                this.appendMacro("CXX", this.md.getCppCompiler(this.md.getToolset()));
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doFortran) {
                this.buf.delete(0, this.buf.length());
                this.appendToolsetDepMacro("FC", this.md.getFCompilerSun(), this.md.getFCompilerGNU());
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doAssembly) {
                this.buf.replace(0, this.buf.length(), "AS=");
                this.buf.append(this.md.getAsmPath());
                this.buf.append('\n');
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            CompilerFlags compilerFlags = this.md.getCompilerFlags();
            if (this.doC || this.doCpp || this.doFortran) {
                this.buf.delete(0, this.buf.length());
                this.appendToolsetDepMacro("BASICOPTS", compilerFlags.getBasicOptionsSun(), compilerFlags.getBasicOptionsGNU());
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doC) {
                this.buf.delete(0, this.buf.length());
                string = compilerFlags.getCFlagsSun();
                String string3 = compilerFlags.getCFlagsGNU();
                this.appendToolsetDepMacro("CFLAGS", string, string3);
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doCpp) {
                this.buf.delete(0, this.buf.length());
                string = compilerFlags.getCcFlags(this.md.getToolset());
                this.appendMacro("CCFLAGS", string);
                this.appendMacro("CXXFLAGS", string);
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.buf.delete(0, this.buf.length());
                this.appendToolsetDepMacro("CCADMIN", "CCadmin -clean", "");
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doXd) {
                this.buf.replace(0, this.buf.length(), "XDESIGNER=xdesigner");
                this.buf.append(" -xrm \"xdesigner.cDebugFlags: $(CFLAGS)\" ");
                this.buf.append("-xrm \"xdesigner.cppDebugFlags: $(CCFLAGS)\"\n");
                this.buf.append("XDROOT=");
                this.buf.append(System.getProperty("netbeans.home"));
                this.buf.append("/platform/$(OSVARIANT)/prod");
                this.buf.append("\nXDFLAGS = $(MAKEFLAGS) ");
                this.buf.append("XDROOT=$(XDROOT) CC=$(CC) CCC=$(CCC) ");
                if (this.md.getConformLevelCppSun() != 0) {
                    this.buf.append("ABICCFLAGS=-features=no%conststrings");
                }
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.out.newLine();
            }
            if (this.doFortran) {
                this.buf.delete(0, this.buf.length());
                this.appendMacro("FFLAGS", compilerFlags.getF90Flags());
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            this.out.newLine();
            this.out.newLine();
        }
    }

    private void defaultTarget() throws IOException {
        if (this.out != null) {
            List<TargetData> list = this.md.getTargetList();
            this.buf.replace(0, this.buf.length(), "all:");
            for (int i = 0; i < list.size(); ++i) {
                TargetData targetData = list.get(i);
                this.buf.append(" ");
                String string = this.getOutputDirectory(targetData);
                if (targetData.isCompilable() && string.length() > 0 && !string.equals(".")) {
                    this.var.setTargetName(targetData.getName());
                    this.buf.append(this.var.makeRef("TARGETDIR_"));
                    this.buf.append("/");
                } else if (targetData.getName().compareTo("all") == 0) {
                    this.buf.delete(0, this.buf.length());
                    return;
                }
                this.buf.append(targetData.getName());
            }
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.out.newLine();
            this.out.newLine();
        }
    }

    private void prolog() throws IOException {
        if (this.out != null) {
            int n;
            this.out.write(LINE1, 0, LINE1.length());
            this.out.newLine();
            this.out.write(BLANKCOMMENT, 0, BLANKCOMMENT.length());
            this.out.newLine();
            this.buf.replace(0, this.buf.length(), this.getString("MFG_User"));
            this.buf.append(this.getUserName());
            this.buf.append('\n');
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.buf.replace(0, this.buf.length(), this.getString("MFG_Time"));
            this.buf.append(this.getTimestamp());
            this.buf.append('\n');
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.buf.replace(0, this.buf.length(), this.getString("MFG_CreateMsg"));
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.out.write(BLANKCOMMENT, 0, BLANKCOMMENT.length());
            this.out.newLine();
            this.buf.replace(0, this.buf.length(), this.getString("MFG_DoNotEditMsg"));
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.out.write(BLANKCOMMENT, 0, BLANKCOMMENT.length());
            this.out.newLine();
            if (this.doFortran) {
                this.buf.replace(0, this.buf.length(), this.getString("MFG_SuffixList"));
                this.buf.append(".SUFFIXES\n");
                this.buf.append(".SUFFIXES: ");
                this.buf.append(SUFFIX_LIST);
                this.out.newLine();
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.out.newLine();
            }
            if (this.md.getToolset() == 2) {
                this.buf = new StringBuffer(1024);
                this.buf.append("# Type of makefile: SUN, GNU, ...\n");
                this.buf.append("TOOLSET\t= $(shell echo \"GNU\")\n");
                this.buf.append("TOOLSET:sh\t= echo `echo \"SUN\"`\n");
                this.out.newLine();
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            List<TargetData> list = this.md.getTargetList();
            boolean bl = false;
            boolean bl2 = false;
            for (n = 0; n < list.size(); ++n) {
                TargetData targetData = list.get(n);
                if (targetData.getOutputDirectory().equals(this.getString("OutputDirectoryPlatform"))) {
                    bl = true;
                }
                if (targetData.getTargetType() != 3 && targetData.getTargetType() != 7) continue;
                bl2 = true;
            }
            if (bl || bl2 && this.md.getMakefileOS() == 2) {
                this.buf = new StringBuffer(1024);
                this.buf.append("# OS: SunOS, Linux, ...`\n");
                n = this.md.getToolset();
                if (n == 1 || n == 2) {
                    this.buf.append("OS\t\t= $(shell /bin/uname)\n");
                }
                if (n == 0 || n == 2) {
                    this.buf.append("OS:sh\t\t= echo `/bin/uname`\n");
                }
                this.out.newLine();
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (bl) {
                this.buf = new StringBuffer(1024);
                this.buf.append("# Processor type: sparc, i686, ...\n");
                n = this.md.getToolset();
                if (n == 1 || n == 2) {
                    this.buf.append("PROCESSOR\t= $(shell /bin/uname -p)\n");
                }
                if (n == 0 || n == 2) {
                    this.buf.append("PROCESSOR:sh\t= echo `/bin/uname -p``\n");
                }
                this.out.newLine();
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.buf = new StringBuffer(1024);
                this.buf.append("# Platform\n");
                this.buf.append("PLATFORM\t= $(OS)-$(PROCESSOR)\n");
                this.out.newLine();
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            this.out.newLine();
            this.out.newLine();
        }
    }

    private void generateTargetDirectories() throws IOException {
        List<TargetData> list = this.md.getTargetList();
        if (this.doC || this.doXd || this.doCpp || this.doFortran || this.doAssembly) {
            String string = this.getString("MFG_TargetDirectories");
            this.out.write(string, 0, string.length());
            for (int i = 0; i < list.size(); ++i) {
                TargetData targetData = list.get(i);
                if (!targetData.isCompilable()) continue;
                String string2 = this.getOutputDirectory(targetData);
                String string3 = this.md.getBaseDirectory(true);
                this.buf.replace(0, this.buf.length(), "TARGETDIR_");
                this.buf.append(targetData.getName());
                this.buf.append("=");
                String string4 = this.getOutputDirectory(targetData);
                if (string4.length() == 0 || string4.equals(string3) || string4.length() == 1 && string4.charAt(0) == '.') {
                    this.buf.append(new String(".\n"));
                } else {
                    this.buf.append(string4);
                    this.buf.append('\n');
                }
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            this.out.newLine();
            this.out.newLine();
        }
    }

    private void generateTarget(TargetData targetData) throws IOException, MakefileGenerationException {
        if (this.out != null) {
            this.var.setTargetName(targetData.getName());
            this.buf.replace(0, this.buf.length(), this.getString("MFG_Target"));
            this.buf.append(targetData.getName());
            this.buf.append('\n');
            this.out.write(this.buf.toString(), 0, this.buf.length());
            if (targetData.isCompilable()) {
                this.targetSetup(targetData);
                this.linkOrArchive(targetData);
                this.explicitRules(targetData);
            } else {
                this.makeTarget(targetData);
            }
        }
    }

    private void finale() throws IOException {
        if (this.out != null) {
            Iterator iterator;
            int n;
            List<TargetData> list = this.md.getTargetList();
            String string = this.md.getBaseDirectory(true);
            HashSet hashSet = new HashSet(list.size(), 1.0f);
            StringBuilder stringBuilder = new StringBuilder(1024);
            boolean bl = false;
            for (n = 0; n < list.size(); ++n) {
                iterator = list.get(n);
                this.var.setTargetName(((TargetData)((Object)iterator)).getName());
                String string2 = this.getOutputDirectory((TargetData)((Object)iterator));
                if (((TargetData)((Object)iterator)).isCompilable() && string2.length() > 0 && !string2.equals(".") && !string2.equals(string)) {
                    hashSet.add(iterator);
                }
                if (((TargetData)((Object)iterator)).getTargetType() != 8 && ((TargetData)((Object)iterator)).getTargetType() != 9) {
                    stringBuilder.append(" \\\n\t\t");
                    stringBuilder.append(this.var.makeRef("TARGETDIR_"));
                    stringBuilder.append('/');
                    stringBuilder.append(((TargetData)((Object)iterator)).getName());
                    String[] stringArray = ((TargetData)((Object)iterator)).getSourcesList();
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string3;
                        if (((TargetData)((Object)iterator)).isHdrFile(stringArray[i]) || ((TargetData)((Object)iterator)).isXdFile(stringArray[i]) || (string3 = this.objectOf(stringArray[i])) == null) continue;
                        stringBuilder.append(" \\\n\t\t");
                        stringBuilder.append(this.var.makeRef("TARGETDIR_"));
                        stringBuilder.append('/');
                        stringBuilder.append(string3);
                    }
                    continue;
                }
                if (((TargetData)((Object)iterator)).getName().compareTo("clean") != 0) continue;
                bl = true;
            }
            n = 0;
            if (stringBuilder.length() > 0) {
                n = 1;
                iterator = this.getString("MFG_CleanTarget");
                this.out.write((String)((Object)iterator), 0, ((String)((Object)iterator)).length());
                this.buf.replace(0, this.buf.length(), "clean:\n\trm -f");
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.out.write(stringBuilder.toString(), 0, stringBuilder.length());
                this.out.write(10);
            }
            if (hashSet.size() > 0) {
                if (n != 0 && this.doCpp) {
                    this.buf.replace(0, this.buf.length(), "\t$(CCADMIN)\n");
                    this.out.write(this.buf.toString(), 0, this.buf.length());
                }
                stringBuilder.delete(0, stringBuilder.length());
                if (n != 0 && this.doFortran) {
                    this.buf.replace(0, this.buf.length(), "\trm -f *.mod\n");
                    this.out.write(this.buf.toString(), 0, this.buf.length());
                }
                this.buf.replace(0, this.buf.length(), this.getString("MFG_CreateTargetDir"));
                for (TargetData targetData : hashSet) {
                    this.var.setTargetName(targetData.getName());
                    stringBuilder.append("\trm -f -r ");
                    stringBuilder.append(this.var.makeRef("TARGETDIR_"));
                    stringBuilder.append('\n');
                    this.buf.append(this.var.makeRef("TARGETDIR_"));
                    this.buf.append(":\n\tmkdir -p ");
                    this.buf.append(this.var.makeRef("TARGETDIR_"));
                    this.buf.append("\n");
                }
                if (n != 0) {
                    stringBuilder.append("\n\n");
                    this.out.write(stringBuilder.toString(), 0, stringBuilder.length());
                }
                this.buf.append("\n\n");
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (n == 0 && !bl) {
                iterator = this.getString("MFG_CleanTarget");
                this.out.write((String)((Object)iterator), 0, ((String)((Object)iterator)).length());
                this.buf.replace(0, this.buf.length(), "clean:\n\n");
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            this.buf.replace(0, this.buf.length(), this.getString("MFG_KeepState"));
            this.buf.append(".KEEP_STATE:\n");
            this.buf.append(".KEEP_STATE_FILE:.make.state." + this.md.defaultOutputDirectory() + "\n");
            this.buf.append("\n");
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.status = true;
            this.out.close();
            this.out = null;
        }
    }

    private void targetSetup(TargetData targetData) throws IOException, MakefileGenerationException {
        if (this.out != null) {
            String string;
            int n;
            CharSequence charSequence;
            String[] stringArray;
            String string2 = targetData.getName();
            String string3 = this.generateTargetFlags(targetData);
            if (string3.length() > 0) {
                this.out.write(string3, 0, string3.length());
            }
            if ((stringArray = targetData.getIncludesList()) != null && stringArray.length > 0) {
                charSequence = this.doList(this.var.makeName("CPPFLAGS_"), "-I", stringArray);
                this.out.write((String)charSequence, 0, ((String)charSequence).length());
            }
            charSequence = new StringBuilder(80);
            ((StringBuilder)charSequence).append(" \\\n\t");
            ((StringBuilder)charSequence).append(this.var.makeRef("TARGETDIR_"));
            ((StringBuilder)charSequence).append('/');
            String string4 = ((StringBuilder)charSequence).toString();
            this.buf.replace(0, this.buf.length(), this.var.makeName("OBJS_"));
            this.buf.append(" = ");
            String[] stringArray2 = this.doFortran && this.md.isModuleEnabled() ? this.getOrderedSources(targetData) : targetData.getSourcesList();
            for (n = 0; n < stringArray2.length; ++n) {
                if (targetData.isHdrFile(stringArray2[n]) || targetData.isXdFile(stringArray2[n]) || (string = this.objectOf(stringArray2[n])) == null) continue;
                this.buf.append(string4);
                this.buf.append(string);
            }
            this.buf.append('\n');
            this.out.write(this.buf.toString(), 0, this.buf.length());
            if (targetData.isLinked() && (targetData.isComplex() || targetData.containsXdFiles())) {
                String string5;
                String string6;
                n = 0;
                string = this.getSysLibs(targetData);
                if (string.length() > 0) {
                    this.out.write(string, 0, string.length());
                    n = 1;
                }
                if ((string6 = this.getUserLibs(targetData)).length() > 0) {
                    this.out.write(string6, 0, string6.length());
                    n = 1;
                }
                if ((string5 = this.getDependLibs(targetData)).length() > 0) {
                    this.out.write(string5, 0, string5.length());
                }
                if (n != 0) {
                    this.buf.replace(0, this.buf.length(), this.var.makeName("LDLIBS_"));
                    this.buf.append(" = ");
                    this.buf.append(this.var.makeRef("USERLIBS_"));
                    this.buf.append('\n');
                    this.out.write(this.buf.toString(), 0, this.buf.length());
                }
            }
            this.out.newLine();
            this.out.newLine();
            if (targetData.containsXdFiles()) {
                String string7 = this.generateXdTargetVars(targetData);
                this.out.write(string7, 0, string7.length());
                this.out.newLine();
            }
        }
    }

    private String generateXdTargetVars(TargetData targetData) {
        this.buf.replace(0, this.buf.length(), this.getString("MFG_XDesignerTargetVars"));
        String[] stringArray = targetData.getSourcesList();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!targetData.isXdFile(stringArray[i])) continue;
            this.xdTargetFile(targetData, stringArray[i]);
        }
        return this.buf.toString();
    }

    private void xdTargetFile(TargetData targetData, String string) {
        String string2 = this.getXdTargetName(targetData, string);
        this.buf.append("XDMAKEFILE_");
        this.buf.append(string2);
        this.buf.append(" = ");
        this.buf.append(string2);
        this.buf.append("_Makefile\nXD_OBJS_FILE_");
        this.buf.append(string2);
        this.buf.append(" = xd_objs_");
        this.buf.append(string2);
        this.buf.append("\nXD_OBJS_");
        this.buf.append(string2);
        this.buf.append(" = `/bin/cat -s ");
        this.buf.append(this.getOutputDirectory(targetData));
        this.buf.append("/xd_objs_");
        this.buf.append(string2);
        this.buf.append(" | \\\n\tawk 'BEGIN { RS=\" \"} {if (NF > 0) { print \"");
        this.buf.append(this.var.makeRef("TARGETDIR_"));
        this.buf.append("/\" $$0 }}'`\nXD_LINK_ARGS_FILE_");
        this.buf.append(string2);
        this.buf.append(" = xd_link_args_");
        this.buf.append(string2);
        this.buf.append("\nXD_LINK_ARGS_");
        this.buf.append(string2);
        this.buf.append(" = `/bin/cat -s ");
        this.buf.append(this.getOutputDirectory(targetData));
        this.buf.append("/xd_link_args_");
        this.buf.append(string2);
        this.buf.append("; exit 0`\nXDFLAGS_");
        this.buf.append(string2);
        this.buf.append(" = -f $(XDMAKEFILE_");
        this.buf.append(string2);
        this.buf.append(") $(XDFLAGS)\n\n");
    }

    private String getXdTargetName(TargetData targetData, String string) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(targetData.getName());
        stringBuffer.append('_');
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '.' || string.charAt(i) == '/') {
                stringBuffer.append('_');
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private void linkOrArchive(TargetData targetData) throws IOException {
        int n = targetData.getTargetType();
        if (this.out != null && n != 8 && n != 9) {
            this.out.write(this.getString("MFG_LinkOrArchive"));
            this.buf.replace(0, this.buf.length(), this.var.makeRef("TARGETDIR_"));
            this.buf.append('/');
            this.buf.append(targetData.getName());
            this.buf.append(": ");
            this.buf.append(this.var.makeRef("TARGETDIR_"));
            this.buf.append(' ');
            this.buf.append(this.var.makeRef("OBJS_"));
            if (n == 5 || n == 7) {
                this.buf.append(' ');
                this.buf.append(this.var.makeRef("DEPLIBS_"));
            }
            if (targetData.containsXdFiles()) {
                this.buf.append(this.xdLinkDependencies(targetData));
            }
            this.buf.append('\n');
            this.buf.append('\t');
            switch (n) {
                case 1: 
                case 5: {
                    this.buf.append(this.linkLine(targetData, 1));
                    break;
                }
                case 2: 
                case 6: {
                    if (targetData.containsCppFiles()) {
                        StringBuffer stringBuffer = new StringBuffer(1024);
                        this.appendToolsetDepMacro(stringBuffer, "ARCPP", "$(CCC) -xar -o $@ ", "$(AR) $(ARFLAGS) $@ ");
                        this.out.write(stringBuffer.toString(), 0, stringBuffer.length());
                        this.buf.append("$(ARCPP) ");
                    } else {
                        this.buf.append("$(AR) $(ARFLAGS) $@ ");
                    }
                    this.buf.append(this.var.makeRef("OBJS_"));
                    this.buf.append('\n');
                    break;
                }
                case 3: 
                case 7: {
                    this.buf.append(this.linkLine(targetData, n));
                }
            }
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.out.newLine();
            this.out.newLine();
        }
    }

    private void explicitRules(TargetData targetData) throws IOException {
        if (this.out != null) {
            int n;
            String string = this.getString("MFG_CompileRuleComment");
            this.out.write(string, 0, string.length());
            String[] stringArray = targetData.getSourcesList();
            for (n = 0; n < stringArray.length; ++n) {
                this.compileLine(targetData, stringArray[n]);
            }
            this.out.newLine();
            this.out.newLine();
            if (targetData.containsXdFiles()) {
                string = this.getString("MFG_XDesignerCompileRule");
                this.out.write(string, 0, string.length());
                this.buf.delete(0, this.buf.length());
                for (n = 0; n < stringArray.length; ++n) {
                    if (!targetData.isXdFile(stringArray[n])) continue;
                    this.buf.append(this.xdCompile(targetData, stringArray[n]));
                }
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.out.newLine();
                this.out.newLine();
            }
        }
    }

    private String xdCompile(TargetData targetData, String string) {
        String string2 = this.getXdTargetName(targetData, string);
        String string3 = MessageFormat.format("$(TARGETDIR_{0})/$(XDMAKEFILE_{1}): $(TARGETDIR_{0}) {2}\n\t$(XDESIGNER) -m $(TARGETDIR_{0})/$(XDMAKEFILE_{1}) {2}\n\n", targetData.getName(), string2, string);
        String string4 = MessageFormat.format("$(TARGETDIR_{0})/$(XD_OBJS_FILE_{1}): $(TARGETDIR_{0}) $(TARGETDIR_{0})/$(XDMAKEFILE_{1}) {2}\n\t$(XDESIGNER) -G $(TARGETDIR_{0}) {2}\n", targetData.getName(), string2, string);
        String string5 = MessageFormat.format("\tcd $(TARGETDIR_{0}); $(MAKE) $(XDFLAGS_{1}) info-objects > $(XD_OBJS_FILE_{1})\n\tcd $(TARGETDIR_{0}); $(MAKE) $(XDFLAGS_{1}) info-link > $(XD_LINK_ARGS_FILE_{1})\n\tcd $(TARGETDIR_{0}); $(MAKE) $(XDFLAGS_{1}) all-objects\ntest::\n\n", targetData.getName(), string2, string);
        return new StringBuilder(1024).append(string3).append(string4).append(string5).toString();
    }

    private void makeTarget(TargetData targetData) throws IOException {
        this.buf.replace(0, this.buf.length(), targetData.getName());
        this.buf.append(": ");
        String string = targetData.getDependsOn();
        if (string != null && string.length() > 0) {
            this.buf.append(string);
        }
        this.buf.append('\n');
        if (targetData.getTargetType() == 8) {
            String string2;
            String string3 = targetData.getSubdirectory();
            if (string3 != null && string3.length() > 0) {
                this.buf.append("\tcd ");
                this.buf.append(string3);
                this.buf.append("; $(MAKE) ");
            } else {
                this.buf.append("\t$(MAKE) ");
            }
            String string4 = targetData.getMakeFlags();
            if (string4 != null && string4.length() > 0) {
                this.buf.append(string4);
                this.buf.append(' ');
            }
            if ((string2 = targetData.getTargetName()) != null && string2.length() > 0) {
                this.buf.append(string2);
            }
            this.buf.append('\n');
        } else {
            String string5;
            ArrayList arrayList = targetData.getActions();
            for (int i = 0; i < arrayList.size() && (string5 = arrayList.get(i).toString().trim()).length() != 0; ++i) {
                this.buf.append('\t');
                this.buf.append(string5);
                this.buf.append('\n');
            }
        }
        this.buf.append("\n\n");
        this.out.write(this.buf.toString(), 0, this.buf.length());
    }

    private void compileLine(TargetData targetData, String string) throws IOException {
        String string2;
        String string3;
        if (targetData.isCppFile(string)) {
            string3 = "$(COMPILE.cc)";
            string2 = "CCFLAGS_";
        } else if (targetData.isCFile(string)) {
            string3 = "$(COMPILE.c)";
            string2 = "CFLAGS_";
        } else if (targetData.isFortranFile(string)) {
            string3 = "$(COMPILE.f)";
            string2 = "FFLAGS_";
        } else {
            if (targetData.isHdrFile(string)) {
                return;
            }
            if (targetData.isXdFile(string)) {
                return;
            }
            if (targetData.isAssemblyFile(string)) {
                string3 = "$(AS)";
                string2 = "ASFLAGS_";
            } else {
                if (IpeUtils.IfdefDiagnostics) {
                    System.out.println("Generator: Can't determine language of " + string);
                }
                return;
            }
        }
        String string4 = this.objectOf(string);
        if (string4 == null) {
            return;
        }
        this.buf.replace(0, this.buf.length(), this.var.makeRef("TARGETDIR_"));
        this.buf.append('/');
        this.buf.append(string4);
        this.buf.append(": ");
        this.buf.append(this.var.makeRef("TARGETDIR_"));
        this.buf.append(' ');
        this.buf.append(string);
        this.buf.append("\n\t");
        this.buf.append(string3);
        this.buf.append(' ');
        this.buf.append(this.var.makeRef(string2));
        this.buf.append(' ');
        this.buf.append(this.var.makeRef("CPPFLAGS_"));
        this.buf.append(" -o $@ ");
        this.buf.append(string);
        this.buf.append("\n\n");
        this.out.write(this.buf.toString(), 0, this.buf.length());
    }

    /*
     * WARNING - void declaration
     */
    private String[] getOrderedSources(TargetData targetData) throws MakefileGenerationException {
        String string;
        Object object;
        String[] stringArray = targetData.getSourcesList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        LinkedList<FortranFile> linkedList = new LinkedList<FortranFile>();
        String string2 = this.md.getCompilerFlags().getF90Flags();
        HashMap<String, void> hashMap = new HashMap<String, void>();
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (this.isFortranFile(string3)) {
                Object object2;
                void object22;
                ArrayList<String> arrayList2;
                if (string3.charAt(0) != '/') {
                    String bl3 = this.md.getBaseDirectory() + File.separator + string3;
                }
                if ((arrayList2 = ((FortranParser)(object = new FortranParser((String)object22, string2, true, true))).parser()) == null) {
                    if (bl) {
                        bl = false;
                        String string4 = this.getString("DLG_ErrorDialogTitle");
                        string = this.getString("MSG_ModuleDependencyError");
                        object2 = new NotifyDescriptor((Object)string, string4, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                        DialogDisplayer.getDefault().notify(object2);
                    }
                    return stringArray;
                }
                if (arrayList2.size() == 0) {
                    arrayList.add(object22);
                    continue;
                }
                linkedList.add(new FortranFile((String)object22, arrayList2));
                for (int notifyDescriptor = 0; notifyDescriptor < arrayList2.size(); ++notifyDescriptor) {
                    string = arrayList2.get(notifyDescriptor).toString();
                    if (string.charAt(0) != 'M') continue;
                    object2 = hashMap.get(string.substring(1));
                    if (object2 != null) {
                        if (!bl) continue;
                        bl = false;
                        String string5 = this.getString("DLG_ErrorDialogTitle");
                        String string6 = MessageFormat.format(this.getString("MSG_DuplicateModuleError"), string.substring(1), targetData.getName(), object22, object2.toString());
                        NotifyDescriptor notifyDescriptor2 = new NotifyDescriptor((Object)string6, string5, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                        DialogDisplayer.getDefault().notify(notifyDescriptor2);
                        throw new MakefileGenerationException();
                    }
                    hashMap.put(string.substring(1), object22);
                }
                continue;
            }
            arrayList.add(string3);
        }
        for (FortranFile fortranFile : linkedList) {
            object = fortranFile.getRawList();
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                String string7 = ((ArrayList)object).get(i).toString();
                if (string7.charAt(0) != 'U' || (string = (String)hashMap.get(string7.substring(1))) == null || string.equals(fortranFile.getName())) continue;
                fortranFile.addDependsOn(string);
            }
        }
        while (linkedList.size() > 0) {
            boolean bl3 = false;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (FortranFile)iterator.next();
                if (((FortranFile)object).getDependsOn() != null) continue;
                arrayList.add(((FortranFile)object).getName());
                iterator.remove();
                this.remove(linkedList.iterator(), ((FortranFile)object).getName());
                bl3 = true;
                break;
            }
            if (bl3) continue;
            if (bl) {
                bl = false;
                object = this.getString("DLG_ErrorDialogTitle");
                String string8 = this.getString("MSG_CircularDependency");
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string8, (String)object, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                DialogDisplayer.getDefault().notify(notifyDescriptor);
            }
            iterator = linkedList.iterator();
            object = (FortranFile)iterator.next();
            this.remove(linkedList.iterator(), null);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void remove(Iterator iterator, String string) {
        block0: while (iterator.hasNext()) {
            FortranFile fortranFile = (FortranFile)iterator.next();
            ArrayList arrayList = fortranFile.getDependsOn();
            if (arrayList == null) continue;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (string != null && !string.equals(arrayList.get(i))) continue;
                arrayList.remove(i);
                if (arrayList.size() != 0) continue block0;
                fortranFile.setDependsOn(null);
                continue block0;
            }
        }
    }

    private boolean isFortranFile(String string) {
        return "text/x-fortran".equals(MIMESupport.getKnownMIMETypeByExtension((String)string));
    }

    private String objectOf(String string) {
        StringBuilder stringBuilder = new StringBuilder(80);
        int n = string.lastIndexOf(47) + 1;
        int n2 = string.substring(n).lastIndexOf(46);
        if (n2 >= 0) {
            stringBuilder.append(string.substring(n, n + n2 + 1));
            stringBuilder.append('o');
            return stringBuilder.toString();
        }
        return null;
    }

    private void sharedLibFlags(TargetData targetData) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        this.appendOSDepMacro(stringBuffer, this.var.makeName("SHAREDLIB_FLAGS_"), "-G -norunpath -h " + targetData.getName() + " ", "-shared ", "-dynamiclib -install_name " + targetData.getName());
        this.out.write(stringBuffer.toString(), 0, stringBuffer.length());
    }

    private String linkLine(TargetData targetData, int n) throws IOException {
        String string;
        String string2;
        StringBuilder stringBuilder = new StringBuilder(256);
        if (targetData.containsCppFiles()) {
            string2 = "$(LINK.cc) ";
            string = "CCFLAGS_";
        } else if (targetData.containsFortranFiles()) {
            string2 = "$(LINK.f) ";
            string = "FFLAGS_";
        } else {
            string2 = "$(LINK.c) ";
            string = "CFLAGS_";
        }
        stringBuilder.append(string2);
        stringBuilder.append(this.var.makeRef(string));
        stringBuilder.append(' ');
        stringBuilder.append(this.var.makeRef("CPPFLAGS_"));
        stringBuilder.append(" -o $@ ");
        stringBuilder.append(this.var.makeRef("OBJS_"));
        stringBuilder.append(' ');
        if (n == 3 || n == 7) {
            this.sharedLibFlags(targetData);
            stringBuilder.append("$(" + this.var.makeName("SHAREDLIB_FLAGS_") + ") ");
        }
        stringBuilder.append(this.var.makeRef("LDLIBS_"));
        if (targetData.containsXdFiles()) {
            stringBuilder.append(this.xdLinkMagic(targetData));
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private String xdLinkMagic(TargetData targetData) {
        StringBuilder stringBuilder = new StringBuilder(256);
        String[] stringArray = targetData.getSourcesList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!targetData.isXdFile(stringArray[i])) continue;
            String string2 = this.getXdTargetName(targetData, string);
            stringBuilder.append(" \\\n\t\t");
            stringBuilder.append("$(XD_OBJS_");
            stringBuilder.append(string2);
            stringBuilder.append(") $(XD_LINK_ARGS_");
            stringBuilder.append(string2);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private String xdLinkDependencies(TargetData targetData) {
        StringBuilder stringBuilder = new StringBuilder(256);
        String[] stringArray = targetData.getSourcesList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!targetData.isXdFile(stringArray[i])) continue;
            String string2 = this.getXdTargetName(targetData, string);
            stringBuilder.append(" \\\n\t\t");
            stringBuilder.append(this.var.makeRef("TARGETDIR_"));
            stringBuilder.append("/$(XD_OBJS_FILE_");
            stringBuilder.append(string2);
            stringBuilder.append(") $(TARGETDIR_");
            stringBuilder.append(targetData.getName());
            stringBuilder.append(")/$(XD_LINK_ARGS_FILE_");
            stringBuilder.append(string2);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private String getSysLibs(TargetData targetData) {
        StdLibFlags stdLibFlags = targetData.getStdLibFlags();
        this.buf.delete(0, this.buf.length());
        this.buf.append(stdLibFlags.getSysLibFlags(this.md.getToolset(), this.md.getMakefileOS(), this.md.getCompilerFlags().is64Bit(), targetData));
        if (this.buf.length() > 0) {
            this.buf.insert(0, " = ");
            this.buf.insert(0, this.var.makeName("SYSLIBS_"));
            this.buf.append('\n');
        }
        return this.buf.toString();
    }

    private String getUserLibs(TargetData targetData) {
        String[] stringArray = targetData.getUserLibsList();
        this.buf.delete(0, this.buf.length());
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                this.buf.append(string);
                this.buf.append(' ');
            }
        }
        if (this.buf.length() > 0) {
            this.buf.insert(0, " = ");
            this.buf.insert(0, this.var.makeName("USERLIBS_"));
            this.buf.append('\n');
        }
        return this.buf.toString();
    }

    private String getDependLibs(TargetData targetData) {
        String[] stringArray = targetData.getUserLibsList();
        this.buf.delete(0, this.buf.length());
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.charAt(0) != '-' && string.charAt(0) != '/' && (string.endsWith(".a") || string.endsWith(".so") || string.endsWith(".dylib") || string.endsWith(".dll"))) {
                    this.buf.append(string);
                    this.buf.append(' ');
                }
                this.buf.append(' ');
            }
        }
        if (this.buf.length() > 0) {
            this.buf.insert(0, " = ");
            this.buf.insert(0, this.var.makeName("DEPLIBS_"));
            this.buf.append('\n');
        }
        return this.buf.toString();
    }

    private String doList(String string, String string2, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(256);
        string2 = string2 == null ? " \\\n\t" : " \\\n\t" + string2;
        stringBuilder.append(string);
        stringBuilder.append(" =");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private String generateTargetFlags(TargetData targetData) {
        StringBuilder stringBuilder = new StringBuilder(80);
        if (targetData.getTargetType() == 7 || targetData.getTargetType() == 3) {
            stringBuilder.append("-Kpic ");
        }
        this.buf.delete(0, this.buf.length());
        if (stringBuilder.length() > 0) {
            int n = this.md.getToolset();
            if (targetData.containsCFiles()) {
                this.appendToolsetDepMacro(this.var.makeName("CFLAGS_"), stringBuilder.toString(), "");
            }
            if (targetData.containsCppFiles()) {
                this.appendToolsetDepMacro(this.var.makeName("CCFLAGS_"), stringBuilder.toString(), "");
            }
            if (targetData.containsFortranFiles()) {
                this.appendToolsetDepMacro(this.var.makeName("FFLAGS_"), stringBuilder.toString(), "");
            }
        }
        return this.buf.toString();
    }

    private String[] getObjectList(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].lastIndexOf(46);
            if (n < 0) continue;
            StringBuilder stringBuilder = new StringBuilder(stringArray[i].substring(0, n + 1));
            stringBuilder.append('o');
            stringArray2[i] = new String(stringBuilder);
        }
        return stringArray2;
    }

    private boolean targetIsIncomplete() {
        List<TargetData> list = this.md.getTargetList();
        for (int i = 0; i < list.size(); ++i) {
            TargetData targetData = list.get(i);
            if (!targetData.isCompilable() || targetData.getSourcesList() != null && targetData.getSourcesList().length != 0) continue;
            return true;
        }
        return false;
    }

    private void completeTargets() {
        List<TargetData> list = this.md.getTargetList();
        for (int i = 0; i < list.size(); ++i) {
        }
    }

    public static boolean generatedMakefile(File file) {
        String[] stringArray = new String[3];
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            stringArray[n++] = bufferedReader.readLine();
            stringArray[n++] = bufferedReader.readLine();
            stringArray[n++] = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return stringArray[2] != null && stringArray[0].equals(LINE1) && stringArray[1].equals(BLANKCOMMENT) && stringArray[2].startsWith(LINE_PREFIX);
    }

    private int validateOrCreateCwd() {
        String string = this.md.getBaseDirectory(true);
        File file = new File(string);
        return this.validateOrCreateDir(string, file, this.getString("MSG_CwdNotDir"));
    }

    private int validateOrCreateMakefileDir() {
        String string = this.md.getMakefileName();
        this.fmakefile = string.charAt(0) == File.separatorChar ? new File(string) : new File(this.md.getBaseDirectory(true), string);
        String string2 = this.fmakefile.getParent();
        File file = this.fmakefile.getParentFile();
        return this.validateOrCreateDir(string2, file, this.getString("MSG_MakefileDirNotDir"));
    }

    private int validateOrCreateDir(String string, File file, String string2) {
        if (file.exists() && !file.isDirectory()) {
            String string3 = MessageFormat.format(string2, string);
            String string4 = this.getString("DLG_ErrorDialogTitle");
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string3, string4, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
            return 1;
        }
        if (!file.exists()) {
            String string5 = MessageFormat.format(this.getString("MSG_CreateDirectory"), string);
            String string6 = this.getString("DLG_QuestionDialogTitle");
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string5, string6, 0, 3, null, NotifyDescriptor.YES_OPTION);
            Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
            if (object == NotifyDescriptor.NO_OPTION || !this.mkdirs(string, file)) {
                return 1;
            }
        }
        return 0;
    }

    private String getTimestamp() {
        Date date = new Date();
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(DateFormat.getDateInstance().format(date));
        stringBuilder.append(" ");
        stringBuilder.append(DateFormat.getTimeInstance().format(date));
        return stringBuilder.toString();
    }

    private String getUserName() {
        String string = System.getProperty("Env-USER");
        if (string == null && (string = System.getProperty("Env-LOGNAME")) == null && (string = System.getProperty("user.name")) == null) {
            string = this.getString("UNKNOWN_USER");
        }
        return string;
    }

    private boolean mkdirs(String string, File file) {
        if (!file.mkdirs()) {
            String string2 = MessageFormat.format(this.getString("MSG_CannotCreateDirectory"), string);
            String string3 = this.getString("DLG_ErrorDialogTitle");
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string2, string3, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
            return false;
        }
        return true;
    }

    private void checkTargetFlags() {
        List<TargetData> list = this.md.getTargetList();
        for (int i = 0; i < list.size(); ++i) {
            TargetData targetData = list.get(i);
            if (targetData.isComplex()) {
                this.doComplex = true;
            }
            if (targetData.containsCppFiles()) {
                this.doCpp = true;
            }
            if (targetData.containsCFiles()) {
                this.doC = true;
            }
            if (targetData.containsFortranFiles()) {
                this.doFortran = true;
            }
            if (targetData.containsXdFiles()) {
                this.doXd = true;
                this.doC = true;
                this.doCpp = true;
            }
            if (!targetData.containsAssemblyFiles()) continue;
            this.doAssembly = true;
        }
    }

    protected String getString(String string) {
        return this.bundle.getString(string);
    }

    private String getOutputDirectory(TargetData targetData) {
        String string = targetData.getOutputDirectory();
        if (string.equals(this.getString("OutputDirectoryPlatform"))) {
            return "$(PLATFORM)";
        }
        return string;
    }

    private void appendToolsetDepMacro(String string, String string2, String string3) {
        this.appendToolsetDepMacro(this.buf, string, string2, string3);
    }

    private void appendToolsetDepMacro(StringBuffer stringBuffer, String string, String string2, String string3) {
        int n = this.md.getToolset();
        if (n == 0) {
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(string2);
            stringBuffer.append('\n');
        } else if (n == 1) {
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(string3);
            stringBuffer.append('\n');
        } else if (n == 2) {
            stringBuffer.append(string + "-SUN");
            stringBuffer.append(" = ");
            stringBuffer.append(string2);
            stringBuffer.append('\n');
            stringBuffer.append(string + "-GNU");
            stringBuffer.append(" = ");
            stringBuffer.append(string3);
            stringBuffer.append('\n');
            stringBuffer.append(string + " = $(" + string + "-$(TOOLSET))");
            stringBuffer.append('\n');
        }
    }

    private void appendToolsetDepMacro(String string, String string2, String string3, String string4) {
        this.appendToolsetDepMacro(this.buf, string, string2, string3, string4);
    }

    private void appendToolsetDepMacro(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        int n = this.md.getToolset();
        if (n == 0 || n == 2) {
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(string2);
            stringBuffer.append('\n');
        }
        if (n == 1 || n == 2) {
            stringBuffer.append(string3);
            stringBuffer.append(" = ");
            stringBuffer.append(string4);
            stringBuffer.append('\n');
        }
    }

    private void appendMacro(String string, String string2) {
        this.appendMacro(this.buf, string, string2);
    }

    private void appendMacro(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(" = ");
        stringBuffer.append(string2);
        stringBuffer.append('\n');
    }

    private void appendOSDepMacro(String string, String string2, String string3, String string4) {
        this.appendOSDepMacro(this.buf, string, string2, string3, string4);
    }

    private void appendOSDepMacro(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        int n = this.md.getMakefileOS();
        if (n == 0) {
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(string2);
            stringBuffer.append('\n');
        } else if (n == 1) {
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(string3);
            stringBuffer.append('\n');
        } else if (n == 4) {
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(string4);
            stringBuffer.append('\n');
        } else if (n == 2) {
            stringBuffer.append(string + "-SunOS");
            stringBuffer.append(" = ");
            stringBuffer.append(string2);
            stringBuffer.append('\n');
            stringBuffer.append(string + "-Linux");
            stringBuffer.append(" = ");
            stringBuffer.append(string3);
            stringBuffer.append('\n');
            stringBuffer.append(string + " = $(" + string + "-$(OS))");
            stringBuffer.append('\n');
        }
    }

    private static final class MakefileGenerationException
    extends Exception {
        public MakefileGenerationException() {
        }

        public MakefileGenerationException(String string) {
            super(string);
        }
    }

    private static final class MakeVarName {
        private String targetName = null;
        private StringBuffer lastName;
        private StringBuffer lastRef;
        private StringBuffer lastSuffix;
        private StringBuffer buffer = new StringBuffer(80);

        public MakeVarName() {
            this.lastName = new StringBuffer(80);
            this.lastRef = new StringBuffer(80);
            this.lastSuffix = new StringBuffer(20);
        }

        public void setTargetName(String string) {
            this.targetName = string;
            this.lastName.delete(0, this.lastName.length());
            this.lastRef.delete(0, this.lastRef.length());
            this.lastSuffix.delete(0, this.lastSuffix.length());
        }

        public String makeName(String string) {
            if (string.equals(this.lastSuffix.toString())) {
                return this.lastName.toString();
            }
            this.buffer.replace(0, this.buffer.length(), string);
            this.buffer.append(this.targetName);
            this.lastName.replace(0, this.lastName.length(), this.buffer.toString());
            return this.buffer.toString();
        }

        public String makeName(String string, String string2) {
            if (string.equals(this.lastSuffix.toString())) {
                return this.lastName.toString();
            }
            this.buffer.replace(0, this.buffer.length(), string);
            this.buffer.append(this.targetName);
            this.buffer.append("_");
            this.buffer.append(string2);
            this.lastName.replace(0, this.lastName.length(), this.buffer.toString());
            return this.buffer.toString();
        }

        public String makeRef(String string) {
            if (string.equals(this.lastSuffix.toString())) {
                return this.lastRef.toString();
            }
            this.buffer.replace(0, this.buffer.length(), "$(");
            this.buffer.append(string);
            this.buffer.append(this.targetName);
            this.buffer.append(")");
            this.lastRef.replace(0, this.lastRef.length(), this.buffer.toString());
            return this.buffer.toString();
        }

        public String makeRef(String string, String string2) {
            if (string.equals(this.lastSuffix.toString())) {
                return this.lastRef.toString();
            }
            this.buffer.replace(0, this.buffer.length(), "$(");
            this.buffer.append(string);
            this.buffer.append(this.targetName);
            this.buffer.append("_");
            this.buffer.append(string2);
            this.buffer.append(")");
            this.lastRef.replace(0, this.lastRef.length(), this.buffer.toString());
            return this.buffer.toString();
        }

        public String lastName() {
            return this.lastName.toString();
        }

        public String lastRef() {
            return this.lastRef.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FortranFile {
        private String name;
        private ArrayList rawList;
        private ArrayList<String> dependsOn;

        public FortranFile(String string, ArrayList arrayList) {
            this.name = new String(string);
            this.rawList = arrayList;
            this.dependsOn = null;
        }

        public final void addDependsOn(String string) {
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList();
            }
            for (int i = 0; i < this.dependsOn.size(); ++i) {
                if (!string.equals(this.dependsOn.get(i))) continue;
                return;
            }
            this.dependsOn.add(string);
        }

        public final ArrayList getDependsOn() {
            return this.dependsOn;
        }

        public final void setDependsOn(ArrayList<String> arrayList) {
            this.dependsOn = arrayList;
        }

        public final String getName() {
            return this.name;
        }

        public final ArrayList getRawList() {
            return this.rawList;
        }
    }
}

