/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.modules.cnd.api.utils.IpeFileSystemView;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;

public class ItemChooser
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = 6653452210904639697L;
    private JLabel dirLabel;
    private JTextField dirText;
    private JButton dirChooser;
    private JLabel label;
    private JTextField text;
    private JFileChooser fc;
    private boolean directoryValid;
    private boolean uncreatedDirOK;
    private boolean dirReadOnly;
    private boolean textNotFile;

    protected ItemChooser(MakefileWizard makefileWizard) {
        this(makefileWizard, false, false);
    }

    protected ItemChooser(MakefileWizard makefileWizard, boolean bl) {
        this(makefileWizard, bl, false);
    }

    protected ItemChooser(MakefileWizard makefileWizard, boolean bl, boolean bl2) {
        super(makefileWizard);
        this.uncreatedDirOK = bl;
        this.dirReadOnly = bl2;
    }

    public boolean isPanelValid() {
        return this.uncreatedDirOK && this.textNotFile || this.directoryValid;
    }

    protected final void onOk() {
        this.checkit();
    }

    private void validateDirectory() {
        String string = this.dirText.getText();
        if (string.length() > 0) {
            File file = string.charAt(0) == File.separatorChar ? new File(string) : new File(".", string);
            if (this.uncreatedDirOK) {
                boolean bl;
                boolean bl2 = bl = !file.isFile();
                if (bl != this.textNotFile) {
                    this.textNotFile = bl;
                    MakefileWizard.getMakefileWizard().updateState();
                }
            } else {
                boolean bl = file.isDirectory();
                if (bl != this.directoryValid) {
                    this.directoryValid = bl;
                    MakefileWizard.getMakefileWizard().updateState();
                }
            }
        }
    }

    private final void checkit() {
        boolean bl = this.directoryValid;
        this.validateDirectory();
        if (this.directoryValid != bl) {
            MakefileWizard.getMakefileWizard().updateState();
        }
    }

    protected void create(String string, char c, String string2, char c2) {
        int n = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = gridBagConstraints.insets;
        this.dirLabel = new JLabel(string);
        this.dirLabel.setDisplayedMnemonic(c);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.dirLabel, gridBagConstraints);
        this.dirText = new JTextField();
        this.dirText.addFocusListener(this);
        this.dirLabel.setLabelFor(this.dirText);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.add((Component)this.dirText, gridBagConstraints);
        this.dirText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ItemChooser.this.checkit();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ItemChooser.this.checkit();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ItemChooser.this.checkit();
            }
        });
        if (this.dirReadOnly) {
            this.dirText.setEnabled(false);
        } else {
            this.dirChooser = new JButton(this.getString("BTN_Chooser"));
            this.dirChooser.setMnemonic(this.getString("MNEM_Chooser").charAt(0));
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.dirChooser, gridBagConstraints);
            this.dirChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ItemChooser.this.getMakefileData().getBaseDirectory(true);
                    ItemChooser.this.fc = new JFileChooser();
                    ItemChooser.this.fc.setApproveButtonText(ItemChooser.this.getString("BTN_Approve"));
                    ItemChooser.this.fc.setDialogTitle(ItemChooser.this.getString("TITLE_DirChooser"));
                    ItemChooser.this.fc.setCurrentDirectory(new File(string));
                    ItemChooser.this.fc.setFileSelectionMode(1);
                    ItemChooser.this.fc.setFileSystemView(new IpeFileSystemView(ItemChooser.this.fc.getFileSystemView()));
                    int n = ItemChooser.this.fc.showDialog(ItemChooser.this, null);
                    if (n == 0) {
                        String string2 = ItemChooser.this.fc.getSelectedFile().getAbsolutePath();
                        ItemChooser.this.dirText.setText(IpeUtils.getRelativePath(string, string2));
                    }
                }
            });
        }
        this.label = new JLabel(string2);
        this.label.setDisplayedMnemonic(c2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.label, gridBagConstraints);
        this.text = new JTextField();
        this.text.addFocusListener(this);
        this.label.setLabelFor(this.text);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.text, gridBagConstraints);
        Keymap keymap = JTextField.addKeymap("ItemChooserKeymap", this.text.getKeymap());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke('/'), new DefaultEditorKit.BeepAction());
        this.text.setKeymap(keymap);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(""), gridBagConstraints);
    }

    final void convertLabel(String string, char c) {
        this.label.setText(string);
        this.label.setDisplayedMnemonic(c);
    }

    final JTextField getText() {
        return this.text;
    }

    final JTextField getDirText() {
        return this.dirText;
    }

    final JLabel getNameLabel() {
        return this.label;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        ((JTextComponent)focusEvent.getComponent()).setSelectionEnd(0);
    }

    public void addNotify() {
        super.addNotify();
        this.dirText.selectAll();
        IpeUtils.requestFocus(this.dirText);
        this.validateDirectory();
    }

    public void removeNotify() {
        Container container;
        super.removeNotify();
        if (this.fc != null && this.fc.isShowing() && (container = this.fc.getTopLevelAncestor()) != null && container instanceof JDialog) {
            ((JDialog)container).dispose();
        }
    }
}

