/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.api.utils.IpeFileSystemView;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;

public abstract class FileChooserPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = -3638230469770222549L;
    private JLabel label;
    private JTextField text;
    private JTextArea helpText;
    protected JFileChooser fc;
    private int pathType;
    public static final int PATH_NONE = 0;
    public static final int ABSOLUTE_PATH = 1;
    public static final int RELATIVE_PATH = 2;
    public static final int NAME_ONLY = 3;

    public FileChooserPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        this.init();
    }

    public FileChooserPanel(MakefileWizard makefileWizard, JFileChooser jFileChooser) {
        super(makefileWizard);
        this.fc = jFileChooser;
        this.init();
    }

    protected void init() {
        this.pathType = 0;
    }

    public void setPathType(int n) {
        if (n == 1 || n == 2 || n == 3) {
            this.pathType = n;
        }
    }

    public void create(String string) {
        this.create(string, this.pathType, null);
    }

    public void create(String string, int n) {
        this.create(string, n, null);
    }

    public void create(String string, String string2) {
        this.create(string, this.pathType, string2);
    }

    public void create(String string, final int n, String string2) {
        int n2 = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.pathType = n;
        this.label = new JLabel(string);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.label, gridBagConstraints);
        this.text = new JTextField();
        this.text.addFocusListener(this);
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.text, gridBagConstraints);
        JButton jButton = new JButton(this.getString("BTN_Chooser"));
        jButton.setMnemonic(this.getString("MNEM_Chooser").charAt(0));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                String string;
                if (FileChooserPanel.this.fc == null) {
                    FileChooserPanel.this.fc = new JFileChooser();
                    FileChooserPanel.this.fc.setApproveButtonText(FileChooserPanel.this.getString("BTN_Approve"));
                    FileChooserPanel.this.fc.setFileSystemView(new IpeFileSystemView(FileChooserPanel.this.fc.getFileSystemView()));
                    FileChooserPanel.this.fc.setDialogTitle(FileChooserPanel.this.getString("DLG_FILE_CHOOSER_TITLE"));
                }
                File file2 = (string = IpeUtils.expandPath(FileChooserPanel.this.text.getText())).length() > 0 && (file = new File(string)).isDirectory() ? (string.charAt(0) == '.' ? new File(FileChooserPanel.this.getMakefileData().getBaseDirectory() + File.separator + string) : file) : new File(FileChooserPanel.this.getMakefileData().getBaseDirectory());
                FileChooserPanel.this.fc.setCurrentDirectory(file2);
                int n2 = FileChooserPanel.this.fc.showDialog(FileChooserPanel.this, null);
                if (n2 == 0) {
                    file = FileChooserPanel.this.fc.getSelectedFile();
                    if (n == 1) {
                        try {
                            FileChooserPanel.this.text.setText(file.getCanonicalPath());
                        }
                        catch (IOException iOException) {
                            FileChooserPanel.this.text.setText(file.getAbsolutePath());
                        }
                    } else if (n == 3) {
                        FileChooserPanel.this.text.setText(file.getName());
                    } else if (n == 2) {
                        String string2 = null;
                        try {
                            string2 = file.getAbsolutePath();
                            String string3 = file2.getCanonicalPath();
                            if (string2.equals(string3)) {
                                FileChooserPanel.this.text.setText(".");
                            } else if (string2.startsWith(string3)) {
                                FileChooserPanel.this.text.setText(string2.substring(string3.length() + 1));
                            } else {
                                FileChooserPanel.this.text.setText(string2);
                            }
                        }
                        catch (IOException iOException) {
                            if (string2 == null) {
                                FileChooserPanel.this.text.setText(file.getAbsolutePath());
                            }
                            FileChooserPanel.this.text.setText(string2);
                        }
                    }
                    FileChooserPanel.this.onOk();
                }
            }
        });
        if (string2 != null) {
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(11, 0, 0, 0);
            this.helpText = new JTextArea(string2);
            this.helpText.getAccessibleContext().setAccessibleName("ACSN_DirHelp");
            this.helpText.addFocusListener(this);
            this.helpText.setEditable(false);
            this.helpText.setFocusable(false);
            this.helpText.setLineWrap(true);
            this.helpText.setWrapStyleWord(true);
            this.helpText.setBackground(this.label.getBackground());
            this.add((Component)this.helpText, gridBagConstraints);
        } else {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JLabel(""), gridBagConstraints);
        }
    }

    protected void onOk() {
    }

    protected JLabel getLabel() {
        return this.label;
    }

    protected JTextField getText() {
        return this.text;
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component == this.helpText || component == this.text) {
            ((JTextComponent)component).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        ((JTextComponent)focusEvent.getComponent()).setSelectionEnd(0);
    }

    public void addNotify() {
        super.addNotify();
        IpeUtils.requestFocus(this.text);
    }

    public void removeNotify() {
        Container container;
        super.removeNotify();
        if (this.fc != null && this.fc.isShowing() && (container = this.fc.getTopLevelAncestor()) != null && container instanceof JDialog) {
            ((JDialog)container).dispose();
        }
    }
}

