/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.CompilerFlags;
import org.netbeans.modules.cnd.makewizard.MakefileData;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;

public final class CompilerOptionsPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = 5260017369797781413L;
    private JTextArea topLabel;
    private JTextField cText;
    private JTextField cppText;
    private JTextField fortranText;
    private JTextField basicText;
    private CompilerFlags copts;
    private JLabel cppCompilerLabel;
    private JComboBox cConformLevelCB;
    private ActionListener cConformLevelCBActionListener;
    private JComboBox cppConformLevelCB;
    private ActionListener cppConformLevelCBActionListener;
    private boolean initialized;

    public CompilerOptionsPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = this.getString("LBL_CompilerOptionsPanel");
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    protected void create() {
        int n = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        this.topLabel = new JTextArea(this.getString("LBL_COptsTopLabel"));
        this.topLabel.addFocusListener(this);
        this.topLabel.setEditable(false);
        this.topLabel.setFocusable(false);
        this.topLabel.setBackground(new JPanel().getBackground());
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.topLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 5;
        JLabel jLabel = new JLabel(this.getString("LBL_COptsCCompiler"));
        jLabel.setDisplayedMnemonic(this.getString("MNEM_COptsCCompiler").charAt(0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 11;
        gridBagConstraints.insets.top = 11;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)jLabel, gridBagConstraints);
        this.cText = new JTextField();
        this.cText.addFocusListener(this);
        jLabel.setLabelFor(this.cText);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.cText, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(this.getString("LBL_ConformLevel"));
        jLabel2.setDisplayedMnemonic(this.getString("MNEM_ConformLevel1").charAt(0));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)jLabel2, gridBagConstraints);
        this.cConformLevelCB = new JComboBox();
        jLabel2.setLabelFor(this.cConformLevelCB);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.cConformLevelCB, gridBagConstraints);
        JLabel jLabel3 = new JLabel(this.getString("LBL_COptsCppCompiler"));
        jLabel3.setDisplayedMnemonic(this.getString("MNEM_COptsCppCompiler").charAt(0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.insets.right = 11;
        gridBagConstraints.insets.top = 11;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)jLabel3, gridBagConstraints);
        this.cppText = new JTextField();
        this.cppText.addFocusListener(this);
        jLabel3.setLabelFor(this.cppText);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.cppText, gridBagConstraints);
        this.cppCompilerLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.cppCompilerLabel, gridBagConstraints);
        this.cppConformLevelCB = new JComboBox();
        this.cppCompilerLabel.setLabelFor(this.cppConformLevelCB);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.cppConformLevelCB, gridBagConstraints);
        JLabel jLabel4 = new JLabel(this.getString("LBL_COptsFortranCompiler"));
        jLabel4.setDisplayedMnemonic(this.getString("MNEM_COptsFortranCompiler").charAt(0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.insets.right = 11;
        gridBagConstraints.insets.top = 11;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)jLabel4, gridBagConstraints);
        this.fortranText = new JTextField();
        this.fortranText.addFocusListener(this);
        jLabel4.setLabelFor(this.fortranText);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.fortranText, gridBagConstraints);
        JLabel jLabel5 = new JLabel(this.getString("LBL_BasicOptionsVar"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 11;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)jLabel5, gridBagConstraints);
        this.basicText = new JTextField();
        this.basicText.addFocusListener(this);
        this.basicText.setEditable(false);
        this.basicText.setFocusable(false);
        this.basicText.setBackground(jLabel5.getBackground());
        jLabel5.setLabelFor(this.basicText);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.basicText, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridheight = 0;
        this.add((Component)new JLabel(""), gridBagConstraints);
        this.topLabel.setBackground(jLabel.getBackground());
        this.cConformLevelCBActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompilerOptionsPanel.this.cConformLevelCBActionPerformed(actionEvent);
            }
        };
        this.cConformLevelCB.addActionListener(this.cConformLevelCBActionListener);
        this.cText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                CompilerOptionsPanel.this.cTextKeyReleased(keyEvent);
            }
        });
        this.cppConformLevelCBActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompilerOptionsPanel.this.cppConformLevelCBActionPerformed(actionEvent);
            }
        };
        this.cppConformLevelCB.addActionListener(this.cppConformLevelCBActionListener);
        this.cppText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                CompilerOptionsPanel.this.cppTextKeyReleased(keyEvent);
            }
        });
    }

    public void addNotify() {
        if (!this.initialized) {
            this.initialized = true;
            this.create();
            this.copts = this.getMakefileData().getCompilerFlags();
        }
        super.addNotify();
        this.cText.setText(this.copts.getCFlags(this.getMakefileData().getToolset()));
        this.cppText.setText(this.copts.getCcFlags(this.getMakefileData().getToolset()));
        this.fortranText.setText(this.copts.getF90Flags());
        this.basicText.setText(this.copts.getBasicOptions(this.getMakefileData().getToolset()));
        this.cText.selectAll();
        IpeUtils.requestFocus(this.cText);
        this.cConformLevelCB.removeActionListener(this.cConformLevelCBActionListener);
        this.cppConformLevelCB.removeActionListener(this.cppConformLevelCBActionListener);
        this.cConformLevelCB.removeAllItems();
        this.cppConformLevelCB.removeAllItems();
        if (this.getMakefileData().getToolset() == 0) {
            this.cConformLevelCB.addItem(this.getString("CSunConform0"));
            this.cConformLevelCB.addItem(this.getString("CSunConform1"));
            this.cConformLevelCB.addItem(this.getString("CSunConform2"));
            this.cConformLevelCB.setSelectedIndex(this.getMakefileData().getConformLevelCSun());
            this.cppCompilerLabel.setText(this.getString("LBL_Compatibility"));
            this.cppCompilerLabel.setDisplayedMnemonic(this.getString("MNEM_Compatibility").charAt(0));
            this.cppConformLevelCB.addItem(this.getString("CppSunConform0"));
            this.cppConformLevelCB.addItem(this.getString("CppSunConform1"));
            this.cppConformLevelCB.setSelectedIndex(this.getMakefileData().getConformLevelCppSun());
        } else {
            this.cConformLevelCB.addItem(this.getString("CGNUConform0"));
            this.cConformLevelCB.addItem(this.getString("CGNUConform1"));
            this.cConformLevelCB.setSelectedIndex(this.getMakefileData().getConformLevelCGNU());
            this.cppCompilerLabel.setText(this.getString("LBL_ConformLevel"));
            this.cppCompilerLabel.setDisplayedMnemonic(this.getString("MNEM_ConformLevel2").charAt(0));
            this.cppConformLevelCB.addItem(this.getString("CppGNUConform0"));
            this.cppConformLevelCB.addItem(this.getString("CppGNUConform1"));
            this.cppConformLevelCB.setSelectedIndex(this.getMakefileData().getConformLevelCppGNU());
        }
        this.cConformLevelCB.addActionListener(this.cConformLevelCBActionListener);
        this.cppConformLevelCB.addActionListener(this.cppConformLevelCBActionListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.copts.setCFlags(this.getMakefileData().getToolset(), this.cText.getText());
        this.copts.setCcFlags(this.getMakefileData().getToolset(), this.cppText.getText());
        this.copts.setF90Flags(this.fortranText.getText());
        if (this.getMakefileData().getToolset() == 0) {
            this.getMakefileData().setConformLevelCSun(this.cConformLevelCB.getSelectedIndex());
            this.getMakefileData().setConformLevelCppSun(this.cppConformLevelCB.getSelectedIndex());
        } else {
            this.getMakefileData().setConformLevelCGNU(this.cConformLevelCB.getSelectedIndex());
            this.getMakefileData().setConformLevelCppGNU(this.cppConformLevelCB.getSelectedIndex());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.basicText || focusEvent.getComponent() == this.topLabel) {
            ((JTextComponent)focusEvent.getComponent()).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        ((JTextComponent)focusEvent.getComponent()).setSelectionEnd(0);
    }

    private void cConformLevelCBActionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.getMakefileData().getToolset() == 0 ? MakefileData.conformLevelsCSun : MakefileData.conformLevelsCGNU;
        int n = this.cConformLevelCB.getSelectedIndex();
        String string = this.removeOptions(this.cText.getText(), stringArray);
        string = this.addOption(string, stringArray[n]);
        this.cText.setText(string);
    }

    private void cppConformLevelCBActionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.getMakefileData().getToolset() == 0 ? MakefileData.conformLevelsCppSun : MakefileData.conformLevelsCppGNU;
        int n = this.cppConformLevelCB.getSelectedIndex();
        String string = this.removeOptions(this.cppText.getText(), stringArray);
        string = this.addOption(string, stringArray[n]);
        this.cppText.setText(string);
    }

    private void cTextKeyReleased(KeyEvent keyEvent) {
        String string = this.cText.getText();
        String[] stringArray = this.getMakefileData().getToolset() == 0 ? MakefileData.conformLevelsCSun : MakefileData.conformLevelsCGNU;
        int n = 0;
        boolean bl = false;
        this.cConformLevelCB.removeActionListener(this.cConformLevelCBActionListener);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) {
                n = i;
                continue;
            }
            if (this.containsOption(string, stringArray[i]) < 0) continue;
            this.cConformLevelCB.setSelectedIndex(i);
            bl = true;
            break;
        }
        if (!bl) {
            this.cConformLevelCB.setSelectedIndex(n);
        }
        this.cConformLevelCB.addActionListener(this.cConformLevelCBActionListener);
    }

    private void cppTextKeyReleased(KeyEvent keyEvent) {
        String string = this.cppText.getText();
        String[] stringArray = this.getMakefileData().getToolset() == 0 ? MakefileData.conformLevelsCppSun : MakefileData.conformLevelsCppGNU;
        int n = 0;
        boolean bl = false;
        this.cppConformLevelCB.removeActionListener(this.cppConformLevelCBActionListener);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) {
                n = i;
                continue;
            }
            if (this.containsOption(string, stringArray[i]) < 0) continue;
            this.cppConformLevelCB.setSelectedIndex(i);
            bl = true;
            break;
        }
        if (!bl) {
            this.cppConformLevelCB.setSelectedIndex(n);
        }
        this.cppConformLevelCB.addActionListener(this.cppConformLevelCBActionListener);
    }

    private int containsOption(String string, String string2) {
        int n = 0;
        int n2 = string.length();
        int n3 = string2.length();
        while (n <= n2 - n3) {
            int n4 = string.indexOf(string2, n);
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0 && !Character.isWhitespace(string.charAt(n4 - 1))) {
                n = n4 + 1;
                continue;
            }
            if (n4 < n2 - n3 && !Character.isWhitespace(string.charAt(n4 + n3))) {
                n = n4 + 1;
                continue;
            }
            return n4;
        }
        return -1;
    }

    private String removeOptions(String string, String[] stringArray) {
        String string2 = string;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = this.removeOption(string2, stringArray[i]);
        }
        return string2;
    }

    private String removeOption(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        int n = this.containsOption(string, string2);
        if (n < 0) {
            return string;
        }
        String string3 = n == 0 ? string.substring(n + string2.length()) : string.substring(0, n - 1) + string.substring(n + string2.length());
        return string3;
    }

    private String addOption(String string, String string2) {
        String string3 = "";
        int n = this.containsOption(string, string2);
        if (n >= 0) {
            return string;
        }
        if (string.length() > 0 && !Character.isWhitespace(string.charAt(string.length() - 1))) {
            string3 = " ";
        }
        String string4 = string + string3 + string2;
        return string4;
    }
}

