/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.update;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.update.ConflictResolvedAction;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.MergeVisualizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ResolveConflictsExecutor
extends HgProgressSupport {
    private static final String TMP_PREFIX = "merge";
    private static final String ORIG_SUFFIX = ".orig.";
    private static final String LOCAL = "local";
    static final String CHANGE_LEFT = "<<<<<<< ";
    static final String CHANGE_RIGHT = ">>>>>>> ";
    static final String CHANGE_DELIMETER = "=======";
    static final String CHANGE_BASE_DELIMETER = "|||||||";
    private String leftFileRevision = null;
    private String rightFileRevision = null;
    private final File file;

    public ResolveConflictsExecutor(File file) {
        this.file = file;
    }

    public void exec() {
        assert (SwingUtilities.isEventDispatchThread());
        MergeVisualizer mergeVisualizer = (MergeVisualizer)Lookup.getDefault().lookup(MergeVisualizer.class);
        if (mergeVisualizer == null) {
            throw new IllegalStateException("No Merge engine found.");
        }
        try {
            FileObject fileObject = FileUtil.toFileObject((File)this.file);
            if (fileObject == null) {
                Mercurial.LOG.warning("can't resolve conflicts for null fileobject : " + this.file + ", exists: " + this.file.exists());
                return;
            }
            this.handleMergeFor(this.file, fileObject, fileObject.lock(), mergeVisualizer);
        }
        catch (FileAlreadyLockedException fileAlreadyLockedException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Set set = TopComponent.getRegistry().getOpened();
                    for (TopComponent topComponent : set) {
                        if (topComponent.getClientProperty((Object)ResolveConflictsExecutor.class.getName()) == null) continue;
                        topComponent.requestActive();
                    }
                }
            });
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void handleMergeFor(File file, FileObject fileObject, FileLock fileLock, MergeVisualizer mergeVisualizer) throws IOException {
        String string = fileObject == null ? "text/plain" : fileObject.getMIMEType();
        String string2 = fileObject == null ? "" : "." + fileObject.getExt();
        File file2 = FileUtil.normalizeFile((File)File.createTempFile(TMP_PREFIX, string2));
        File file3 = FileUtil.normalizeFile((File)File.createTempFile(TMP_PREFIX, string2));
        File file4 = FileUtil.normalizeFile((File)File.createTempFile(TMP_PREFIX, string2));
        file2.deleteOnExit();
        file3.deleteOnExit();
        file4.deleteOnExit();
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        Difference[] differenceArray = this.copyParts(true, file, file2, true, charset);
        if (differenceArray.length == 0) {
            ConflictResolvedAction.resolved(file);
            return;
        }
        this.copyParts(false, file, file3, false, charset);
        String string3 = this.leftFileRevision;
        String string4 = this.rightFileRevision;
        if (this.leftFileRevision != null) {
            this.leftFileRevision = this.leftFileRevision.trim();
        }
        if (this.rightFileRevision != null) {
            this.rightFileRevision = this.rightFileRevision.trim();
        }
        this.leftFileRevision = this.leftFileRevision == null || this.leftFileRevision.equals(file.getAbsolutePath() + ORIG_SUFFIX) || this.leftFileRevision.equals(LOCAL) ? NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleWorkingFile") : NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleRevision", (Object)this.leftFileRevision);
        this.rightFileRevision = this.rightFileRevision == null || this.rightFileRevision.equals(file.getAbsolutePath() + ORIG_SUFFIX) ? NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleWorkingFile") : NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleRevision", (Object)this.rightFileRevision);
        Utils.associateEncoding((File)file, (File)file2);
        Utils.associateEncoding((File)file, (File)file3);
        StreamSource streamSource = StreamSource.createSource((String)file.getName(), (String)this.leftFileRevision, (String)string, (File)file2);
        StreamSource streamSource2 = StreamSource.createSource((String)file.getName(), (String)this.rightFileRevision, (String)string, (File)file3);
        MergeResultWriterInfo mergeResultWriterInfo = new MergeResultWriterInfo(file2, file3, file4, file, string, string3, string4, fileObject, fileLock, charset);
        try {
            Component component = mergeVisualizer.createView(differenceArray, streamSource, streamSource2, (StreamSource)mergeResultWriterInfo);
            if (component instanceof TopComponent) {
                ((TopComponent)component).putClientProperty((Object)ResolveConflictsExecutor.class.getName(), (Object)Boolean.TRUE);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Difference[] copyParts(boolean bl, File file, File file2, boolean bl2, Charset charset) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), charset));
        ArrayList<Difference> arrayList = null;
        if (bl) {
            arrayList = new ArrayList<Difference>();
        }
        try {
            String string;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n5 = 1;
            int n6 = 1;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                if (string.startsWith(CHANGE_BASE_DELIMETER)) {
                    bl5 = true;
                    continue;
                }
                if (bl5 && string.startsWith(CHANGE_DELIMETER)) {
                    bl5 = false;
                } else if (bl5) continue;
                if (string.startsWith(CHANGE_LEFT)) {
                    if (bl) {
                        if (this.leftFileRevision == null) {
                            this.leftFileRevision = string.substring(CHANGE_LEFT.length());
                        }
                        if (bl3) {
                            n2 = n5 - 1;
                            arrayList.add(n > n2 ? new Difference(1, n - 1, 0, n3, n4, stringBuffer.toString(), stringBuffer2.toString()) : (n3 > n4 ? new Difference(0, n, n2, n3 - 1, 0, stringBuffer.toString(), stringBuffer2.toString()) : new Difference(2, n, n2, n3, n4, stringBuffer.toString(), stringBuffer2.toString())));
                            n4 = 0;
                            n3 = 0;
                            n2 = 0;
                            n = 0;
                            stringBuffer.delete(0, stringBuffer.length());
                            stringBuffer2.delete(0, stringBuffer2.length());
                        } else {
                            n = n5;
                        }
                    }
                    bl3 = !bl3;
                    continue;
                }
                if (string.startsWith(CHANGE_RIGHT)) {
                    if (bl) {
                        if (this.rightFileRevision == null) {
                            this.rightFileRevision = string.substring(CHANGE_RIGHT.length());
                        }
                        if (bl4) {
                            n4 = n6 - 1;
                            arrayList.add(n > n2 ? new Difference(1, n - 1, 0, n3, n4, stringBuffer.toString(), stringBuffer2.toString()) : (n3 > n4 ? new Difference(0, n, n2, n3 - 1, 0, stringBuffer.toString(), stringBuffer2.toString()) : new Difference(2, n, n2, n3, n4, stringBuffer.toString(), stringBuffer2.toString())));
                            n4 = 0;
                            n3 = 0;
                            n2 = 0;
                            n = 0;
                            stringBuffer.delete(0, stringBuffer.length());
                            stringBuffer2.delete(0, stringBuffer2.length());
                        } else {
                            n3 = n6;
                        }
                    }
                    bl4 = !bl4;
                    continue;
                }
                if (bl4 && string.indexOf(CHANGE_RIGHT) != -1) {
                    string2 = string.substring(0, string.lastIndexOf(CHANGE_RIGHT));
                    if (bl) {
                        if (this.rightFileRevision == null) {
                            this.rightFileRevision = string.substring(string.lastIndexOf(CHANGE_RIGHT) + CHANGE_RIGHT.length());
                        }
                        stringBuffer2.append(string2);
                        n4 = n6;
                        arrayList.add(n > n2 ? new Difference(1, n - 1, 0, n3, n4, stringBuffer.toString(), stringBuffer2.toString()) : (n3 > n4 ? new Difference(0, n, n2, n3 - 1, 0, stringBuffer.toString(), stringBuffer2.toString()) : new Difference(2, n, n2, n3, n4, stringBuffer.toString(), stringBuffer2.toString())));
                        n4 = 0;
                        n3 = 0;
                        n2 = 0;
                        n = 0;
                        stringBuffer.delete(0, stringBuffer.length());
                        stringBuffer2.delete(0, stringBuffer2.length());
                    }
                    if (!bl2) {
                        bufferedWriter.write(string2);
                        bufferedWriter.newLine();
                    }
                    bl4 = !bl4;
                    continue;
                }
                if (string.equals(CHANGE_DELIMETER)) {
                    if (bl3) {
                        bl3 = false;
                        bl4 = true;
                        n2 = n5 - 1;
                        n3 = n6;
                        continue;
                    }
                    if (bl4) {
                        bl4 = false;
                        bl3 = true;
                        n4 = n6 - 1;
                        n = n5;
                        continue;
                    }
                } else if (string.endsWith(CHANGE_DELIMETER)) {
                    string2 = string.substring(0, string.length() - CHANGE_DELIMETER.length()) + "\n";
                    if (bl3) {
                        stringBuffer.append(string2);
                        if (bl2) {
                            bufferedWriter.write(string2);
                            bufferedWriter.newLine();
                        }
                        bl3 = false;
                        bl4 = true;
                        n2 = n5;
                        n3 = n6;
                        continue;
                    }
                    if (!bl4) continue;
                    stringBuffer2.append(string2);
                    if (!bl2) {
                        bufferedWriter.write(string2);
                        bufferedWriter.newLine();
                    }
                    bl4 = false;
                    bl3 = true;
                    n4 = n6;
                    n = n5;
                    continue;
                }
                if (!bl3 && !bl4 || bl2 == bl3) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                if (bl3) {
                    stringBuffer.append(string + "\n");
                }
                if (bl4) {
                    stringBuffer2.append(string + "\n");
                }
                if (!bl) continue;
                if (bl3) {
                    ++n5;
                    continue;
                }
                if (bl4) {
                    ++n6;
                    continue;
                }
                ++n5;
                ++n6;
            }
            Object var23_22 = null;
        }
        catch (Throwable throwable) {
            Object var23_23 = null;
            try {
                bufferedReader.close();
                Object var25_26 = null;
            }
            catch (Throwable throwable2) {
                Object var25_27 = null;
                bufferedWriter.close();
                throw throwable2;
            }
            bufferedWriter.close();
            throw throwable;
        }
        try {
            bufferedReader.close();
            Object var25_24 = null;
        }
        catch (Throwable throwable) {
            Object var25_25 = null;
            bufferedWriter.close();
            throw throwable;
        }
        bufferedWriter.close();
        if (bl) {
            return arrayList.toArray(new Difference[arrayList.size()]);
        }
        return null;
    }

    public void perform() {
        this.exec();
    }

    public void run() {
        throw new RuntimeException("Not implemented");
    }

    private static class MergeConflictFileWriter
    extends FilterWriter {
        private Difference[] conflicts;
        private int lineNumber;
        private int currentConflict;
        private String leftName;
        private String rightName;
        private FileObject fo;

        public MergeConflictFileWriter(Writer writer, FileObject fileObject, Difference[] differenceArray, String string, String string2) throws IOException {
            super(writer);
            this.conflicts = differenceArray;
            this.leftName = string;
            this.rightName = string2;
            this.lineNumber = 1;
            this.currentConflict = 0;
            if (this.lineNumber == differenceArray[this.currentConflict].getFirstStart()) {
                this.writeConflict(differenceArray[this.currentConflict]);
                ++this.currentConflict;
            }
            this.fo = fileObject;
        }

        public void write(String string) throws IOException {
            super.write(string);
            this.lineNumber += MergeConflictFileWriter.numChars('\n', string);
            if (this.currentConflict < this.conflicts.length && this.lineNumber >= this.conflicts[this.currentConflict].getFirstStart()) {
                this.writeConflict(this.conflicts[this.currentConflict]);
                ++this.currentConflict;
            }
        }

        private void writeConflict(Difference difference) throws IOException {
            super.write(ResolveConflictsExecutor.CHANGE_LEFT + this.leftName + "\n");
            super.write(difference.getFirstText());
            super.write("=======\n");
            super.write(difference.getSecondText());
            super.write(ResolveConflictsExecutor.CHANGE_RIGHT + this.rightName + "\n");
        }

        private static int numChars(char c, String string) {
            int n = 0;
            int n2 = string.indexOf(c);
            while (n2 >= 0 && n2 < string.length()) {
                ++n;
                n2 = string.indexOf(c, n2 + 1);
            }
            return n;
        }

        public void close() throws IOException {
            super.close();
            if (this.fo != null) {
                this.fo.refresh(true);
            }
        }
    }

    private static class MergeResultWriterInfo
    extends StreamSource {
        private File tempf1;
        private File tempf2;
        private File tempf3;
        private File outputFile;
        private File fileToRepairEntriesOf;
        private String mimeType;
        private String leftFileRevision;
        private String rightFileRevision;
        private FileObject fo;
        private FileLock lock;
        private Charset encoding;

        public MergeResultWriterInfo(File file, File file2, File file3, File file4, String string, String string2, String string3, FileObject fileObject, FileLock fileLock, Charset charset) {
            this.tempf1 = file;
            this.tempf2 = file2;
            this.tempf3 = file3;
            this.outputFile = file4;
            this.mimeType = string;
            this.leftFileRevision = string2;
            this.rightFileRevision = string3;
            this.fo = fileObject;
            this.lock = fileLock;
            if (charset == null) {
                charset = FileEncodingQuery.getEncoding((FileObject)FileUtil.toFileObject((File)file));
            }
            this.encoding = charset;
        }

        public String getName() {
            return this.outputFile.getName();
        }

        public String getTitle() {
            return NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Merge.titleResult");
        }

        public String getMIMEType() {
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            throw new IOException("No reader of merge result");
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            OutputStreamWriter outputStreamWriter = this.fo != null ? new OutputStreamWriter(this.fo.getOutputStream(this.lock), this.encoding) : new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), this.encoding);
            if (differenceArray == null || differenceArray.length == 0) {
                this.fileToRepairEntriesOf = this.outputFile;
                return outputStreamWriter;
            }
            return new MergeConflictFileWriter(outputStreamWriter, this.fo, differenceArray, this.leftFileRevision, this.rightFileRevision);
        }

        public void close() {
            this.tempf1.delete();
            this.tempf2.delete();
            this.tempf3.delete();
            if (this.lock != null) {
                this.lock.releaseLock();
                this.lock = null;
            }
            this.fo = null;
            if (this.fileToRepairEntriesOf != null) {
                this.repairEntries(this.fileToRepairEntriesOf);
                this.fileToRepairEntriesOf = null;
            }
        }

        private void repairEntries(File file) {
            ConflictResolvedAction.resolved(file);
        }
    }
}

