/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.repository;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.netbeans.modules.mercurial.config.Scrambler;
import org.netbeans.modules.mercurial.ui.repository.HgURL;

public class RepositoryConnection {
    private static final String RC_DELIMITER = "~=~";
    private HgURL url;
    private String externalCommand;
    private boolean savePassword;

    public RepositoryConnection(RepositoryConnection repositoryConnection) {
        this(repositoryConnection.url, repositoryConnection.externalCommand, repositoryConnection.savePassword);
    }

    public RepositoryConnection(String string) throws URISyntaxException {
        this(new HgURL(string), null, false);
    }

    public RepositoryConnection(String string, String string2, String string3, String string4, boolean bl) throws URISyntaxException {
        this(new HgURL(string, string2, string3), string4, bl);
    }

    public RepositoryConnection(HgURL hgURL, String string, boolean bl) {
        this.url = hgURL;
        this.externalCommand = string;
        this.savePassword = bl;
    }

    public HgURL getUrl() {
        return this.url;
    }

    String getUsername() {
        return this.url.getUsername();
    }

    String getPassword() {
        return this.url.getPassword();
    }

    public String getExternalCommand() {
        return this.externalCommand;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RepositoryConnection repositoryConnection = (RepositoryConnection)object;
        return this.url == repositoryConnection.url || this.url == null || this.url.equals(repositoryConnection.url);
    }

    public int hashCode() {
        int n = 3;
        n = 61 * n + (this.url != null ? this.url.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.url.toString();
    }

    private void parseUrlString(String string) throws MalformedURLException {
        int n = string.indexOf("://");
    }

    public static String getString(RepositoryConnection repositoryConnection) {
        String string = repositoryConnection.url.toUrlStringWithoutUserInfo();
        String string2 = repositoryConnection.getUsername();
        String string3 = repositoryConnection.getPassword();
        String string4 = repositoryConnection.getExternalCommand();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(RC_DELIMITER);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(RC_DELIMITER);
        if (string3 != null) {
            stringBuffer.append(Scrambler.getInstance().scramble(string3));
        }
        stringBuffer.append(RC_DELIMITER);
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(RC_DELIMITER);
        stringBuffer.append(RC_DELIMITER);
        return stringBuffer.toString();
    }

    public static RepositoryConnection parse(String string) throws URISyntaxException {
        String[] stringArray = string.split(RC_DELIMITER);
        int n = stringArray.length;
        String string2 = stringArray[0];
        String string3 = n > 1 && !stringArray[1].equals("") ? stringArray[1] : null;
        String string4 = n > 2 && !stringArray[2].equals("") ? Scrambler.getInstance().descramble(stringArray[2]) : null;
        String string5 = n > 3 && !stringArray[3].equals("") ? stringArray[3] : null;
        boolean bl = n > 4 && !stringArray[4].equals("") ? Boolean.parseBoolean(stringArray[4]) : true;
        return new RepositoryConnection(string2, string3, string3 != null ? string4 : null, string5, bl);
    }
}

