/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.merge;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.merge.MergeRevisions;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeAction
extends ContextAction {
    private final VCSContext context;

    public MergeAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    @Override
    public boolean isEnabled() {
        Set set;
        Set set2 = set = this.context != null ? this.context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(this.context) && set != null && set.size() != 0;
    }

    @Override
    public void performAction(ActionEvent actionEvent) {
        File[] fileArray = HgUtils.getActionRoots(this.context);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        final File file = Mercurial.getInstance().getRepositoryRoot(fileArray[0]);
        if (file == null) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW_INFO"));
            outputLogger.output("");
            outputLogger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        final File[] fileArray2 = HgUtils.filterForRepository(this.context, file, false);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                OutputLogger outputLogger = this.getLogger();
                try {
                    List<String> list = HgCommand.getHeadRevisions(file);
                    String string = null;
                    if (list.size() <= 1) {
                        outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
                        outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
                        outputLogger.output(NbBundle.getMessage(MergeAction.class, (String)"MSG_NOTHING_TO_MERGE"));
                        outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE"));
                        outputLogger.output("");
                        JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_NOTHING_TO_MERGE"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 1);
                        return;
                    }
                    MergeRevisions mergeRevisions = new MergeRevisions(file, fileArray2);
                    if (!mergeRevisions.showDialog()) {
                        return;
                    }
                    string = mergeRevisions.getSelectionRevision();
                    outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
                    outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
                    MergeAction.doMergeAction(file, string, outputLogger);
                    HgUtils.forceStatusRefreshProject(MergeAction.this.context);
                    outputLogger.output("");
                }
                catch (HgException hgException) {
                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                }
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_PROGRESS"));
    }

    public static void doMergeAction(File file, String string, OutputLogger outputLogger) throws HgException {
        List<String> list = HgCommand.doMerge(file, string);
        if (list != null && !list.isEmpty()) {
            outputLogger.output(list);
            MergeAction.handleMergeOutput(file, list, true, outputLogger);
        }
    }

    public static void handleMergeOutput(File file, List<String> list, boolean bl, OutputLogger outputLogger) throws HgException {
        if (list == null || list.isEmpty()) {
            return;
        }
        Boolean bl2 = false;
        Boolean bl3 = false;
        for (String string : list) {
            if (HgCommand.isMergeAbortUncommittedMsg(string)) {
                bl3 = true;
                outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_FAILED"));
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_UNCOMMITTED"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 2);
                break;
            }
            if (HgCommand.isMergeAbortMultipleHeadsMsg(string)) {
                bl3 = true;
                outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_FAILED"));
                break;
            }
            if (HgCommand.isMergeConflictMsg(string)) {
                bl2 = true;
                String string2 = null;
                if (Utilities.isWindows()) {
                    string2 = string.substring("merging".length(), string.length() - "failed!".length()).trim().replace("/", "\\");
                    string2 = file.getAbsolutePath() + File.separator + string2;
                } else {
                    string2 = string.substring("conflicts detected in ".length());
                }
                outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_CONFLICT", (Object)string2));
                HgCommand.createConflictFile(string2);
            }
            if (!HgCommand.isMergeUnavailableMsg(string)) continue;
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_UNAVAILABLE"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 2);
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_INFO"));
            outputLogger.outputLink(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_INFO_URL"));
        }
        if (bl2.booleanValue()) {
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE_CONFLICTS"));
        }
        if (!bl3.booleanValue() && !bl2.booleanValue() && bl) {
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE"));
        }
    }

    public static void printMergeWarning(List<String> list, OutputLogger outputLogger) {
        if (list == null || list.isEmpty() || list.size() <= 1) {
            return;
        }
        if (list.size() == 2) {
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_WARN_NEEDED", list));
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DO_NEEDED"));
        } else {
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_WARN_MULTIPLE_HEADS", (Object)list.size(), list));
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE_MULTIPLE_HEADS"));
        }
    }
}

