/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.util.HgCommand;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    public File getFileRevision(File file, String string) throws IOException {
        if (string.equals("-1")) {
            return null;
        }
        File file2 = Mercurial.getInstance().getRepositoryRoot(file);
        if ("LOCAL".equals(string)) {
            return file;
        }
        try {
            File file3 = File.createTempFile("tmp", "-" + file.getName());
            file3.deleteOnExit();
            if ("BASE".equals(string)) {
                HgCommand.doCat(file2, file, file3, null);
            } else {
                HgCommand.doCat(file2, file, file3, string, null);
            }
            if (file3.length() == 0L) {
                file3.delete();
                return null;
            }
            return file3;
        }
        catch (HgException hgException) {
            IOException iOException = new IOException();
            iOException.initCause(hgException);
            throw iOException;
        }
    }
}

