/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.ExceptionHandler;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialInterceptor
extends VCSInterceptor {
    private final FileStatusCache cache;
    private ConcurrentLinkedQueue<File> filesToRefresh = new ConcurrentLinkedQueue();
    private RequestProcessor.Task refreshTask;
    private static final RequestProcessor rp = new RequestProcessor("MercurialRefresh", 1, true);
    private final RequestProcessor parallelRP = new RequestProcessor("Mercurial FS handler", 50);
    private final HashSet<FileObject> dirStates = new HashSet(5);
    private static final boolean AUTOMATIC_REFRESH_ENABLED = !"true".equals(System.getProperty("versioning.mercurial.autoRefreshDisabled", "false"));
    private static final boolean FULL_REPO_SCAN_ENABLED = "true".equals(System.getProperty("versioning.mercurial.fullRepoScanEnabled", "false"));

    public MercurialInterceptor() {
        this.cache = Mercurial.getInstance().getFileStatusCache();
        this.refreshTask = rp.create((Runnable)new RefreshTask());
    }

    public boolean beforeDelete(File file) {
        Mercurial.LOG.fine("beforeDelete " + file);
        if (file == null) {
            return false;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        return !HgUtils.isIgnored(file, false);
    }

    public void doDelete(File file) throws IOException {
        Mercurial.LOG.fine("doDelete " + file);
        if (file == null) {
            return;
        }
        Mercurial mercurial = Mercurial.getInstance();
        File file2 = mercurial.getRepositoryRoot(file);
        try {
            file.delete();
            HgCommand.doRemove(file2, file, null);
        }
        catch (HgException hgException) {
            Mercurial.LOG.log(Level.FINE, "doDelete(): File: {0} {1}", new Object[]{file.getAbsolutePath(), hgException.toString()});
        }
    }

    public void afterDelete(File file) {
        Mercurial.LOG.fine("afterDelete " + file);
        if (file == null) {
            return;
        }
        if (HgUtils.isIgnored(file, false)) {
            if (Mercurial.LOG.isLoggable(Level.FINER)) {
                Mercurial.LOG.log(Level.FINE, "skipping afterDelete(): File: {0} is ignored", new Object[]{file.getAbsolutePath()});
            }
            return;
        }
        this.reScheduleRefresh(800, file);
    }

    public boolean beforeMove(File file, File file2) {
        Mercurial.LOG.fine("beforeMove " + file + "->" + file2);
        if (file == null || file2 == null || file2.exists()) {
            return true;
        }
        Mercurial mercurial = Mercurial.getInstance();
        if (mercurial.isManaged(file)) {
            return mercurial.isManaged(file2);
        }
        return super.beforeMove(file, file2);
    }

    public void doMove(final File file, final File file2) throws IOException {
        Mercurial.LOG.fine("doMove " + file + "->" + file2);
        if (file == null || file2 == null || file2.exists()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Mercurial.LOG.log(Level.INFO, "Warning: launching external process in AWT", new Exception().fillInStackTrace());
            final Throwable[] throwableArray = new Throwable[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        MercurialInterceptor.this.hgMoveImplementation(file, file2);
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                }
            };
            this.parallelRP.post(runnable).waitFinished();
            if (throwableArray[0] != null) {
                if (throwableArray[0] instanceof IOException) {
                    throw (IOException)throwableArray[0];
                }
                if (throwableArray[0] instanceof RuntimeException) {
                    throw (RuntimeException)throwableArray[0];
                }
                if (throwableArray[0] instanceof Error) {
                    throw (Error)throwableArray[0];
                }
                throw new IllegalStateException("Unexpected exception class: " + throwableArray[0]);
            }
        } else {
            this.hgMoveImplementation(file, file2);
        }
    }

    private void hgMoveImplementation(final File file, final File file2) throws IOException {
        Mercurial mercurial = Mercurial.getInstance();
        final File file3 = mercurial.getRepositoryRoot(file);
        final File file4 = mercurial.getRepositoryRoot(file2);
        if (file3 == null) {
            return;
        }
        RequestProcessor requestProcessor = mercurial.getRequestProcessor(file3);
        Mercurial.LOG.log(Level.FINE, "hgMoveImplementation(): File: {0} {1}", new Object[]{file, file2});
        file.renameTo(file2);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                OutputLogger outputLogger = OutputLogger.getLogger(file3.getAbsolutePath());
                try {
                    if (file3.equals(file4)) {
                        HgCommand.doRenameAfter(file3, file, file2, outputLogger);
                    }
                }
                catch (HgException hgException) {
                    Mercurial.LOG.log(Level.FINE, "Mercurial failed to rename: File: {0} {1}", new Object[]{file.getAbsolutePath(), file2.getAbsolutePath()});
                }
                finally {
                    outputLogger.closeLog();
                }
            }
        };
        requestProcessor.post(runnable);
    }

    public void afterMove(File file, File file2) {
        Mercurial.LOG.fine("afterMove " + file + "->" + file2);
        if (file == null || file2 == null || !file2.exists()) {
            return;
        }
        if (file2.isDirectory()) {
            return;
        }
        File file3 = file.getParentFile();
        if (file3 != null && !HgUtils.isIgnored(file3, false)) {
            this.reScheduleRefresh(800, file);
        }
        if ((file3 = file2.getParentFile()) != null && !HgUtils.isIgnored(file3, false)) {
            this.reScheduleRefresh(800, file2);
        }
    }

    public boolean beforeCreate(final File file, boolean bl) {
        FileInformation fileInformation;
        Mercurial.LOG.fine("beforeCreate " + file + " " + bl);
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        if (!bl && !file.exists() && (fileInformation = this.cache.getCachedStatus(file)) != null && fileInformation.getStatus() == 256) {
            Mercurial.LOG.log(Level.FINE, "beforeCreate(): LocallyDeleted: {0}", file);
            Mercurial mercurial = Mercurial.getInstance();
            final File file2 = mercurial.getRepositoryRoot(file);
            if (file2 == null) {
                return false;
            }
            final OutputLogger outputLogger = Mercurial.getInstance().getLogger(file2.getAbsolutePath());
            final Throwable[] throwableArray = new Throwable[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        ArrayList<File> arrayList = new ArrayList<File>();
                        arrayList.add(file);
                        HgCommand.doRevert(file2, arrayList, null, false, outputLogger);
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                }
            };
            this.parallelRP.post(runnable).waitFinished();
            if (throwableArray[0] != null) {
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): File: {0} {1}", new Object[]{file.getAbsolutePath(), throwableArray[0].toString()});
            }
            Mercurial.LOG.log(Level.FINE, "beforeCreate(): afterWaitFinished: {0}", file);
            outputLogger.closeLog();
            file.delete();
        }
        return false;
    }

    public void doCreate(File file, boolean bl) throws IOException {
        Mercurial.LOG.fine("doCreate " + file + " " + bl);
        super.doCreate(file, bl);
    }

    public void afterCreate(File file) {
        Mercurial.LOG.fine("afterCreate " + file);
        if (file.isDirectory()) {
            return;
        }
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(800, file);
        }
    }

    public void afterChange(File file) {
        if (file.isDirectory()) {
            return;
        }
        Mercurial.LOG.log(Level.FINE, "afterChange(): {0}", file);
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(800, file);
        }
    }

    public Object getAttribute(final File file, String string) {
        if ("ProvidedExtensions.RemoteLocation".equals(string)) {
            return this.getRemoteRepository(file);
        }
        if ("ProvidedExtensions.Refresh".equals(string)) {
            return new Runnable(){

                public void run() {
                    try {
                        File file2 = Mercurial.getInstance().getRepositoryRoot(file);
                        if (file2 == null) {
                            return;
                        }
                        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
                        fileStatusCache.refreshCached(file);
                        StatusAction.refreshFile(file, file2, null, fileStatusCache);
                    }
                    catch (HgException hgException) {
                        ExceptionHandler exceptionHandler = new ExceptionHandler(hgException);
                        exceptionHandler.notifyException();
                    }
                }
            };
        }
        return super.getAttribute(file, string);
    }

    private String getRemoteRepository(File file) {
        return HgUtils.getRemoteRepository(file);
    }

    public Boolean isRefreshScheduled(File file) {
        return this.filesToRefresh.contains(file);
    }

    private void reScheduleRefresh(int n, File file) {
        if (!"false".equals(System.getProperty("mercurial.onEventRefreshRoot"))) {
            Mercurial.STATUS_LOG.fine("reScheduleRefresh: adding " + file.getAbsolutePath());
            if (HgUtils.isPartOfMercurialMetadata(file)) {
                if ("dirstate".equals(file.getName())) {
                    Mercurial.STATUS_LOG.fine("special FS event handling for " + file.getAbsolutePath());
                }
            } else {
                this.filesToRefresh.add(file);
            }
        } else {
            File file2 = file.getParentFile();
            if (!this.filesToRefresh.contains(file2) && !this.filesToRefresh.offer(file2)) {
                Mercurial.LOG.log(Level.FINE, "reScheduleRefresh failed to add to filesToRefresh queue {0}", file);
            }
        }
        this.refreshTask.schedule(n);
    }

    void pingRepositoryRootFor(final File file) {
        if (!AUTOMATIC_REFRESH_ENABLED) {
            return;
        }
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                File file3 = Mercurial.getInstance().getRepositoryRoot(file);
                if (file3 != null) {
                    File file2 = new File(new File(file3, ".hg"), "dirstate");
                    FileObject fileObject = FileUtil.toFileObject((File)file2);
                    HashSet hashSet = MercurialInterceptor.this.dirStates;
                    synchronized (hashSet) {
                        if (!MercurialInterceptor.this.dirStates.contains(fileObject)) {
                            Mercurial.STATUS_LOG.fine("pingRepositoryRootFor: planning a scan for " + file3.getAbsolutePath() + " - " + file.getAbsolutePath());
                            MercurialInterceptor.this.reScheduleRefresh(2000, file3);
                            if (fileObject != null && fileObject.isValid() && fileObject.isData()) {
                                MercurialInterceptor.this.dirStates.add(fileObject);
                            }
                        }
                    }
                }
            }
        });
    }

    private void refreshAll(Set<File> set) {
        long l = 0L;
        if (Mercurial.STATUS_LOG.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis();
            Mercurial.STATUS_LOG.fine("refreshAll: starting for " + set.size() + " files.");
        }
        if (set.isEmpty()) {
            return;
        }
        HashMap<File, Set<File>> hashMap = new HashMap<File, Set<File>>(5);
        for (File file : set) {
            file = FileUtil.normalizeFile((File)file);
            File file2 = Mercurial.getInstance().getRepositoryRoot(file);
            assert (file2 != null);
            Set<File> set2 = hashMap.get(file2);
            if (set2 == null) {
                set2 = new HashSet<File>();
                hashMap.put(file2, set2);
            }
            boolean bl = false;
            for (File file3 : set2) {
                File file4 = file;
                File file5 = file3;
                bl = true;
                if (file4.equals(file5) || file5.equals(file2)) break;
                if (file4.equals(file2)) {
                    file5 = file4;
                } else {
                    if (file.getAbsolutePath().length() < file3.getAbsolutePath().length()) {
                        file5 = file;
                        file4 = file3;
                    }
                    if (!Utils.isAncestorOrEqual((File)file5, (File)file4)) {
                        file5 = Utils.getCommonParent((File)file4, (File)file5);
                    }
                }
                if (file5 == file3) break;
                if (!FULL_REPO_SCAN_ENABLED && file5 != file4 && file5.equals(file2)) {
                    bl = false;
                    continue;
                }
                if (file5 != null) {
                    if (file5.equals(file2)) {
                        set2.clear();
                    } else {
                        set2.remove(file3);
                    }
                    set2.add(file5);
                    break;
                }
                bl = false;
            }
            if (bl) continue;
            set2.add(file);
        }
        if (Mercurial.STATUS_LOG.isLoggable(Level.FINE)) {
            Mercurial.STATUS_LOG.fine("refreshAll: starting status scan for " + hashMap.values() + " after " + (System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
        }
        if (!hashMap.isEmpty()) {
            this.cache.refreshAllRoots(hashMap);
        }
        if (Mercurial.STATUS_LOG.isLoggable(Level.FINE)) {
            Mercurial.STATUS_LOG.fine("refreshAll: finishes status scan after " + (System.currentTimeMillis() - l));
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        public void run() {
            Thread.interrupted();
            if (DelayScanRegistry.getInstance().isDelayed(MercurialInterceptor.this.refreshTask, Mercurial.STATUS_LOG, "MercurialInterceptor.refreshTask")) {
                return;
            }
            if (!"false".equals(System.getProperty("mercurial.onEventRefreshRoot"))) {
                File file;
                HashSet<File> hashSet = new HashSet<File>(MercurialInterceptor.this.filesToRefresh.size());
                while ((file = (File)MercurialInterceptor.this.filesToRefresh.poll()) != null) {
                    hashSet.add(file);
                }
                MercurialInterceptor.this.refreshAll(hashSet);
            } else {
                File file = (File)MercurialInterceptor.this.filesToRefresh.poll();
                if (file != null) {
                    Mercurial.LOG.log(Level.INFO, "RefreshTask called refreshAll {0}", file);
                    MercurialInterceptor.this.cache.refreshAll(file);
                    file = (File)MercurialInterceptor.this.filesToRefresh.peek();
                    if (file != null) {
                        MercurialInterceptor.this.refreshTask.schedule(0);
                    }
                }
            }
        }
    }
}

