/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.dataprovider;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.module.dlight.threads.api.Datarace;
import org.netbeans.module.dlight.threads.api.Deadlock;
import org.netbeans.module.dlight.threads.dataprovider.ThreadAnalyzerDataProvider;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.management.remote.spi.PathMapper;
import org.netbeans.modules.dlight.management.remote.spi.PathMapperProvider;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.dataprovider.SSMetrics;
import org.netbeans.modules.dlight.perfan.lineinfo.impl.SSSourceFileInfoSupport;
import org.netbeans.modules.dlight.perfan.spi.datafilter.HotSpotFunctionsFilter;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.Address;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintCommand;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.PerfanDataStorage;
import org.netbeans.modules.dlight.perfan.util.Computable;
import org.netbeans.modules.dlight.perfan.util.TasksCachedProcessor;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SSStackDataProvider
implements StackDataProvider,
ThreadAnalyzerDataProvider {
    private static final Logger log = DLightLogger.getLogger(SSStackDataProvider.class);
    private static final Pattern fullInfoPattern = Pattern.compile("^(.*), line ([0-9]+) in \"(.*)\"");
    private static final Pattern noLineInfoPattern = Pattern.compile("^<Function: (.*), instructions from source file (.*)>");
    private static final Pattern noDebugInfoPattern = Pattern.compile("^<Function: (.*), instructions without line numbers>");
    private static final List<FunctionMetric> metricsList = Arrays.asList(SSMetrics.TimeMetric.UserFuncTimeExclusive, SSMetrics.TimeMetric.UserFuncTimeInclusive, SSMetrics.TimeMetric.SyncWaitCallInclusive, SSMetrics.TimeMetric.SyncWaitTimeInclusive, SSMetrics.TimeMetric.SyncWaitCallExclusive, SSMetrics.TimeMetric.SyncWaitTimeExclusive, SSMetrics.MemoryMetric.LeakBytesMetric, SSMetrics.MemoryMetric.LeaksCountMetric);
    private static boolean ompSupport = Boolean.valueOf(System.getProperty("dlight.sunstudio.omp"));
    private final Computable<HotSpotFunctionsFetcherParams, List<FunctionCallWithMetric>> hotSpotFunctionsFetcher = new TasksCachedProcessor<HotSpotFunctionsFetcherParams, List<FunctionCallWithMetric>>(new HotSpotFunctionsFetcher(), true);
    private final HashMap<Long, SourceFileInfoProvider.SourceFileInfo> nonSSSourceInfoCache = new HashMap();
    private PerfanDataStorage storage;
    private SSSourceFileInfoSupport sourceFileInfoSupport = null;
    private PathMapper pathMapper = null;
    private Map<String, String> serviceInfo = null;
    private volatile HotSpotFunctionsFilter filter;
    private volatile TimeIntervalDataFilter timeIntervalDataFilter;

    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        if (serviceInfoDataStorage == null) {
            throw new NullPointerException();
        }
        String string = serviceInfoDataStorage.getValue("service.storage.execution.env.key");
        ExecutionEnvironment executionEnvironment = string == null ? ExecutionEnvironmentFactory.getLocal() : ExecutionEnvironmentFactory.fromUniqueID((String)string);
        PathMapperProvider pathMapperProvider = (PathMapperProvider)Lookup.getDefault().lookup(PathMapperProvider.class);
        this.pathMapper = pathMapperProvider == null ? null : pathMapperProvider.getPathMapper(executionEnvironment);
        this.serviceInfo = Collections.unmodifiableMap(serviceInfoDataStorage.getInfo());
        this.nonSSSourceInfoCache.clear();
    }

    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
        boolean bl2 = false;
        for (DataFilter dataFilter : list) {
            if (dataFilter instanceof HotSpotFunctionsFilter) {
                this.filter = (HotSpotFunctionsFilter)dataFilter;
            }
            if (!(dataFilter instanceof TimeIntervalDataFilter)) continue;
            this.timeIntervalDataFilter = (TimeIntervalDataFilter)dataFilter;
            bl2 = true;
        }
        if (!bl2 && this.timeIntervalDataFilter != null) {
            if (this.storage != null) {
                this.storage.setFilter("\"\"");
            }
            this.timeIntervalDataFilter = null;
        }
        if (bl2 && this.timeIntervalDataFilter != null) {
            Range range = this.timeIntervalDataFilter.getInterval();
            if (range.getStart() != null || range.getEnd() != null) {
                this.storage.setFilter(range.toString(null, "TSTAMP>%d", "&&", "TSTAMP<%d", null));
            } else {
                this.storage.setFilter(null);
            }
        }
    }

    public ThreadDumpProvider getThreadDumpProvider() {
        return null;
    }

    public List<FunctionCallWithMetric> getCallers(List<FunctionCallWithMetric> list, List<DataTableMetadata.Column> list2, List<DataTableMetadata.Column> list3, boolean bl) {
        return this.getCallersCallees(CC_MODE.CALLERS, list, bl);
    }

    public List<FunctionCallWithMetric> getCallees(List<FunctionCallWithMetric> list, List<DataTableMetadata.Column> list2, List<DataTableMetadata.Column> list3, boolean bl) {
        return this.getCallersCallees(CC_MODE.CALLEES, list, bl);
    }

    public List<FunctionCall> getCallStack(int n) {
        return Collections.emptyList();
    }

    public List<FunctionCallTreeTableNode> getTableView(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n) {
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.getFunctionCalls(list, list2, n));
    }

    public List<FunctionCallTreeTableNode> getChildren(List<FunctionCallTreeTableNode> list, List<DataTableMetadata.Column> list2, List<DataTableMetadata.Column> list3) {
        List list4 = FunctionCallTreeTableNode.getFunctionCalls(list);
        List<FunctionCallWithMetric> list5 = this.getCallers(list4, list2, list3, false);
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(list5);
    }

    public FunctionCallTreeTableNode getValueAt(int n) {
        return null;
    }

    public String getTableValueAt(DataTableMetadata.Column column, int n) {
        return null;
    }

    private synchronized List<FunctionCallWithMetric> getCallersCallees(CC_MODE cC_MODE, List<FunctionCallWithMetric> list, boolean bl) {
        return Collections.emptyList();
    }

    public List<FunctionCallWithMetric> getFunctionCalls(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n) {
        List<FunctionCallWithMetric> list3 = Collections.emptyList();
        try {
            list3 = this.hotSpotFunctionsFetcher.compute(new HotSpotFunctionsFetcherParams(ErprintCommand.lines(), list, list2, n, this.filter));
        }
        catch (InterruptedException interruptedException) {
            log.fine("HotSpotFunctionsFetcher interrupted");
        }
        return list3;
    }

    public List<FunctionCallWithMetric> getHotSpotFunctions(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n) {
        try {
            return this.hotSpotFunctionsFetcher.compute(new HotSpotFunctionsFetcherParams(ErprintCommand.functions(), list, list2, n, this.filter));
        }
        catch (InterruptedException interruptedException) {
            log.fine("HotSpotFunctionsFetcher interrupted.");
            return Collections.emptyList();
        }
    }

    public List<? extends Deadlock> getDeadlocks() {
        return this.storage.getDeadlocks();
    }

    public List<? extends Datarace> getDataraces() {
        return this.storage.getDataraces();
    }

    private FunctionMetric getMetricInstance(String string) {
        for (FunctionMetric functionMetric : metricsList) {
            if (!functionMetric.getMetricID().equals(string)) continue;
            return functionMetric;
        }
        return null;
    }

    public List<FunctionMetric> getMetricsList() {
        return metricsList;
    }

    public void attachTo(DataStorage dataStorage) {
        if (!(dataStorage instanceof PerfanDataStorage)) {
            String string = "Attempt to attach SSStackDataProvider to storage '" + dataStorage + "'";
            throw new IllegalArgumentException(string);
        }
        this.storage = (PerfanDataStorage)dataStorage;
        this.sourceFileInfoSupport = SSSourceFileInfoSupport.getSourceFileInfoSupportFor(this.storage);
        this.nonSSSourceInfoCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCall functionCall) {
        if (this.sourceFileInfoSupport == null) {
            return null;
        }
        if (!(functionCall instanceof FunctionCallImpl)) {
            return null;
        }
        FunctionCallImpl functionCallImpl = (FunctionCallImpl)functionCall;
        Long l = functionCallImpl.getFunctionRefID();
        SourceFileInfoProvider.SourceFileInfo sourceFileInfo = this.sourceFileInfoSupport.getSourceFileInfo(functionCallImpl, this.pathMapper);
        if (sourceFileInfo == null || !sourceFileInfo.isSourceKnown()) {
            HashMap<Long, SourceFileInfoProvider.SourceFileInfo> hashMap = this.nonSSSourceInfoCache;
            synchronized (hashMap) {
                if (this.nonSSSourceInfoCache.containsKey(l)) {
                    sourceFileInfo = this.nonSSSourceInfoCache.get(l);
                } else {
                    Collection collection = Lookup.getDefault().lookupAll(SourceFileInfoProvider.class);
                    for (SourceFileInfoProvider sourceFileInfoProvider : collection) {
                        sourceFileInfo = sourceFileInfoProvider.getSourceFileInfo(functionCall.getFunction().getQuilifiedName(), (int)functionCall.getOffset(), -1L, this.serviceInfo);
                        if (sourceFileInfo == null || !sourceFileInfo.isSourceKnown()) continue;
                        log.finest("SourceLineInfo data from " + sourceFileInfoProvider.getClass().getSimpleName() + ": " + sourceFileInfo.toString());
                        break;
                    }
                    this.nonSSSourceInfoCache.put(l, sourceFileInfo);
                }
            }
        }
        functionCallImpl.setSourceFileInfo(sourceFileInfo);
        return sourceFileInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HotSpotFunctionsFetcher
    implements Computable<HotSpotFunctionsFetcherParams, List<FunctionCallWithMetric>> {
        private final DecimalFormat df = new DecimalFormat();

        public HotSpotFunctionsFetcher() {
            DecimalFormatSymbols decimalFormatSymbols = this.df.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            this.df.setDecimalFormatSymbols(decimalFormatSymbols);
        }

        @Override
        public List<FunctionCallWithMetric> compute(HotSpotFunctionsFetcherParams hotSpotFunctionsFetcherParams) throws InterruptedException {
            Serializable serializable;
            Object object;
            String string;
            Serializable serializable2;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String[] stringArray;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Started to fetch Hot Spot Functions @ " + Thread.currentThread());
            }
            Metrics metrics = hotSpotFunctionsFetcherParams.metrics;
            String[] stringArray2 = null;
            try {
                stringArray2 = SSStackDataProvider.this.storage.getTopFunctions(hotSpotFunctionsFetcherParams.command, metrics, hotSpotFunctionsFetcherParams.limit);
            }
            catch (InterruptedException interruptedException) {
                log.finest("Fetching Interrupted! Hot Spot Functions @ " + Thread.currentThread());
                return null;
            }
            int n = stringArray2 == null || stringArray2.length == 0 ? 0 : Math.min(stringArray2.length, hotSpotFunctionsFetcherParams.limit);
            ArrayList<FunctionCallWithMetric> arrayList = new ArrayList<FunctionCallWithMetric>(n);
            DataTableMetadata.Column column = (DataTableMetadata.Column)hotSpotFunctionsFetcherParams.orderBy.get(0);
            for (int i = 0; i < n; ++i) {
                Object object6;
                int n2 = -1;
                String string2 = null;
                stringArray = stringArray2[i].split("[ \t]+", hotSpotFunctionsFetcherParams.nameIdx + 1);
                object5 = stringArray[hotSpotFunctionsFetcherParams.nameIdx];
                if (!hotSpotFunctionsFetcherParams.isDefaultCommand() && ErprintCommand.lines().equals(hotSpotFunctionsFetcherParams.command)) {
                    object6 = fullInfoPattern.matcher((CharSequence)object5);
                    if (((Matcher)object6).matches()) {
                        object5 = ((Matcher)object6).group(1);
                        n2 = Integer.valueOf(((Matcher)object6).group(2));
                        string2 = ((Matcher)object6).group(3);
                    } else {
                        if (SSStackDataProvider.this.filter != null && SSStackDataProvider.this.filter.getType() == HotSpotFunctionsFilter.CollectedDataType.WITHSOURCECODEONLY) continue;
                        object6 = noLineInfoPattern.matcher((CharSequence)object5);
                        if (((Matcher)object6).matches()) {
                            object5 = ((Matcher)object6).group(1);
                            string2 = ((Matcher)object6).group(2);
                        } else {
                            object6 = noDebugInfoPattern.matcher((CharSequence)object5);
                            if (!((Matcher)object6).matches()) continue;
                            object5 = ((Matcher)object6).group(1);
                        }
                    }
                }
                FunctionImpl functionImpl = new FunctionImpl((String)object5, (object6 = Address.parse(stringArray[hotSpotFunctionsFetcherParams.addressIdx] + stringArray[hotSpotFunctionsFetcherParams.addressIdx + 1])) == null ? (long)((String)object5).hashCode() : ((Address)object6).getAddress());
                object4 = new HashMap<FunctionMetric, Object>();
                boolean bl = false;
                for (int j = 0; j < hotSpotFunctionsFetcherParams.requestColumns.size(); ++j) {
                    object3 = (DataTableMetadata.Column)hotSpotFunctionsFetcherParams.requestColumns.get(j);
                    if (object3.equals(SunStudioDCConfiguration.c_name)) continue;
                    object2 = object3.getColumnName();
                    serializable2 = object3.getColumnClass();
                    FunctionMetric functionMetric = SSStackDataProvider.this.getMetricInstance((String)object2);
                    boolean bl2 = object3.equals(column);
                    string = stringArray[hotSpotFunctionsFetcherParams.columnsIdxRef[j]];
                    object = string;
                    try {
                        serializable = this.df.parse(string);
                        if (Integer.class == serializable2) {
                            if (bl2 && serializable.intValue() == 0) {
                                bl = true;
                            }
                            object = serializable.intValue();
                        } else if (Double.class == serializable2) {
                            if (bl2 && serializable.doubleValue() == 0.0) {
                                bl = true;
                            }
                            object = serializable.doubleValue();
                        } else if (Float.class == serializable2) {
                            if (bl2 && serializable.floatValue() == 0.0f) {
                                bl = true;
                            }
                            object = Float.valueOf(serializable.floatValue());
                        } else if (Long.class == serializable2) {
                            if (bl2 && serializable.longValue() == 0L) {
                                bl = true;
                            }
                            object = serializable.longValue();
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    object4.put(functionMetric, object);
                }
                if (bl) continue;
                FunctionCallImpl functionCallImpl = new FunctionCallImpl(functionImpl, n2, (Map<FunctionMetric, Object>)object4);
                if (string2 != null) {
                    functionCallImpl.setSourceFileInfo(new SourceFileInfoProvider.SourceFileInfo((CharSequence)string2, n2, 0));
                }
                arrayList.add(functionCallImpl);
            }
            DataTableMetadata.Column column2 = null;
            List<DataTableMetadata.Column> list = null;
            int n3 = Integer.MAX_VALUE;
            if (ompSupport && SSStackDataProvider.this.storage.hasOMPCollected()) {
                if (metrics.getMspec().indexOf(SunStudioDCConfiguration.c_eSync.getColumnName()) != -1 && metrics.getMsort().indexOf(SunStudioDCConfiguration.c_eSync.getColumnName()) != -1) {
                    column2 = SunStudioDCConfiguration.c_iOMPWait;
                    list = Arrays.asList(SunStudioDCConfiguration.c_iOMPWait, SunStudioDCConfiguration.c_name);
                }
                if (metrics.getMspec().indexOf(SunStudioDCConfiguration.c_eUser.getColumnName()) != -1 && metrics.getMsort().indexOf(SunStudioDCConfiguration.c_eUser.getColumnName()) != -1) {
                    column2 = SunStudioDCConfiguration.c_iOMPWork;
                    list = Arrays.asList(SunStudioDCConfiguration.c_iOMPWork, SunStudioDCConfiguration.c_name);
                }
                stringArray = null;
                object5 = null;
                try {
                    if (list != null) {
                        object5 = new HotSpotFunctionsFetcherParams(hotSpotFunctionsFetcherParams.command, list, Arrays.asList(column2), n3, SSStackDataProvider.this.filter);
                        stringArray = SSStackDataProvider.this.storage.getTopFunctions(((HotSpotFunctionsFetcherParams)object5).command, ((HotSpotFunctionsFetcherParams)object5).metrics, n3);
                    }
                }
                catch (InterruptedException interruptedException) {
                    log.finest("Fetching Interrupted! Hot Spot Functions @ " + Thread.currentThread());
                }
                n3 = stringArray == null || stringArray.length == 0 ? 0 : stringArray.length;
                for (int i = 0; i < n3; ++i) {
                    int n4 = -1;
                    object4 = null;
                    String[] stringArray3 = stringArray[i].split("[ \t]+", ((HotSpotFunctionsFetcherParams)object5).nameIdx + 1);
                    String string3 = stringArray3[((HotSpotFunctionsFetcherParams)object5).nameIdx];
                    if (!hotSpotFunctionsFetcherParams.isDefaultCommand() && ErprintCommand.lines().equals(((HotSpotFunctionsFetcherParams)object5).command)) {
                        object3 = fullInfoPattern.matcher(string3);
                        if (((Matcher)object3).matches()) {
                            string3 = ((Matcher)object3).group(1);
                            n4 = Integer.valueOf(((Matcher)object3).group(2));
                            object4 = ((Matcher)object3).group(3);
                        } else {
                            if (SSStackDataProvider.this.filter != null && SSStackDataProvider.this.filter.getType() == HotSpotFunctionsFilter.CollectedDataType.WITHSOURCECODEONLY) continue;
                            object3 = noLineInfoPattern.matcher(string3);
                            if (((Matcher)object3).matches()) {
                                string3 = ((Matcher)object3).group(1);
                                object4 = ((Matcher)object3).group(2);
                            } else {
                                object3 = noDebugInfoPattern.matcher(string3);
                                if (!((Matcher)object3).matches()) continue;
                                string3 = ((Matcher)object3).group(1);
                            }
                        }
                    }
                    object2 = new FunctionImpl(string3, (object3 = Address.parse(stringArray3[((HotSpotFunctionsFetcherParams)object5).addressIdx] + stringArray3[((HotSpotFunctionsFetcherParams)object5).addressIdx + 1])) == null ? (long)string3.hashCode() : ((Address)object3).getAddress());
                    serializable2 = new HashMap();
                    boolean bl = false;
                    for (int j = 0; j < ((HotSpotFunctionsFetcherParams)object5).requestColumns.size(); ++j) {
                        string = (DataTableMetadata.Column)((HotSpotFunctionsFetcherParams)object5).requestColumns.get(j);
                        if (string.equals(SunStudioDCConfiguration.c_name)) continue;
                        object = string.getColumnName();
                        serializable = string.getColumnClass();
                        FunctionMetric functionMetric = SSStackDataProvider.this.getMetricInstance((String)object);
                        if (SunStudioDCConfiguration.c_iOMPWait.getColumnName().equals(object)) {
                            functionMetric = SSStackDataProvider.this.getMetricInstance(SunStudioDCConfiguration.c_eSync.getColumnName());
                        } else if (SunStudioDCConfiguration.c_iOMPWork.getColumnName().equals(object)) {
                            functionMetric = SSStackDataProvider.this.getMetricInstance(SunStudioDCConfiguration.c_eUser.getColumnName());
                        }
                        boolean bl3 = string.equals(column2);
                        String string4 = stringArray3[((HotSpotFunctionsFetcherParams)object5).columnsIdxRef[j]];
                        Object object7 = string4;
                        try {
                            Number number = this.df.parse(string4);
                            if (Integer.class == serializable) {
                                if (bl3 && number.intValue() == 0) {
                                    bl = true;
                                }
                                object7 = number.intValue();
                            } else if (Double.class == serializable) {
                                if (bl3 && number.doubleValue() == 0.0) {
                                    bl = true;
                                }
                                object7 = number.doubleValue();
                            } else if (Float.class == serializable) {
                                if (bl3 && number.floatValue() == 0.0f) {
                                    bl = true;
                                }
                                object7 = Float.valueOf(number.floatValue());
                            } else if (Long.class == serializable) {
                                if (bl3 && number.longValue() == 0L) {
                                    bl = true;
                                }
                                object7 = number.longValue();
                            }
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        serializable2.put(functionMetric, object7);
                    }
                    if (bl) continue;
                    FunctionCallImpl functionCallImpl = new FunctionCallImpl((FunctionImpl)object2, n4, (Map<FunctionMetric, Object>)((Object)serializable2));
                    if (object4 != null) {
                        functionCallImpl.setSourceFileInfo(new SourceFileInfoProvider.SourceFileInfo((CharSequence)object4, n4, 0));
                    }
                    arrayList.add(functionCallImpl);
                }
            }
            log.fine("Done with Hot Spot Functions fetching");
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HotSpotFunctionsFetcherParams {
        private final ErprintCommand command;
        private final List<DataTableMetadata.Column> resultColumns;
        private final List<DataTableMetadata.Column> requestColumns;
        private final int[] columnsIdxRef;
        private final List<DataTableMetadata.Column> orderBy;
        private final int limit;
        private final Metrics metrics;
        private final int nameIdx;
        private final int addressIdx;
        private final HotSpotFunctionsFilter filter;

        HotSpotFunctionsFetcherParams(ErprintCommand erprintCommand, List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n, HotSpotFunctionsFilter hotSpotFunctionsFilter) {
            if (list == null) {
                throw new NullPointerException();
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException("HotSpotFunctionsFetcherParams: empty columns list!");
            }
            this.resultColumns = new ArrayList<DataTableMetadata.Column>();
            int n2 = list.size();
            this.columnsIdxRef = new int[n2];
            int n3 = -1;
            int n4 = -1;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                DataTableMetadata.Column column = list.get(i);
                if (column.equals(SunStudioDCConfiguration.c_address)) {
                    n4 = i;
                    continue;
                }
                if (column.equals(SunStudioDCConfiguration.c_name)) {
                    n3 = i;
                    continue;
                }
                this.resultColumns.add(column);
                this.columnsIdxRef[i] = n5++;
            }
            if (n4 == -1) {
                this.resultColumns.add(SunStudioDCConfiguration.c_address);
                n4 = n5;
            } else {
                this.resultColumns.add(list.get(n4));
                this.columnsIdxRef[n4] = n5;
            }
            this.addressIdx = n5;
            n5 += 2;
            if (n3 == -1) {
                this.resultColumns.add(SunStudioDCConfiguration.c_name);
                n3 = n5;
            } else {
                this.resultColumns.add(list.get(n3));
                this.columnsIdxRef[n3] = n5;
            }
            this.nameIdx = n5++;
            this.command = erprintCommand == null ? ErprintCommand.functions() : erprintCommand;
            this.requestColumns = list;
            this.orderBy = list2 == null ? Arrays.asList(list.get(0)) : list2;
            this.limit = n;
            this.metrics = Metrics.constructFrom(this.resultColumns, list2);
            this.filter = hotSpotFunctionsFilter;
        }

        boolean isDefaultCommand() {
            return ErprintCommand.functions().equals(this.command);
        }

        public boolean equals(Object object) {
            if (!(object instanceof HotSpotFunctionsFetcherParams)) {
                throw new IllegalArgumentException();
            }
            HotSpotFunctionsFetcherParams hotSpotFunctionsFetcherParams = (HotSpotFunctionsFetcherParams)object;
            return hotSpotFunctionsFetcherParams.metrics.equals(this.metrics) && hotSpotFunctionsFetcherParams.limit == this.limit;
        }

        public int hashCode() {
            int n = 3;
            n = 71 * n + this.limit;
            n = 71 * n + (this.metrics != null ? this.metrics.hashCode() : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CC_MODE {
        CALLEES,
        CALLERS;

    }
}

