/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import java.util.Stack;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranStackEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FortranBracesStack
implements Cloneable {
    private static final boolean TRACE_STACK = false;
    private static final int FIXED_FORMAT_SHIFT = 6;
    private Stack<FortranStackEntry> stack = new Stack();
    private FortranCodeStyle codeStyle;
    int parenDepth = 0;

    FortranBracesStack(FortranCodeStyle fortranCodeStyle) {
        this.codeStyle = fortranCodeStyle;
    }

    public FortranBracesStack clone() {
        FortranBracesStack fortranBracesStack = new FortranBracesStack(this.codeStyle);
        for (int i = 0; i < this.stack.size(); ++i) {
            fortranBracesStack.stack.add((FortranStackEntry)this.stack.get(i));
        }
        fortranBracesStack.parenDepth = this.parenDepth;
        return fortranBracesStack;
    }

    public void reset(FortranBracesStack fortranBracesStack) {
        this.stack.clear();
        for (int i = 0; i < fortranBracesStack.stack.size(); ++i) {
            this.stack.add((FortranStackEntry)fortranBracesStack.stack.get(i));
        }
        this.parenDepth = fortranBracesStack.parenDepth;
    }

    public void push(Token<FortranTokenId> token, FortranExtendedTokenSequence fortranExtendedTokenSequence) {
        FortranStackEntry fortranStackEntry = new FortranStackEntry(token, fortranExtendedTokenSequence);
        this.pushImpl(fortranStackEntry);
    }

    public void push(FortranTokenId fortranTokenId) {
        FortranStackEntry fortranStackEntry = new FortranStackEntry(fortranTokenId);
        this.pushImpl(fortranStackEntry);
    }

    private void pushImpl(FortranStackEntry fortranStackEntry) {
        FortranStackEntry fortranStackEntry2 = this.peek();
        int n = 0;
        int n2 = 0;
        int n3 = this.codeStyle.indentSize();
        int n4 = this.codeStyle.indentSize();
        if (fortranStackEntry2 != null) {
            n = fortranStackEntry2.getIndent();
            n2 = fortranStackEntry2.getSelfIndent();
        }
        switch (fortranStackEntry.getKind()) {
            case KW_ELSEIF: 
            case KW_ELSE: {
                if (fortranStackEntry2 != null && (fortranStackEntry2.getKind() == FortranTokenId.KW_IF || fortranStackEntry2.getKind() == FortranTokenId.KW_ELSE || fortranStackEntry2.getKind() == FortranTokenId.KW_ELSEIF || fortranStackEntry2.getKind() == FortranTokenId.KW_WHERE || fortranStackEntry2.getKind() == FortranTokenId.KW_ELSE || fortranStackEntry2.getKind() == FortranTokenId.KW_ELSEWHERE)) {
                    fortranStackEntry.setIndent(n);
                    fortranStackEntry.setSelfIndent(n2);
                    break;
                }
                fortranStackEntry.setIndent(n + n3);
                fortranStackEntry.setSelfIndent(n);
                break;
            }
            case KW_IF: {
                if (fortranStackEntry2 != null && fortranStackEntry2.getKind() == FortranTokenId.KW_ELSE) {
                    fortranStackEntry.setIndent(n);
                    fortranStackEntry.setSelfIndent(n2);
                    break;
                }
                fortranStackEntry.setIndent(n + n3);
                fortranStackEntry.setSelfIndent(n);
                break;
            }
            case KW_WHERE: 
            case KW_DO: 
            case KW_FORALL: 
            case KW_WHILE: {
                fortranStackEntry.setIndent(n + n3);
                fortranStackEntry.setSelfIndent(n);
                break;
            }
            case KW_SELECT: 
            case KW_SELECTCASE: 
            case KW_SELECTTYPE: {
                if (this.codeStyle.indentCasesFromSwitch()) {
                    fortranStackEntry.setIndent(n2 + this.codeStyle.indentSize() + n4);
                    fortranStackEntry.setSelfIndent(n2);
                    break;
                }
                fortranStackEntry.setIndent(n2 + n4);
                fortranStackEntry.setSelfIndent(n2);
                break;
            }
            case KW_MODULE: 
            case KW_PROGRAM: 
            case KW_PROCEDURE: 
            case KW_SUBROUTINE: 
            case KW_FUNCTION: 
            case KW_BLOCK: {
                fortranStackEntry.setIndent(n + n3);
                fortranStackEntry.setSelfIndent(n);
                break;
            }
            case KW_INTERFACE: 
            case KW_STRUCTURE: 
            case KW_UNION: 
            case KW_ENUM: 
            case KW_TYPE: 
            case KW_BLOCKDATA: 
            case KW_MAP: {
                fortranStackEntry.setIndent(n + n3);
                fortranStackEntry.setSelfIndent(n);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.push(fortranStackEntry);
    }

    public int getIndent() {
        FortranStackEntry fortranStackEntry;
        int n = 0;
        if (!this.codeStyle.isFreeFormatFortran()) {
            n = 6;
        }
        if ((fortranStackEntry = this.peek()) != null) {
            return n + fortranStackEntry.getIndent();
        }
        return n;
    }

    public int getSelfIndent() {
        FortranStackEntry fortranStackEntry;
        int n = 0;
        if (!this.codeStyle.isFreeFormatFortran()) {
            n = 6;
        }
        if ((fortranStackEntry = this.peek()) != null) {
            return n + fortranStackEntry.getSelfIndent();
        }
        return n;
    }

    private void push(FortranStackEntry fortranStackEntry) {
        if (!(fortranStackEntry.getKind() != FortranTokenId.KW_ELSE && fortranStackEntry.getKind() != FortranTokenId.KW_ELSEIF && fortranStackEntry.getKind() != FortranTokenId.KW_ELSEWHERE || this.stack.size() <= 0 || this.stack.peek().getKind() != FortranTokenId.KW_IF && this.stack.peek().getKind() != FortranTokenId.KW_ELSE && this.stack.peek().getKind() != FortranTokenId.KW_ELSEIF && this.stack.peek().getKind() != FortranTokenId.KW_WHERE && this.stack.peek().getKind() != FortranTokenId.KW_ELSEWHERE)) {
            this.stack.pop();
        }
        this.stack.push(fortranStackEntry);
    }

    public void pop(FortranExtendedTokenSequence fortranExtendedTokenSequence) {
        this.popImpl(fortranExtendedTokenSequence);
    }

    public void popImpl(FortranExtendedTokenSequence fortranExtendedTokenSequence) {
        if (this.stack.empty()) {
            return;
        }
        this.stack.pop();
    }

    public FortranStackEntry peek() {
        if (this.stack.empty()) {
            return null;
        }
        return this.stack.peek();
    }

    public int getLength() {
        return this.stack.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.stack.size(); ++i) {
            FortranStackEntry fortranStackEntry = (FortranStackEntry)this.stack.get(i);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(fortranStackEntry.toString());
        }
        stringBuilder.append("+" + this.getIndent() + "-" + this.getSelfIndent());
        return stringBuilder.toString();
    }
}

