/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.editor.cplusplus.BracketCompletion;
import org.netbeans.modules.cnd.editor.cplusplus.DeleteToNextCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.InsertSemicolonAction;
import org.netbeans.modules.cnd.editor.cplusplus.NextCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.PreviousCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.SelectNextCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.SelectPreviousCamelCasePosition;
import org.netbeans.modules.cnd.editor.indent.HotCharIndent;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCKit
extends NbEditorKit {
    static final String previousCamelCasePosition = "previous-camel-case-position";
    static final String nextCamelCasePosition = "next-camel-case-position";
    static final String selectPreviousCamelCasePosition = "select-previous-camel-case-position";
    static final String selectNextCamelCasePosition = "select-next-camel-case-position";
    static final String deletePreviousCamelCasePosition = "delete-previous-camel-case-position";
    static final String deleteNextCamelCasePosition = "delete-next-camel-case-position";
    private InputAttributes lexerAttrs = null;

    public String getContentType() {
        return "text/x-c++";
    }

    public Document createDefaultDocument() {
        Document document = super.createDefaultDocument();
        return document;
    }

    protected void initDocument(BaseDocument baseDocument) {
        super.initDocument(baseDocument);
        baseDocument.putProperty(InputAttributes.class, (Object)this.getLexerAttributes());
        baseDocument.putProperty(Language.class, this.getLanguage());
    }

    protected Language<CppTokenId> getLanguage() {
        return CppTokenId.languageCpp();
    }

    protected final synchronized InputAttributes getLexerAttributes() {
        if (this.lexerAttrs == null) {
            this.lexerAttrs = new InputAttributes();
            this.lexerAttrs.setValue(this.getLanguage(), (Object)"lexer-filter", this.getFilter(), true);
        }
        return this.lexerAttrs;
    }

    protected Filter<CppTokenId> getFilter() {
        return CndLexerUtilities.getGccCppFilter();
    }

    protected Action getCommentAction() {
        return new ExtKit.CommentAction("//");
    }

    protected Action getUncommentAction() {
        return new ExtKit.UncommentAction("//");
    }

    protected Action getToggleCommentAction() {
        return new ExtKit.ToggleCommentAction("//");
    }

    protected Action[] createActions() {
        Action[] actionArray = super.createActions();
        Action[] actionArray2 = new Action[]{new CCDefaultKeyTypedAction(), new CCFormatAction(), new CCInsertBreakAction(), new CCDeleteCharAction("delete-previous", false), this.getToggleCommentAction(), this.getCommentAction(), this.getUncommentAction(), new NextCamelCasePosition(CCKit.findAction(actionArray, "caret-next-word")), new PreviousCamelCasePosition(CCKit.findAction(actionArray, "caret-previous-word")), new SelectNextCamelCasePosition(CCKit.findAction(actionArray, "selection-next-word")), new SelectPreviousCamelCasePosition(CCKit.findAction(actionArray, "selection-previous-word")), new DeleteToNextCamelCasePosition(CCKit.findAction(actionArray, "remove-word-next")), new DeleteToPreviousCamelCasePosition(CCKit.findAction(actionArray, "remove-word-previous")), new InsertSemicolonAction(true), new InsertSemicolonAction(false)};
        actionArray2 = TextAction.augmentList(actionArray, actionArray2);
        return actionArray2;
    }

    private static Action findAction(Action[] actionArray, String string) {
        for (Action action : actionArray) {
            Object object = action.getValue("Name");
            if (!(object instanceof String) || !string.equals(object)) continue;
            return action;
        }
        return null;
    }

    protected void updateActions() {
        super.updateActions();
        this.addSystemActionMapping("format", CCFormatAction.class);
    }

    public static class CCDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public CCDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
            BracketCompletion.charBackspaced(baseDocument, n, caret, c);
        }
    }

    public static class CCInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;
        static final boolean DEBUG = false;

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            int n = caret.getDot();
            if (BracketCompletion.posWithinString(baseDocument, n)) {
                try {
                    if (n >= 1 && DocumentUtilities.getText((Document)baseDocument).charAt(n - 1) != '\\' || n >= 2 && DocumentUtilities.getText((Document)baseDocument).charAt(n - 2) == '\\') {
                        baseDocument.insertString(n, "\"\"", null);
                        caret.setDot(++n);
                        return n;
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                try {
                    if (BracketCompletion.isAddRightBrace(baseDocument, n)) {
                        TokenSequence tokenSequence;
                        int n2 = BracketCompletion.getRowOrBlockEnd(baseDocument, n);
                        String string = "}";
                        TokenItem tokenItem = CndTokenUtilities.getFirstNonWhiteBwd((Document)baseDocument, (int)n2);
                        if (tokenItem == null || tokenItem.id() != CppTokenId.LBRACE) {
                            return Boolean.FALSE;
                        }
                        int n3 = tokenItem.offset();
                        int n4 = CndTokenUtilities.getLastCommandSeparator((Document)baseDocument, (int)(n3 - 1));
                        if (n4 == -1 && n3 > 0) {
                            n4 = 0;
                        }
                        if (n4 != -1 && n4 < n) {
                            tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)baseDocument, (int)n3, (boolean)false, (boolean)false);
                            block8: while (tokenSequence.movePrevious() && tokenSequence.offset() >= n4) {
                                switch ((CppTokenId)tokenSequence.token().id()) {
                                    case RPAREN: 
                                    case RBRACKET: {
                                        break block8;
                                    }
                                    case CLASS: 
                                    case UNION: 
                                    case STRUCT: 
                                    case ENUM: {
                                        string = "};";
                                        break block8;
                                    }
                                    default: {
                                        continue block8;
                                    }
                                }
                            }
                        }
                        baseDocument.insertString(n2, "\n" + string, null);
                        tokenSequence = Indent.get((Document)baseDocument);
                        tokenSequence.reindent(n2 + 1);
                        caret.setDot(n);
                        return Boolean.TRUE;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
            if (object != null && object instanceof Integer) {
                int n = caret.getDot();
                caret.setDot(n + 1);
            }
        }
    }

    public static class CCDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkIndentHotChars(JTextComponent jTextComponent, String string) {
            int n;
            BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
            if (HotCharIndent.INSTANCE.getKeywordBasedReformatBlock(baseDocument, n = jTextComponent.getCaretPosition(), string)) {
                Indent indent = Indent.get((Document)baseDocument);
                indent.lock();
                try {
                    baseDocument.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.TRUE);
                    indent.reindent(n);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                finally {
                    baseDocument.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.FALSE);
                    indent.unlock();
                }
            }
        }

        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            super.insertString(baseDocument, n, caret, string, bl);
            BracketCompletion.charInserted(baseDocument, n, caret, string.charAt(0));
        }
    }

    public class CCFormatAction
    extends BaseAction {
        public CCFormatAction() {
            super("format", 10);
            this.putValue("helpID", CCFormatAction.class.getName());
        }

        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                Cursor cursor = jTextComponent.getCursor();
                jTextComponent.setCursor(Cursor.getPredefinedCursor(3));
                baseDocument.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Position position;
                            int n;
                            Caret caret = jTextComponent.getCaret();
                            int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)caret.getDot());
                            if (Utilities.isSelectionShowing((Caret)caret)) {
                                n = jTextComponent.getSelectionStart();
                                position = baseDocument.createPosition(jTextComponent.getSelectionEnd());
                            } else {
                                n = 0;
                                position = baseDocument.createPosition(baseDocument.getLength());
                            }
                            int n3 = n;
                            Reformat reformat = Reformat.get((Document)baseDocument);
                            reformat.lock();
                            try {
                                reformat.reformat(n3, position.getOffset());
                            }
                            finally {
                                reformat.unlock();
                            }
                            n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n2);
                            if (n3 >= 0) {
                                caret.setDot(n3);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
                jTextComponent.setCursor(cursor);
            }
        }
    }
}

