/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartSteppingFilterImpl
implements SmartSteppingFilter {
    private final HashSet<String> filter = new HashSet();
    private final ArrayList<String> exact = new ArrayList();
    private final ArrayList<String> start = new ArrayList();
    private final ArrayList<String> end = new ArrayList();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Properties options = Properties.getDefault().getProperties("debugger.options.JPDA");
    private final Properties classFiltersProperties = Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters");
    private final PropertyChangeListener exclusionPatternsListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SmartSteppingFilterImpl.this.setExclusionPatterns();
        }
    };

    public SmartSteppingFilterImpl() {
        this.options.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.exclusionPatternsListener, (Object)this.options));
        this.classFiltersProperties.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.exclusionPatternsListener, (Object)this.classFiltersProperties));
        this.setExclusionPatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExclusionPatterns() {
        Set set = this.options.getBoolean("UseStepFilters", true) ? (Set)this.classFiltersProperties.getCollection("enabled", (Collection)Collections.EMPTY_SET) : Collections.EMPTY_SET;
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            this.filter.clear();
            this.exact.clear();
            this.start.clear();
            this.end.clear();
            this.filter.addAll(set);
            this.refreshFilters(set);
        }
        this.pcs.firePropertyChange("exclusionPatterns", null, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExclusionPatterns(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.removeAll(this.filter);
        if (hashSet.size() < 1) {
            return;
        }
        HashSet<String> hashSet2 = this.filter;
        synchronized (hashSet2) {
            this.filter.addAll(hashSet);
            this.refreshFilters(hashSet);
        }
        this.pcs.firePropertyChange("exclusionPatterns", null, hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExclusionPatterns(Set<String> set) {
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            this.filter.removeAll(set);
            this.exact.clear();
            this.start.clear();
            this.end.clear();
            this.refreshFilters(this.filter);
        }
        this.pcs.firePropertyChange("exclusionPatterns", set, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExclusionPatterns() {
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            String[] stringArray = new String[this.filter.size()];
            return this.filter.toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopHere(String string) {
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            int n;
            int n2 = this.exact.size();
            for (n = 0; n < n2; ++n) {
                if (!this.exact.get(n).equals(string)) continue;
                return false;
            }
            n2 = this.start.size();
            for (n = 0; n < n2; ++n) {
                if (!string.startsWith(this.start.get(n))) continue;
                return false;
            }
            n2 = this.end.size();
            for (n = 0; n < n2; ++n) {
                if (!string.endsWith(this.end.get(n))) continue;
                return false;
            }
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void refreshFilters(Set<String> set) {
        for (String string : set) {
            if (string.startsWith("*")) {
                this.end.add(string.substring(1));
                continue;
            }
            if (string.endsWith("*")) {
                this.start.add(string.substring(0, string.length() - 1));
                continue;
            }
            this.exact.add(string);
        }
    }
}

