/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.jira;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JButton;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.jira.DownloadPanel;
import org.netbeans.modules.bugtracking.jira.MissingJiraSupportPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DownloadPlugin
implements ActionListener {
    private DownloadPanel panel = new DownloadPanel();
    private JButton install = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Install"));
    private JButton cancel = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Cancel"));
    private UpdateElement jiraElement;
    private UpdateElement jiraLibraryElement;
    private boolean jiraElementInstalled = false;
    private boolean jiraLibraryElementInstalled = false;

    public DownloadPlugin() {
        this.install.setEnabled(false);
        this.panel.licensePanel.setVisible(false);
        this.panel.acceptCheckBox.addActionListener(this);
    }

    void startDownload() {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_LookingForJira"));
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl;
                List list;
                progressHandle.start();
                try {
                    list = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
                    for (UpdateUnit updateUnit : list) {
                        List list2;
                        if (updateUnit.getCodeName().equals("org.netbeans.modules.jira")) {
                            list2 = updateUnit.getAvailableUpdates();
                            if (list2.size() == 0) {
                                DownloadPlugin.this.jiraElementInstalled = true;
                            } else {
                                DownloadPlugin.this.jiraElement = (UpdateElement)updateUnit.getAvailableUpdates().get(0);
                            }
                        } else if (updateUnit.getCodeName().equals("org.netbeans.libs.jira")) {
                            list2 = updateUnit.getAvailableUpdates();
                            if (list2.size() == 0) {
                                DownloadPlugin.this.jiraLibraryElementInstalled = true;
                            } else {
                                DownloadPlugin.this.jiraLibraryElement = (UpdateElement)updateUnit.getAvailableUpdates().get(0);
                            }
                        }
                        if (DownloadPlugin.this.jiraElement == null || DownloadPlugin.this.jiraLibraryElement == null) continue;
                    }
                    if (DownloadPlugin.this.jiraLibraryElementInstalled && DownloadPlugin.this.jiraElementInstalled) {
                        DownloadPlugin.notifyError(NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_AlreadyInstalled"), NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_Error"));
                        return;
                    }
                }
                finally {
                    progressHandle.finish();
                }
                if (DownloadPlugin.this.jiraElement == null || DownloadPlugin.this.jiraLibraryElement == null) {
                    DownloadPlugin.notifyError(NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_JiraNotFound"), NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_Error"));
                    return;
                }
                ((DownloadPlugin)DownloadPlugin.this).panel.licensePanel.setVisible(true);
                ((DownloadPlugin)DownloadPlugin.this).panel.licenseTextPane.setText(DownloadPlugin.this.jiraElement.getLicence());
                ((DownloadPlugin)DownloadPlugin.this).panel.progressPanel.setVisible(false);
                DownloadPlugin.this.panel.repaint();
                list = new NotifyDescriptor((Object)DownloadPlugin.this.panel, NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_DownloadJira"), 2, -1, new Object[]{DownloadPlugin.this.install, DownloadPlugin.this.cancel}, (Object)DownloadPlugin.this.install);
                boolean bl2 = bl = DialogDisplayer.getDefault().notify((NotifyDescriptor)list) == DownloadPlugin.this.install;
                if (!bl) {
                    DownloadPlugin.this.jiraElement = null;
                    DownloadPlugin.this.jiraLibraryElement = null;
                    return;
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (DownloadPlugin.this.jiraLibraryElement != null) {
                            DownloadPlugin.this.install(DownloadPlugin.this.jiraLibraryElement, DownloadPlugin.this.jiraElement == null);
                        }
                        if (DownloadPlugin.this.jiraElement != null) {
                            DownloadPlugin.this.install(DownloadPlugin.this.jiraElement, true);
                        }
                    }
                });
            }
        });
    }

    private void install(UpdateElement updateElement, boolean bl) {
        try {
            InstallCancellable installCancellable = new InstallCancellable();
            OperationContainer operationContainer = OperationContainer.createForInstall();
            if (operationContainer.canBeAdded(updateElement.getUpdateUnit(), updateElement)) {
                operationContainer.add(updateElement);
            } else {
                if (updateElement.getUpdateUnit().isPending()) {
                    DownloadPlugin.notifyInDialog(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_MissingClient_RestartNeeded"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_MissingClient_RestartNeeded"), 1, false);
                    return;
                }
                operationContainer = OperationContainer.createForUpdate();
                if (operationContainer.canBeAdded(updateElement.getUpdateUnit(), updateElement)) {
                    operationContainer.add(updateElement);
                } else {
                    BugtrackingManager.LOG.warning("MissingClient: cannot install " + updateElement.toString());
                    if (updateElement.getUpdateUnit().getInstalled() != null) {
                        BugtrackingManager.LOG.warning("MissingClient: already installed " + updateElement.getUpdateUnit().getInstalled().toString());
                    }
                    DownloadPlugin.notifyInDialog(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_MissingClient_InvalidOperation"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_MissingClient_InvalidOperation"), 0, false);
                    return;
                }
            }
            InstallSupport.Validator validator = ((InstallSupport)operationContainer.getSupport()).doDownload(ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Downloading", (Object)updateElement.getDisplayName()), (Cancellable)installCancellable), false);
            if (installCancellable.cancelled) {
                return;
            }
            InstallSupport.Installer installer = ((InstallSupport)operationContainer.getSupport()).doValidate(validator, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Validating", (Object)updateElement.getDisplayName()), (Cancellable)installCancellable));
            if (installCancellable.cancelled) {
                return;
            }
            OperationSupport.Restarter restarter = ((InstallSupport)operationContainer.getSupport()).doInstall(installer, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Installing", (Object)updateElement.getDisplayName()), (Cancellable)installCancellable));
            if (bl && restarter != null) {
                JButton jButton = new JButton(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"CTL_Action_Restart"));
                JButton jButton2 = new JButton(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"CTL_Action_Cancel"));
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_NeedsRestart"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_DownloadJira"), 2, 3, new Object[]{jButton, jButton2}, (Object)jButton);
                if (DialogDisplayer.getDefault().notify(notifyDescriptor) == jButton) {
                    ((InstallSupport)operationContainer.getSupport()).doRestart(restarter, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Restarting")));
                }
            }
        }
        catch (OperationException operationException) {
            BugtrackingManager.LOG.log(Level.INFO, null, operationException);
            DownloadPlugin.notifyError(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_MissingClient_UC_Unavailable"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_MissingClient_UC_Unavailable"));
        }
    }

    private static void notifyError(String string, String string2) {
        DownloadPlugin.notifyInDialog(string, string2, 0, true);
    }

    private static void notifyInDialog(String string, String string2, int n, boolean bl) {
        Object[] objectArray;
        if (bl) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = NotifyDescriptor.OK_OPTION;
            objectArray = objectArray2;
            objectArray2[1] = NotifyDescriptor.CANCEL_OPTION;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = NotifyDescriptor.OK_OPTION;
        }
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, string2, -1, n, objectArray, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.acceptCheckBox) {
            this.install.setEnabled(this.panel.acceptCheckBox.isSelected());
        }
    }

    public UpdateElement getJiraElement() {
        return this.jiraElement;
    }

    public UpdateElement getJiraLibraryElement() {
        return this.jiraLibraryElement;
    }

    private class InstallCancellable
    implements Cancellable {
        private boolean cancelled;

        private InstallCancellable() {
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }
    }
}

