/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IssueNode
extends AbstractNode {
    public static final String LABEL_NAME_SEEN = "issue.seen";
    public static final String LABEL_RECENT_CHANGES = "issue.recent_changes";
    private Issue issue;
    private String htmlDisplayName;
    private Action preferedAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            IssueNode.this.issue.open(true);
        }
    };

    public IssueNode(Issue issue) {
        this(Children.LEAF, issue);
    }

    private IssueNode(Children children, Issue issue) {
        super(children, Lookups.fixed((Object[])new Object[]{issue}));
        this.issue = issue;
        this.initProperties();
        this.refreshHtmlDisplayName();
        IssueCacheUtils.addCacheListener(issue, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (IssueNode.this.issue != propertyChangeEvent.getSource()) {
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("issue.seen_changed")) {
                    IssueNode.this.fireSeenValueChanged((Boolean)propertyChangeEvent.getOldValue(), (Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    protected Issue getIssue() {
        return this.issue;
    }

    protected abstract Node.Property<?>[] getProperties();

    public Action getPreferredAction() {
        return this.preferedAction;
    }

    public boolean wasSeen() {
        return IssueCacheUtils.wasSeen(this.issue);
    }

    private void initProperties() {
        Node.Property<?>[] propertyArray;
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        for (Node.Property<?> property : propertyArray = this.getProperties()) {
            set.put(property);
        }
        sheet.put(set);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        this.htmlDisplayName = this.issue.getDisplayName();
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    void fireSeenValueChanged(final boolean bl, final boolean bl2) {
        if (bl != bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Node.Property<?>[] propertyArray;
                    IssueNode.this.firePropertyChange(IssueNode.LABEL_NAME_SEEN, bl, bl2);
                    for (Node.Property<?> property : propertyArray = IssueNode.this.getProperties()) {
                        String string;
                        if (!(property instanceof IssueProperty) || (string = ((IssueProperty)property).getName()).equals(IssueNode.LABEL_NAME_SEEN)) continue;
                        IssueNode.this.firePropertyChange(string, null, null);
                    }
                }
            });
        }
    }

    protected void fireDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Node.Property<?>[] propertyArray;
                for (Node.Property<?> property : propertyArray = IssueNode.this.getProperties()) {
                    if (!(property instanceof IssueProperty)) continue;
                    String string = ((IssueProperty)property).getName();
                    IssueNode.this.firePropertyChange(string, null, null);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RecentChangesProperty
    extends IssueProperty<String> {
        public RecentChangesProperty() {
            super(IssueNode.LABEL_RECENT_CHANGES, String.class, NbBundle.getMessage(Issue.class, (String)"CTL_Issue_Recent"), NbBundle.getMessage(Issue.class, (String)"CTL_Issue_Recent_Desc"));
        }

        public String getValue() {
            return IssueCacheUtils.getRecentChanges(this.getIssue());
        }

        @Override
        public int compareTo(IssueProperty issueProperty) {
            if (issueProperty == null) {
                return 1;
            }
            if (issueProperty instanceof RecentChangesProperty) {
                String string = IssueCacheUtils.getRecentChanges(this.getIssue());
                String string2 = IssueCacheUtils.getRecentChanges(((RecentChangesProperty)issueProperty).getIssue());
                return string.compareToIgnoreCase(string2);
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SeenProperty
    extends IssueProperty<Boolean> {
        public SeenProperty() {
            super(IssueNode.LABEL_NAME_SEEN, Boolean.class, "", NbBundle.getMessage(Issue.class, (String)"CTL_Issue_Seen_Desc"));
        }

        public Boolean getValue() {
            return IssueCacheUtils.wasSeen(IssueNode.this.issue);
        }

        @Override
        public int compareTo(IssueProperty issueProperty) {
            if (issueProperty == null) {
                return 1;
            }
            if (IssueNode.this.wasSeen()) {
                return 1;
            }
            if (IssueCacheUtils.wasSeen(issueProperty.getIssue())) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class IssueProperty<T>
    extends PropertySupport.ReadOnly<T>
    implements Comparable<IssueProperty> {
        protected IssueProperty(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception exception) {
                BugtrackingManager.LOG.log(Level.INFO, null, exception);
                return exception.getLocalizedMessage();
            }
        }

        public Issue getIssue() {
            return IssueNode.this.issue;
        }

        @Override
        public int compareTo(IssueProperty issueProperty) {
            return this.toString().compareTo(issueProperty.toString());
        }
    }
}

