/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SectionValidator;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletPanelFactory;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SimpleDialogPanel;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ServletsMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(ServletsMultiViewElement.class.getName());
    private SectionView view;
    private ToolBarDesignEditor comp;
    private DDDataObject dObj;
    private WebApp webApp;
    private ServletPanelFactory factory;
    private Action addAction;
    private Action removeAction;
    private boolean needInit = true;
    private int index;
    private RequestProcessor.Task repaintingTask;
    private static final String SERVLET_MV_ID = "dd_multiviewServlets";
    private static final String HELP_ID_PREFIX = "dd_multiview_servlets_";

    public ServletsMultiViewElement(DDDataObject dDDataObject, int n) {
        super((XmlMultiViewDataObject)dDDataObject);
        this.dObj = dDDataObject;
        this.index = n;
        this.comp = new ToolBarDesignEditor();
        this.factory = new ServletPanelFactory(this.comp, dDDataObject);
        this.addAction = new AddAction(dDDataObject, NbBundle.getMessage(ServletsMultiViewElement.class, (String)"LBL_addServlet"));
        this.removeAction = new RemoveAction(NbBundle.getMessage(ServletsMultiViewElement.class, (String)"LBL_remove"));
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ServletsMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (!this.dObj.isChangedFromUI() && (string = propertyChangeEvent.getPropertyName()).indexOf("Servlet") > 0) {
            MultiViewPerspective multiViewPerspective = this.dObj.getSelectedPerspective();
            if (multiViewPerspective != null && SERVLET_MV_ID.equals(multiViewPerspective.preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new ServletsView(this.webApp);
        this.comp.setContentView((PanelView)this.view);
        Object object = this.comp.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        } else {
            ServletsView servletsView = (ServletsView)this.view;
            Node node = servletsView.getServletsNode();
            Children children = node.getChildren();
            if (children.getNodesCount() > 0) {
                node = children.getNodes()[0];
            }
            servletsView.selectNode(node);
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction(String string) {
            super(string);
            char c = NbBundle.getMessage(ServletsMultiViewElement.class, (String)"LBL_remove_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            ConfirmDialog confirmDialog = new ConfirmDialog(NbBundle.getMessage(ServletsMultiViewElement.class, (String)"TXT_removeServletConfirm"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)confirmDialog);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(confirmDialog.getValue())) {
                SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
                Servlet servlet = (Servlet)sectionPanel.getKey();
                ServletsMultiViewElement.this.dObj.modelUpdatedFromUI();
                ServletsMultiViewElement.this.dObj.setChangedFromUI(true);
                try {
                    DDUtils.removeServletMappings(ServletsMultiViewElement.this.webApp, servlet.getServletName());
                    DDUtils.removeFilterMappingsForServlet(ServletsMultiViewElement.this.webApp, servlet.getServletName());
                    ServletsMultiViewElement.this.webApp.removeServlet(servlet);
                    sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                }
                finally {
                    ServletsMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction(DDDataObject dDDataObject, String string) {
            super(string);
            char c = NbBundle.getMessage(ServletsMultiViewElement.class, (String)"LBL_addServlet_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = new String[]{NbBundle.getMessage(ServletsMultiViewElement.class, (String)"LBL_servletName"), NbBundle.getMessage(ServletsMultiViewElement.class, (String)"LBL_servletClass"), NbBundle.getMessage(ServletsMultiViewElement.class, (String)"LBL_jspFile"), NbBundle.getMessage(ServletsMultiViewElement.class, (String)"LBL_description"), NbBundle.getMessage(ServletsMultiViewElement.class, (String)"LBL_urlPatterns")};
            String[] stringArray2 = new String[]{NbBundle.getMessage(ServletsMultiViewElement.class, (String)"ACSD_servletName"), NbBundle.getMessage(ServletsMultiViewElement.class, (String)"ACSD_servletClass"), NbBundle.getMessage(ServletsMultiViewElement.class, (String)"ACSD_jspFile"), NbBundle.getMessage(ServletsMultiViewElement.class, (String)"ACSD_description"), NbBundle.getMessage(ServletsMultiViewElement.class, (String)"ACSD_urlPatterns")};
            boolean[] blArray = new boolean[]{false, true, true, false, false};
            SimpleDialogPanel.DialogDescriptor dialogDescriptor = new SimpleDialogPanel.DialogDescriptor(stringArray, true);
            dialogDescriptor.setButtons(blArray);
            dialogDescriptor.setA11yDesc(stringArray2);
            dialogDescriptor.setTextField(new boolean[]{true, true, true, false, true});
            final SimpleDialogPanel simpleDialogPanel = new SimpleDialogPanel(dialogDescriptor);
            simpleDialogPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServletsMultiViewElement.class, (String)"ACS_add_servlet"));
            simpleDialogPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServletsMultiViewElement.class, (String)"ACSD_add_servlet"));
            simpleDialogPanel.getCustomizerButtons()[0].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SourceGroup[] sourceGroupArray = DDUtils.getJavaSourceGroups(ServletsMultiViewElement.this.dObj);
                        FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
                        if (fileObject != null) {
                            String string = DDUtils.getResourcePath(sourceGroupArray, fileObject);
                            simpleDialogPanel.getTextComponents()[1].setText(string);
                        }
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.FINE, "ignored exception", iOException);
                    }
                }
            });
            simpleDialogPanel.getCustomizerButtons()[1].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SourceGroup[] sourceGroupArray = DDUtils.getDocBaseGroups(ServletsMultiViewElement.this.dObj);
                        FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
                        if (fileObject != null) {
                            String string = "/" + DDUtils.getResourcePath(sourceGroupArray, fileObject, '/', true);
                            simpleDialogPanel.getTextComponents()[2].setText(string);
                        }
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.FINE, "ignored exception", iOException);
                    }
                }
            });
            EditDialog editDialog = new EditDialog((JPanel)simpleDialogPanel, NbBundle.getMessage(ServletsMultiViewElement.class, (String)"TTL_Servlet"), true){

                protected String validate() {
                    String[] stringArray = simpleDialogPanel.getValues();
                    String string = stringArray[0].trim();
                    String string2 = stringArray[1].trim();
                    String string3 = stringArray[2].trim();
                    String string4 = stringArray[4];
                    return SectionValidator.validateNewServlet(ServletsMultiViewElement.this.dObj.getWebApp(), string, string2, string3, string4);
                }
            };
            editDialog.setValid(false);
            EditDialog.DocListener docListener = new EditDialog.DocListener(editDialog);
            simpleDialogPanel.getTextComponents()[0].getDocument().addDocumentListener((DocumentListener)docListener);
            simpleDialogPanel.getTextComponents()[1].getDocument().addDocumentListener((DocumentListener)docListener);
            simpleDialogPanel.getTextComponents()[2].getDocument().addDocumentListener((DocumentListener)docListener);
            simpleDialogPanel.getTextComponents()[4].getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialog);
            dialog.setVisible(true);
            simpleDialogPanel.getTextComponents()[0].getDocument().removeDocumentListener((DocumentListener)docListener);
            simpleDialogPanel.getTextComponents()[1].getDocument().removeDocumentListener((DocumentListener)docListener);
            simpleDialogPanel.getTextComponents()[2].getDocument().removeDocumentListener((DocumentListener)docListener);
            simpleDialogPanel.getTextComponents()[4].getDocument().removeDocumentListener((DocumentListener)docListener);
            if (editDialog.getValue().equals(EditDialog.OK_OPTION)) {
                String[] stringArray3 = simpleDialogPanel.getValues();
                ServletsMultiViewElement.this.dObj.modelUpdatedFromUI();
                ServletsMultiViewElement.this.dObj.setChangedFromUI(true);
                try {
                    Servlet servlet = (Servlet)ServletsMultiViewElement.this.webApp.createBean("Servlet");
                    servlet.setServletName(stringArray3[0].trim());
                    String string = stringArray3[1].trim();
                    if (string.length() > 0) {
                        servlet.setServletClass(string);
                    } else {
                        servlet.setJspFile(stringArray3[2].trim());
                    }
                    String string2 = stringArray3[3].trim();
                    if (string2.length() > 0) {
                        servlet.setDescription(string2);
                    }
                    ServletsMultiViewElement.this.webApp.addServlet(servlet);
                    String[] stringArray4 = DDUtils.getStringArray(stringArray3[4]);
                    DDUtils.addServletMappings(ServletsMultiViewElement.this.webApp, servlet, stringArray4);
                    ServletsView servletsView = (ServletsView)ServletsMultiViewElement.this.comp.getContentView();
                    ServletNode servletNode = new ServletNode(servletsView, ServletsMultiViewElement.this.webApp, servlet);
                    servletsView.getServletsNode().getChildren().add(new Node[]{servletNode});
                    SectionPanel sectionPanel = new SectionPanel((SectionView)servletsView, (Node)servletNode, servletsView.getServletTitle(servlet), (Object)servlet);
                    sectionPanel.setHeaderActions(new Action[]{ServletsMultiViewElement.this.removeAction});
                    servletsView.getServletsContainer().addSection((NodeSectionPanel)sectionPanel, true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.log(Level.FINE, "ignored exception", classNotFoundException);
                }
                finally {
                    ServletsMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class ServletNode
    extends AbstractNode {
        ServletNode(SectionView sectionView, WebApp webApp, Servlet servlet) {
            super(Children.LEAF);
            this.setDisplayName(servlet.getServletName());
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/class.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_servlets_servletNode");
        }
    }

    class ServletsView
    extends SectionView {
        private SectionContainer servletsCont;
        private Node servletsNode;

        ServletsView(WebApp webApp) {
            super((InnerPanelFactory)ServletsMultiViewElement.this.factory);
            Servlet[] servletArray = webApp.getServlet();
            Node[] nodeArray = new Node[servletArray.length];
            Children.Array array = new Children.Array();
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray[i] = new ServletNode(this, webApp, servletArray[i]);
            }
            array.add(nodeArray);
            this.servletsNode = new SectionContainerNode((Children)array);
            this.servletsCont = new SectionContainer((SectionView)this, this.servletsNode, NbBundle.getMessage(ServletsMultiViewElement.class, (String)"TTL_servlets"), false);
            this.servletsCont.setHeaderActions(new Action[]{ServletsMultiViewElement.this.addAction});
            Children.Array array2 = new Children.Array();
            array2.add(new Node[]{this.servletsNode});
            AbstractNode abstractNode = new AbstractNode((Children)array2);
            SectionPanel[] sectionPanelArray = new SectionPanel[servletArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], this.getServletTitle(servletArray[i]), (Object)servletArray[i]);
                sectionPanelArray[i].setHeaderActions(new Action[]{ServletsMultiViewElement.this.removeAction});
                this.servletsCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
            }
            this.addSection((NodeSectionPanel)this.servletsCont);
            this.servletsNode.setDisplayName(NbBundle.getMessage(ServletsMultiViewElement.class, (String)"TTL_servlets"));
            this.servletsNode.setName("dd_multiview_servlets_servletsNode");
            this.setRoot((Node)abstractNode);
        }

        Node getServletsNode() {
            return this.servletsNode;
        }

        SectionContainer getServletsContainer() {
            return this.servletsCont;
        }

        String getServletTitle(Servlet servlet) {
            String string = servlet.getServletName();
            if (string == null) {
                string = "";
            }
            String string2 = DDUtils.urlPatternList(DDUtils.getUrlPatterns(ServletsMultiViewElement.this.webApp, servlet));
            return NbBundle.getMessage(ServletsMultiViewElement.class, (String)"TTL_servletPanel", (Object)string, (Object)string2);
        }

        public Error validateView() {
            Error error = ServletsMultiViewElement.this.getSectionView().getErrorPanel().getError();
            if (error != null) {
                return error;
            }
            return SectionValidator.validateServlets(ServletsMultiViewElement.this.webApp);
        }
    }
}

