/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.common.xmlutils;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.XMLJ2eeDataObject;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;

public class XMLJ2eeEditorSupport
extends DataEditorSupport
implements EditCookie,
EditorCookie.Observable,
LineCookie,
CloseCookie,
PrintCookie {
    private static final int AUTO_PARSING_DELAY = 2000;
    private DialogDescriptor dialog;
    private RequestProcessor.Task parsingDocumentTask;
    XMLJ2eeDataObject dataObject;

    public XMLJ2eeEditorSupport(XMLJ2eeDataObject xMLJ2eeDataObject) {
        super((DataObject)xMLJ2eeDataObject, (CloneableEditorSupport.Env)new XmlEnv(xMLJ2eeDataObject));
        this.dataObject = xMLJ2eeDataObject;
        this.setMIMEType("text/xml");
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        EditorKit editorKit2 = this.createEditorKit();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        editorKit2.write(bufferedWriter, (Document)styledDocument, 0, styledDocument.getLength());
        ((Writer)bufferedWriter).close();
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        EditorKit editorKit2 = this.createEditorKit();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        editorKit2.read(bufferedReader, (Document)styledDocument, 0);
        ((Reader)bufferedReader).close();
    }

    public void restartTimer() {
        this.dataObject.setDocumentDirty(true);
        Runnable runnable = new Runnable(){

            public void run() {
                XMLJ2eeEditorSupport.this.dataObject.parsingDocument();
            }
        };
        this.parsingDocumentTask = this.parsingDocumentTask == null || this.parsingDocumentTask.isFinished() || this.parsingDocumentTask.cancel() ? RequestProcessor.getDefault().post(runnable, 100) : RequestProcessor.getDefault().post(runnable, 2000);
    }

    protected boolean notifyModified() {
        boolean bl = super.notifyModified();
        if (!bl) {
            return false;
        }
        XMLJ2eeDataObject xMLJ2eeDataObject = (XMLJ2eeDataObject)this.getDataObject();
        if (xMLJ2eeDataObject.getCookie(SaveCookie.class) == null) {
            xMLJ2eeDataObject.addSaveCookie(new Save());
        }
        if (!xMLJ2eeDataObject.isNodeDirty()) {
            this.restartTimer();
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        XMLJ2eeDataObject xMLJ2eeDataObject = (XMLJ2eeDataObject)this.getDataObject();
        xMLJ2eeDataObject.removeSaveCookie();
    }

    public void saveDocument() throws IOException {
        final StyledDocument styledDocument = this.getDocument();
        String string = EncodingUtil.detectEncoding((Document)styledDocument);
        if (string == null) {
            string = "UTF8";
        }
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), string);
            if (!this.checkCharsetConversion(string)) {
                return;
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = NbBundle.getMessage(XMLJ2eeEditorSupport.class, (String)"TEXT_SAVE_AS_UTF", (Object)string);
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object.equals(NotifyDescriptor.YES_OPTION)) {
                try {
                    int n;
                    int n2 = Math.min(1000, styledDocument.getLength());
                    final char[] cArray = styledDocument.getText(0, n2).toCharArray();
                    int n3 = 0;
                    if (cArray[0] == '<' && cArray[1] == '?' && cArray[2] == 'x') {
                        for (n = 3; n < n2; ++n) {
                            if (cArray[n] != '?' || cArray[n + 1] != '>') continue;
                            n3 = n + 1;
                            break;
                        }
                    }
                    n = n3;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            block2: {
                                try {
                                    styledDocument.remove(0, n + 1);
                                    styledDocument.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(cArray, 0, n + 1) + " -->", null);
                                }
                                catch (BadLocationException badLocationException) {
                                    if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                    badLocationException.printStackTrace();
                                }
                            }
                        }
                    };
                    NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
                    super.saveDocument();
                    this.getDataObject().setModified(false);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            return;
        }
    }

    private boolean checkCharsetConversion(String string) {
        boolean bl = true;
        try {
            CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
            if (!charsetEncoder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(XMLJ2eeEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string}), 0, 2);
                confirmation.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                    bl = false;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger("global").log(Level.INFO, null, badLocationException);
        }
        return bl;
    }

    public UndoRedo.Manager getUndo() {
        return this.getUndoRedo();
    }

    protected String messageName() {
        String string = super.messageName();
        int n = string.indexOf(91);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            int n2 = string.lastIndexOf(93);
            String string3 = "";
            if (n2 >= 0) {
                string3 = string.substring(n2 + 1);
            }
            return string2 + string3;
        }
        return string;
    }

    private static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public XmlEnv(XMLJ2eeDataObject xMLJ2eeDataObject) {
            super((DataObject)xMLJ2eeDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((XMLJ2eeDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (XMLJ2eeEditorSupport)this.getDataObject().getCookie(XMLJ2eeEditorSupport.class);
        }
    }

    private class Save
    implements SaveCookie {
        private Save() {
        }

        public void save() throws IOException {
            XMLJ2eeDataObject xMLJ2eeDataObject = (XMLJ2eeDataObject)XMLJ2eeEditorSupport.this.getDataObject();
            if (xMLJ2eeDataObject.isDocumentValid()) {
                xMLJ2eeDataObject.setSavingDocument(true);
                XMLJ2eeEditorSupport.this.saveDocument();
            } else {
                xMLJ2eeDataObject.displayErrorMessage();
                XMLJ2eeEditorSupport.this.dialog = new DialogDescriptor((Object)NbBundle.getMessage(XMLJ2eeEditorSupport.class, (String)"MSG_invalidXmlWarning"), NbBundle.getMessage(XMLJ2eeEditorSupport.class, (String)"TTL_invalidXmlWarning"));
                Dialog dialog = DialogDisplayer.getDefault().createDialog(XMLJ2eeEditorSupport.this.dialog);
                dialog.setVisible(true);
                if (XMLJ2eeEditorSupport.this.dialog.getValue() == DialogDescriptor.OK_OPTION) {
                    xMLJ2eeDataObject.setSavingDocument(true);
                    XMLJ2eeEditorSupport.this.saveDocument();
                }
            }
        }
    }
}

