/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mobility.cldcplatform.ArchiveFilter;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SrcDocPathsPanel
extends JPanel
implements ListSelectionListener {
    private static final Dimension PREF_DIM = new Dimension(560, 350);
    J2MEPlatform platform;
    DefaultListModel srcModel;
    DefaultListModel docModel;
    private JButton bDocAdd;
    private JButton bDocRemove;
    private JButton bSrcAdd;
    private JButton bSrcRemove;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList lDocPaths;
    private JList lSrcPaths;

    public SrcDocPathsPanel() {
        this.initComponents();
        this.initAccessibility();
        this.lDocPaths.addListSelectionListener(this);
        this.lSrcPaths.addListSelectionListener(this);
        this.srcModel = new DefaultListModel();
        this.lSrcPaths.setModel(this.srcModel);
        this.docModel = new DefaultListModel();
        this.lDocPaths.setModel(this.docModel);
        this.platform = null;
    }

    public void readData(WizardDescriptor wizardDescriptor) {
        this.platform = (J2MEPlatform)((Object)wizardDescriptor.getProperty("Platform"));
        if (this.platform == null) {
            return;
        }
        FileObject[] fileObjectArray = this.platform.getSourceFolders().getRoots();
        this.srcModel.clear();
        if (fileObjectArray != null) {
            for (FileObject fileObject : fileObjectArray) {
                this.srcModel.addElement(new ListItem<Object>(fileObject));
            }
        }
        List<URL> list = this.platform.getJavadocFolders();
        this.docModel.clear();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                this.docModel.addElement(new ListItem<URL>(uRL));
            }
        }
        this.updateButtons();
    }

    public void storeData(WizardDescriptor wizardDescriptor) {
        if (this.platform == null) {
            return;
        }
        Object[] objectArray = this.srcModel.toArray();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (objectArray != null) {
            for (Object object : objectArray) {
                arrayList.add((FileObject)((ListItem)object).getObject());
            }
        }
        this.platform.setSourceFolders(arrayList);
        objectArray = this.docModel.toArray();
        ArrayList arrayList2 = new ArrayList();
        if (objectArray != null) {
            for (Object object : objectArray) {
                arrayList2.add(((ListItem)object).getObject());
            }
        }
        this.platform.setJavadocFolders(arrayList2);
    }

    private String browse(String string) {
        File file = new FileChooserBuilder(SrcDocPathsPanel.class).setFileFilter((FileFilter)new ArchiveFilter()).setTitle(string).showOpenDialog();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lSrcPaths = new JList();
        this.bSrcAdd = new JButton();
        this.bSrcRemove = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lDocPaths = new JList();
        this.bDocAdd = new JButton();
        this.bDocRemove = new JButton();
        this.setName(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TITLE_J2MEWizardIterator_PathsPanel"));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.lSrcPaths);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_Sources"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.lSrcPaths.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lSrcPaths);
        this.lSrcPaths.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"ACD_SrcDocPathsPanel_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSrcAdd, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_Add"));
        this.bSrcAdd.setToolTipText(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TTT_SrcDocPathsPanel_SrcAdd"));
        this.bSrcAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SrcDocPathsPanel.this.bSrcAddActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bSrcAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSrcRemove, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_Remove"));
        this.bSrcRemove.setToolTipText(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TTT_SrcDocPathsPanel_SrcRemove"));
        this.bSrcRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SrcDocPathsPanel.this.bSrcRemoveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bSrcRemove, gridBagConstraints);
        this.jLabel2.setLabelFor(this.lDocPaths);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_JavaDocs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.lDocPaths.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.lDocPaths);
        this.lDocPaths.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"ACD_SrcDocPathsPanel_Javadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bDocAdd, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_Add"));
        this.bDocAdd.setToolTipText(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TTT_SrcDocPathsPanel_JavadocAdd"));
        this.bDocAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SrcDocPathsPanel.this.bDocAddActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bDocAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bDocRemove, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_Remove"));
        this.bDocRemove.setToolTipText(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TTT_SrcDocPathsPanel_JavadocRemove"));
        this.bDocRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SrcDocPathsPanel.this.bDocRemoveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.bDocRemove, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"ACN_SrcDocPathsPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"ACD_SrcDocPathsPanel"));
    }

    private void initAccessibility() {
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bDocRemoveActionPerformed(ActionEvent actionEvent) {
        int n = this.lDocPaths.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.docModel.removeElementAt(n);
        this.lDocPaths.setSelectedIndex(n < this.docModel.size() ? n : n - 1);
        this.updateButtons();
    }

    private void bSrcRemoveActionPerformed(ActionEvent actionEvent) {
        int n = this.lSrcPaths.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.srcModel.removeElementAt(n);
        this.lSrcPaths.setSelectedIndex(n < this.srcModel.size() ? n : n - 1);
        this.updateButtons();
    }

    private void bDocAddActionPerformed(ActionEvent actionEvent) {
        if (this.platform == null) {
            return;
        }
        String string = this.browse(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TITLE_SDPathsPanel_SelectJavaDoc"));
        if (string == null) {
            return;
        }
        URL uRL = J2MEPlatform.localfilepath2url(string);
        if (uRL != null) {
            ListItem<URL> listItem = new ListItem<URL>(uRL);
            this.docModel.addElement(listItem);
            this.lDocPaths.setSelectedValue(listItem, true);
        }
        this.updateButtons();
    }

    private void bSrcAddActionPerformed(ActionEvent actionEvent) {
        if (this.platform == null) {
            return;
        }
        String string = this.browse(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TITLE_SDPathsPanel_SelectSource"));
        if (string == null) {
            return;
        }
        FileObject fileObject = this.platform.resolveRelativePathToFileObject(string);
        if (fileObject != null) {
            ListItem<FileObject> listItem = new ListItem<FileObject>(fileObject);
            this.srcModel.addElement(listItem);
            this.lSrcPaths.setSelectedValue(listItem, true);
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.bDocRemove.setEnabled(this.lDocPaths.getSelectedIndex() >= 0);
        this.bSrcRemove.setEnabled(this.lSrcPaths.getSelectedIndex() >= 0);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    public static class WizardPanel
    implements WizardDescriptor.FinishablePanel {
        SrcDocPathsPanel component;
        WizardDescriptor wizard;
        ArrayList<ChangeListener> listeners = new ArrayList();
        boolean valid = false;
        boolean finishable;

        public WizardPanel(boolean bl) {
            this.finishable = bl;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new SrcDocPathsPanel();
                this.checkValid();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(SrcDocPathsPanel.class);
        }

        public boolean isFinishPanel() {
            return this.finishable;
        }

        public void showError(String string) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
            }
        }

        public boolean isValid() {
            return true;
        }

        public void readSettings(Object object) {
            this.wizard = (WizardDescriptor)object;
            ((SrcDocPathsPanel)this.getComponent()).readData(this.wizard);
        }

        public void storeSettings(Object object) {
            this.wizard = (WizardDescriptor)object;
            ((SrcDocPathsPanel)this.getComponent()).storeData(this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }

        void checkValid() {
            if (this.isValid() != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListItem<T> {
        T o;
        String str;

        ListItem(T t) {
            this.o = t;
            if (t instanceof FileObject) {
                this.str = J2MEPlatform.getFilePath((FileObject)t);
            } else if (t instanceof URL) {
                this.str = J2MEPlatform.getFilePath(URLMapper.findFileObject((URL)((URL)t)));
            }
            if (this.str == null) {
                this.str = t != null ? t.toString() : "";
            }
        }

        T getObject() {
            return this.o;
        }

        public String toString() {
            return this.str;
        }
    }
}

